/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.display.service.impl;

import com.baijia.tianxiao.constants.DataProcType;
import com.baijia.tianxiao.dal.show.dao.OrgShowInfoDao;
import com.baijia.tianxiao.dal.show.po.OrgShowInfo;
import com.baijia.tianxiao.sal.display.dto.FieldDto;
import com.baijia.tianxiao.sal.display.service.OrgShowService;
import com.baijia.tianxiao.dto.FieldShow;
import com.baijia.tianxiao.util.json.JacksonUtil;

import com.google.common.base.Preconditions;

import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

import javax.annotation.Resource;

import lombok.extern.slf4j.Slf4j;

/**
 * @title OrgShowServiceImpl
 * @desc TODO
 * @author shanyu
 * @date 2016年3月14日
 * @version 1.0
 */
@Slf4j
@Service
public class OrgShowServiceImpl implements OrgShowService {

    @Resource
    private OrgShowInfoDao orgShowInfoDao;

    @Override
    public List<FieldDto> getCurrentHeaders(Long orgId, DataProcType queryListEnum, Class<?> cls) {
        OrgShowInfo info = this.orgShowInfoDao.getShowInfo(orgId, queryListEnum.getType(), "content");
        if (info != null && StringUtils.isNoneBlank(info.getContent())) {
            try {
                log.debug("show info:{}", info);
                return buildFieldDto(JacksonUtil.str2List(info.getContent(), FieldShow.class));
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return buildFieldDto(FieldShow.getColumnShows(cls));
    }

    private List<FieldDto> buildFieldDto(List<FieldShow> shows) {
        List<FieldDto> dtos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(shows)) {
            for (FieldShow show : shows) {
                FieldDto dto = new FieldDto();
                dto.setName(show.getName());
                dto.setLock(show.getLock());
                dto.setSort(show.getOperate());
                dto.setType(show.getType());
                dto.setShowName(show.getShowName());
                dto.setHidden(show.getViewType() == 1 ? 0 : 1);
                dtos.add(dto);
            }
        }
        return dtos;
    }

    private List<FieldShow> buildFieldShow(List<FieldDto> dtos) {
        List<FieldShow> shows = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(dtos)) {
            for (FieldDto dto : dtos) {
                FieldShow show = new FieldShow();
                show.setName(dto.getName());
                show.setLock(dto.getLock());
                show.setOperate(dto.getSort());
                show.setShowName(dto.getShowName());
                dto.setHidden(dto.getHidden() == 1 ? 0 : 1);
                shows.add(show);
            }
        }
        return shows;
    }

    @Override
    public List<FieldDto> getAllHeaders(Class<?> cls) {
        return buildFieldDto(FieldShow.getColumnShows(cls));
    }

    @Override
    public void modHeaders(Long orgId, List<FieldDto> dtos, DataProcType queryListEnum, Class<?> cls) {
        List<FieldShow> fields = buildFieldShow(dtos);
        Preconditions.checkArgument(FieldShow.isFieldsUsable(cls, fields), "some error with fields!");
        OrgShowInfo info = this.orgShowInfoDao.getShowInfo(orgId, queryListEnum.getType());
        if (info != null) {
            info.setContent(JacksonUtil.obj2Str(fields));
            this.orgShowInfoDao.update(info, "content");
        } else {
            info = new OrgShowInfo();
            info.setOrgId(orgId);
            info.setType(queryListEnum.getType());
            info.setContent(JacksonUtil.obj2Str(fields));
            this.orgShowInfoDao.save(info, false);
        }
    }

}
