/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.course.service.impl;

import com.baijia.tianxiao.common.service.ImportDataProcessService;
import com.baijia.tianxiao.constants.DataProcType;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.course.constant.CourseErrorCode;
import com.baijia.tianxiao.sal.course.dto.OrgCourseInfoDto;
import com.baijia.tianxiao.sal.course.service.OrgCourseService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="ImportOrgCourseProcessService")
public class ImportOrgCourseProcessServiceImpl
implements ImportDataProcessService {
    private static final Logger log = LoggerFactory.getLogger(ImportOrgCourseProcessServiceImpl.class);
    @Resource
    private OrgCourseService orgCourseService;
    private static final ImportDataProcessService.SingleSaveErrorResult IMPORT_SUCCESS = ImportDataProcessService.SingleSaveErrorResult.createSuccessResult((String)"\u5bfc\u5165\u6210\u529f");
    private static final ImportDataProcessService.SingleSaveErrorResult COURSE_EXSIST = new ImportDataProcessService.SingleSaveErrorResult(true, "\u8bfe\u7a0b\u91cd\u590d");
    private static final Map<String, CourseFormat> colMap = Maps.newHashMap();

    static {
        colMap.put("\u8bfe\u7a0b\u540d\u79f0", new CourseFormat("courseName", ".{0,20}", "\u3010\u8bfe\u7a0b\u540d\u79f0\u3011\u5fc5\u987b\u662f1-20\u4e2a\u6587\u5b57"));
        colMap.put("\u4e0a\u8bfe\u6b21\u6570", new CourseFormat("freq", "^[0-9]*$", "\u3010\u4e0a\u8bfe\u6b21\u6570\u3011\u9700\u4e3a\u5927\u4e8e0\u7684\u6574\u6570"));
        colMap.put("\u73ed\u7ea7\u4eba\u6570", new CourseFormat("maxStudent", "^[0-9]*$", "\u3010\u73ed\u7ea7\u4eba\u6570\u3011\u9700\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6574\u6570"));
        colMap.put("\u4ef7\u683c", new CourseFormat("coursePrice", "^(?!0(\\d|\\.0+$|$))\\d+(\\.\\d{1,2})?$", "\u3010\u4ef7\u683c\u3011\u9700\u4e3a\u5927\u4e8e0\u7684\u6570\u5b57"));
    }

    public boolean validateHeader(List<String> headers) {
        for (String headName : headers) {
            if (colMap.get(headName.trim()) != null) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws IllegalAccessException, InvocationTargetException {
        OrgCourseInfoDto dto = new OrgCourseInfoDto();
        String value = "9999999.99";
        BeanUtils.setProperty((Object)dto, (String)"coursePrice", (Object)value);
        log.info("dto={}", (Object)dto);
        log.info("={}", (Object)Pattern.matches("^[0-9]{1,9}\\.{0,1}[0-9]{0,2}$", "11.444"));
        log.info("={}", (Object)Pattern.matches(".{1,20}", "123456789012345678900"));
        log.info("={}", (Object)Pattern.matches("^[0-9]+$", "11.0"));
        BeanUtils.setProperty((Object)dto, (String)"courseNumber", null);
        System.out.println(dto);
        System.out.println(Pattern.matches("^[1-9]{1,9}\\.{0,1}[0-9]{0,2}$", "11.013"));
        System.out.println(Pattern.matches(".{1,20}", "123456789012345678900"));
        System.out.println(Pattern.matches("^[0-9]+$", "11"));
        System.out.println(Pattern.matches("^(?!0(\\d|\\.0+$|$))\\d+(\\.\\d{1,2})?$", "0.01"));
    }

    private void buildOrgCourseInfoDto(OrgCourseInfoDto dto, Object[] lineData, List<String> headers) {
        Preconditions.checkArgument((lineData.length == headers.size() ? 1 : 0) != 0, (Object)"\u6570\u636e\u6570\u76ee\u548c\u8868\u5934\u4e0d\u5339\u914d");
        Preconditions.checkArgument((boolean)this.validateHeader(headers), (Object)("\u8868\u5934\u683c\u5f0f\u9519\u8bef:" + headers.toString()));
        int i = 0;
        while (i < lineData.length) {
            block5: {
                CourseFormat fmt = colMap.get(headers.get(i));
                String fieldName = fmt.getFieldName();
                Object value = lineData[i];
                if (fieldName != null) {
                    try {
                        if (value != null && (!(value instanceof String) || !StringUtils.isBlank((String)((String)value)) && Pattern.matches(fmt.getFormatRegex(), value.toString()))) {
                            BeanUtils.setProperty((Object)dto, (String)fieldName, (Object)value);
                            break block5;
                        }
                        throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, fmt.getFmtErrorMsg());
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        log.warn("set OrgCourseInfoDto.{} = {} failed!", (Object)fieldName, value);
                        throw new BussinessException((UniverseErrorCode)CourseErrorCode.COURSE_IMPORT_COL_FORMAT_ERROR);
                    }
                }
            }
            ++i;
        }
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public ImportDataProcessService.SingleSaveErrorResult saveSingleData(Long orgId, Long cascadeId, List<String> headers, Object[] lineData, boolean updateRepeat) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"illegal orgId.");
        Preconditions.checkArgument((lineData != null && lineData.length > 0 ? 1 : 0) != 0, (Object)"lineData \u4e3a\u7a7a");
        try {
            OrgCourseInfoDto course = new OrgCourseInfoDto();
            this.buildOrgCourseInfoDto(course, lineData, headers);
            this.orgCourseService.saveOrUpdateCourse(orgId, course, false, updateRepeat);
        }
        catch (BussinessException ex) {
            if (ex.getErrorCode().getSubsystemErrorCode() == CourseErrorCode.COURSE_EXSIST.getSubsystemErrorCode()) {
                return COURSE_EXSIST;
            }
            log.error("save course error:{}", (Throwable)ex);
            throw ex;
        }
        catch (Throwable ex) {
            log.error("save course error:{}", ex);
            throw ex;
        }
        return IMPORT_SUCCESS;
    }

    public ImportDataProcessService.BatchSaveResult batchImportDatas(Long orgId, Long cascadeId, List<String> headers, List<Object[]> datas, boolean updateRepeat) {
        ImportDataProcessService.BatchSaveResult batchSaveResult = new ImportDataProcessService.BatchSaveResult();
        int i = 0;
        while (i < datas.size()) {
            Object[] data = datas.get(i);
            try {
                ImportDataProcessService.SingleSaveErrorResult singleSaveErrorResult = this.saveSingleData(orgId, cascadeId, headers, data, updateRepeat);
                if (singleSaveErrorResult.isRepeat()) {
                    batchSaveResult.getRepeatIndexs().add(i);
                }
            }
            catch (Throwable ex) {
                batchSaveResult.getFailIndexs().add(i);
            }
            ++i;
        }
        return batchSaveResult;
    }

    public DataProcType getProcessType() {
        return DataProcType.COURSE;
    }

    public void afterComplete() {
        log.info("[Upload] upload complete!");
    }

    public int[] getUniqueIndex() {
        return null;
    }

    public void downloadValidateResult(OutputStream os, Long orgId, String taskId, Collection<ImportDataProcessService.SingleSaveErrorResult> dataMap) {
    }

    public void downloadImportResult(OutputStream os, Long orgId, String taskId, Collection<ImportDataProcessService.SingleSaveErrorResult> data) {
    }

    public void downloadImportTemplate(OutputStream os) {
    }

    public ImportDataProcessService.SingleSaveErrorResult validate(Long orgId, Long cascadeId, List<String> headers, ImportDataProcessService.SingleSaveErrorResult result, List<ImportDataProcessService.SingleSaveErrorResult> dataMap, boolean updateRepeat) {
        return null;
    }

    public String validateResult(List<ImportDataProcessService.SingleSaveErrorResult> list) {
        return null;
    }

    public boolean validateHeader(List<String> headers, Long orgId) {
        return false;
    }

    public static class CourseFormat {
        private String fieldName;
        private String formatRegex;
        private String formatMsg;

        public CourseFormat(String fieldName, String formatRegex, String formatMsg) {
            this.fieldName = fieldName;
            this.formatRegex = formatRegex;
            this.formatMsg = formatMsg;
        }

        String getFmtErrorMsg() {
            return this.formatMsg;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getFormatRegex() {
            return this.formatRegex;
        }

        public String getFormatMsg() {
            return this.formatMsg;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public void setFormatRegex(String formatRegex) {
            this.formatRegex = formatRegex;
        }

        public void setFormatMsg(String formatMsg) {
            this.formatMsg = formatMsg;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CourseFormat)) {
                return false;
            }
            CourseFormat other = (CourseFormat)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$fieldName = this.getFieldName();
            String other$fieldName = other.getFieldName();
            if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
                return false;
            }
            String this$formatRegex = this.getFormatRegex();
            String other$formatRegex = other.getFormatRegex();
            if (this$formatRegex == null ? other$formatRegex != null : !this$formatRegex.equals(other$formatRegex)) {
                return false;
            }
            String this$formatMsg = this.getFormatMsg();
            String other$formatMsg = other.getFormatMsg();
            return !(this$formatMsg == null ? other$formatMsg != null : !this$formatMsg.equals(other$formatMsg));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CourseFormat;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $fieldName = this.getFieldName();
            result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
            String $formatRegex = this.getFormatRegex();
            result = result * 59 + ($formatRegex == null ? 43 : $formatRegex.hashCode());
            String $formatMsg = this.getFormatMsg();
            result = result * 59 + ($formatMsg == null ? 43 : $formatMsg.hashCode());
            return result;
        }

        public String toString() {
            return "ImportOrgCourseProcessServiceImpl.CourseFormat(fieldName=" + this.getFieldName() + ", formatRegex=" + this.getFormatRegex() + ", formatMsg=" + this.getFormatMsg() + ")";
        }
    }
}

