package com.baijia.tianxiao.sal.course.service.impl;

import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constant.LessonStatus;
import com.baijia.tianxiao.constant.LessonType;
import com.baijia.tianxiao.constant.OrgLessonSignSourceEnum;
import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.constants.sms.TxSmsCodeType;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseConsumeRuleDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseConsumeRule;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.dal.org.po.TXSaleClueRule;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.dal.wechat.constant.WechateTemplateMsgType;
import com.baijia.tianxiao.dto.smstoken.StudentSmsTokenDto;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.RedisKeyEnums;
import com.baijia.tianxiao.enums.StudentCourseStatus;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoMContext;
import com.baijia.tianxiao.sal.common.api.CommonMsgService;
import com.baijia.tianxiao.sal.common.dto.msg.SendMsgRequest;
import com.baijia.tianxiao.sal.common.dto.wechatMsgRequest.SignWechatTemplateMsg;
import com.baijia.tianxiao.sal.common.utils.NotifyMessageUtils;
import com.baijia.tianxiao.sal.common.utils.WechatTemplateMsgHelper;
import com.baijia.tianxiao.sal.course.dto.SignStatusRemarkDto;
import com.baijia.tianxiao.sal.course.dto.SigninMsgAsynModel;
import com.baijia.tianxiao.sal.course.dto.request.SignWithRemarkRequest;
import com.baijia.tianxiao.sal.course.dto.response.LessonSignReportDto;
import com.baijia.tianxiao.sal.course.dto.response.OrgStudentLessonSignDto;
import com.baijia.tianxiao.sal.course.dto.response.SigninFailedDto;
import com.baijia.tianxiao.sal.course.exceptions.SignErrorCode;
import com.baijia.tianxiao.sal.course.service.OrgLessonSignService;
import com.baijia.tianxiao.sal.course.service.OrgSignupCourseLessonService;
import com.baijia.tianxiao.sal.course.util.ErpUtils;
import com.baijia.tianxiao.sal.kexiao.service.KexiaoChangeLogService;
import com.baijia.tianxiao.sal.kexiao.utils.KexiaoUtil;
import com.baijia.tianxiao.sal.organization.org.service.TXSaleClueRuleService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.SmsContentHelper;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;

import javax.annotation.Resource;

import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;

@Service
@Slf4j
public class OrgLessonSignServiceImpl implements OrgLessonSignService {

    @Deprecated
    private static String smsContent = "%s你好，你已经在%s的%s%s完成签到，状态为“%s”。如有疑问，请拨打4000122166转%s";

    @Deprecated
    private static String smsContentWithRemark = "%s你好，你已经在%s的%s%s完成签到，状态为“%s”，备注为“%s”。如有疑问，请拨打4000122166转%s";

    private static String content = "你好:\n %s你已经在%s的%s完成签到，状态为“%s”。";

    private static String contentWithRemark = "你好:\n %s你已经在%s的%s完成签到，状态为“%s”，备注为“%s”。";

    private static String remark = "\n请点击消息查看课表，如果对签到情况有疑问，您可致电4000122166转%s";

    private static String course = "%s第%s次课";

    private final static String SIGN_TIP = "%s剩余%s不足,修改签到状态后,系统会将该课节标记为学员的赠送课,确认修改签到状态吗?";

    private static String defaultName = "-";

    @Resource
    private OrgLessonSignDao orgLessonSignDao;

    @Resource
    private OrgAccountDao orgAccountDao;

    @Resource
    private OrgStudentDao orgStudentDao;

    @Resource
    private OrgClassLessonDao orgClassLessonDao;

    @Resource
    private OrgCourseDao orgCourseDao;

    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;

    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;

    @Resource
    private TXSaleClueRuleService tXSaleClueRuleService;

    @Autowired(required = false)
    private CommonMsgService commonMsgService;

    @Autowired
    private StringRedisTemplate redisTemplate;

    @Autowired
    private KexiaoChangeLogService changeLogService;
    @Autowired
    private OrgSignupCourseLessonService courseLessonService;
    @Autowired
    private OrgCourseConsumeRuleDao courseConsumeRuleDao;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public SigninFailedDto orgStudentLessonBatchSign(Long orgId, Long lessonId, List<Long> studentIds, Integer status,
        int confirm) {
        if (CollectionUtils.isEmpty(studentIds) || lessonId == null) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "课节ID和学生ID不能为空");
        }
        Long cascadeId = TianxiaoMContext.getTXCascadeIdLongZeroFill();
        OrgClassLesson lesson = orgClassLessonDao.getByIdForUpdate(lessonId);
        Preconditions.checkArgument(lesson != null && orgId.equals(lesson.getOrgId()), "课节ID不正确");
        Preconditions.checkArgument(status != null && status >= 0, "签到状态不正确");
        Map<Long, Long> studentIdUserIdMap = orgStudentDao.getStudentIdUserIdMap(studentIds);
        Collection<Long> userIdList = studentIdUserIdMap.values();
        Long courseId = orgClassLessonDao.getById(lessonId, "courseId").getCourseId();

        OrgCourse course = orgCourseDao.getById(lesson.getCourseId());
        Preconditions.checkArgument(course != null, " 课节ID不正确");

        log.info("orgId:{}, courseId:{}, userIdList:{}", orgId, courseId, userIdList);
        // 退转班的学生
        Map<Long, Integer> uIdStatusWithdrawMap = orgStudentCourseDao.userMapByStatus(orgId, courseId, userIdList,
            Arrays.asList(StudentCourseStatus.WITHDRAW.getCode(), StudentCourseStatus.TRANSFER.getCode()));
        Collection<Long> inValidUserIds = CollectionUtils.intersection(userIdList, uIdStatusWithdrawMap.keySet());
        SigninFailedDto result = new SigninFailedDto();
        for (Long userId : inValidUserIds) {
            result.addFailedStudent(new SigninFailedDto.FailedStudent(userId, uIdStatusWithdrawMap.get(userId)));
        }
        log.info("Quit class can not modify allInvalidUserIds={}", uIdStatusWithdrawMap);

        List<OrgLessonSign> allSignStudents = orgLessonSignDao.getLessonStudentIds(orgId, lessonId, userIdList, null);
        Set<Long> userIds = Sets.newHashSet(userIdList);// 计算出没签到过的学员
        Set<Long> signedUserIds = Sets.newHashSet();// 已签到学员
        List<OrgLessonSign> validSigns = new ArrayList<>();
        log.debug("userIds:{}, signStudents:{}", userIds, allSignStudents);
        if (CollectionUtils.isNotEmpty(allSignStudents)) {
            for (OrgLessonSign signStudent : allSignStudents) {
                SigninFailedDto.FailedStudent failedStudent = result.getFailedStudent(signStudent.getUserId());
                if (null != failedStudent) {
                    failedStudent.setSignStatus(signStudent.getStatus());
                    failedStudent.setSignRemark(signStudent.getSignRemark());
                    failedStudent.setSendToStu(signStudent.getSendToStu());
                } else {
                    signStudent.setStatus(status);
                    validSigns.add(signStudent);
                    signedUserIds.add(signStudent.getUserId());
                }
                userIds.remove(signStudent.getUserId());
            }
        }
        fillStudentInfo(orgId, result);

        log.info("update studentIds:{} in lesson:{} to signStatus:{}", signedUserIds, lessonId, status);
        this.orgLessonSignDao.orgLessonSignBatchEdit(lessonId, signedUserIds, status, cascadeId,
            OrgLessonSignSourceEnum.NORMAL.getValue());// 先update旧签到

        if (CollectionUtils.isNotEmpty(userIds) || CollectionUtils.isNotEmpty(signedUserIds)) {// 签到有变更时 都发通知
            Preconditions.checkArgument(lesson != null && orgId.equals(lesson.getOrgId()), "课节ID不正确");
            List<OrgLessonSign> newSignStudents = Lists.newArrayList();// 没签到过的就插入
            for (Long userId : userIds) {
                OrgLessonSign lessonSign = new OrgLessonSign();
                lessonSign.setCourseId(lesson.getCourseId());
                lessonSign.setCreateTime(new Date());
                lessonSign.setLessonId(lessonId);
                lessonSign.setOrgId(orgId);
                lessonSign.setStatus(status);
                lessonSign.setUserId(userId);
                lessonSign.setUpdateTime(new Date());
                lessonSign.setUserRole(UserRole.STUDENT.getRole());
                lessonSign.setCascadeId(cascadeId);
                lessonSign.setTeacherId(0);
                lessonSign.setSource(OrgLessonSignSourceEnum.NORMAL.getValue());
                newSignStudents.add(lessonSign);
            }
            log.info("save sign students:{}", newSignStudents);
            orgLessonSignDao.saveAll(newSignStudents, false, "courseId", "createTime", "lessonId", "orgId", "status",
                "userId", "updateTime", "userRole", "cascadeId", "source", "teacherId");

            long realCourseId = courseId;
            if (CourseTypeEnum.isOneToOne(course.getCourseType())) {
                realCourseId = course.getParentId();
            }
            OrgCourseConsumeRule rule = courseConsumeRuleDao.getRuleByCourseId(orgId, realCourseId);
            LessonStatus lessonStatus = null;
            if (rule != null) {
                lessonStatus = KexiaoUtil.getKexiaoStatus(status, rule.getRuleValue());
            }

            if (status != SignStatus.SIGNED.getCode()) {
                if (rule != null && rule.getRuleValue() > 0) {
                    if (status != 0 && lessonStatus != LessonStatus.FINISHED) {// 如果修改后不计算课消，则取消关联订单
                        Set<Long> allUserIds = new HashSet<>(userIds);
                        allUserIds.addAll(signedUserIds);
                        courseLessonService.cancelSign(orgId, lessonId, allUserIds);
                    }
                }
            }

            changeLogService.addBatchSignLog(orgId, userIdList, Sets.newHashSet(lessonId), status);
            if (lessonStatus == LessonStatus.FINISHED) {// 修改为已上
                resetLesson(orgId, courseId, Arrays.asList(lessonId), signedUserIds, course.getChargeUnit(), confirm);
            }
            if (!checkOrgPermissionSignMsg(orgId.intValue())) {
                return result;
            }

            // 发送签到提醒消息
            if (lesson.getStartTime().after(DateUtil.getCurrentDate())
                && lesson.getStartTime().before(DateUtil.getDiffDateTime(DateUtil.getCurrentDate(), 1))) {
                List<OrgLessonSign> signInList = Lists.newArrayList();
                signInList.addAll(validSigns);
                signInList.addAll(newSignStudents);
                addToSigninMsgAsynModel(signInList);
            }
        }
        return result;
    }

    @Override
    public void fillStudentInfo(Long orgId, SigninFailedDto result) {
        Map<Long, OrgStudent> userIdOrgStudentMap =
            orgStudentDao.getStudentMap(result.getFailedStudentMap().keySet(), orgId, "id", "userId", "name");
        for (SigninFailedDto.FailedStudent failedStudent : result.getFailedStudentList()) {
            OrgStudent orgStudent = userIdOrgStudentMap.get(failedStudent.getUserId());
            failedStudent.setStudentId(orgStudent.getId());
            failedStudent.setName(orgStudent.getName());
        }
    }

    /**
     *
     * 已取消的课节(即将正价课修改为不计算课消的状态后的课)重新标记为计算课消,这种情况需要重新计算是不是可以重新标记为计算课消. 注意:这种情况存在并发问题,但是该模式本身属于小概率事件,暂且忽略.
     *
     * @param orgId
     * @param courseId
     * @param userIds
     */
    private void resetLesson(final Long orgId, Long courseId, Collection<Long> lessonIds, Collection<Long> userIds,
        final int chargeUnit, int confirm) {
        List<OrgStudentLesson> lessons = orgStudentLessonDao.getByLessonIdsStudentIds(lessonIds, userIds);
        List<OrgStudentLesson> unSignableList = courseLessonService.getUnSignableList(orgId, courseId, lessons);

        final Set<Long> unSignableUserIds = new HashSet<>();
        for (OrgStudentLesson lesson : unSignableList) {
            unSignableUserIds.add(lesson.getUserId());
        }

        // 重新签到某一个学生的某一节课已取消的时,如果不能签到,则返回错误提示
        if (unSignableUserIds.size() > 0 && confirm != 1) {
            SignErrorCode code = new SignErrorCode();
            code.setMessage(createErrorMessage(orgId, unSignableUserIds, chargeUnit));
            throw new BussinessException(code);
        }
        List<OrgStudentLesson> reLessons = new ArrayList<>();
        for (OrgStudentLesson stuLesson : lessons) {
            if (stuLesson.getLessonType() == LessonType.CANCEL.getCode()) {
                reLessons.add(stuLesson);
            }
        }
        Date date = new Date();
        if (!reLessons.isEmpty()) {
            courseLessonService.saveSignupCourseLessons(orgId, courseId, reLessons);
            for (OrgStudentLesson updateStudentLesson : reLessons) {
                updateStudentLesson.setUpdateTime(date);
                orgStudentLessonDao.update(updateStudentLesson);
            }
        }
    }

    private String createErrorMessage(Long orgId, Collection<Long> unSignableUserIds, int chargeUnit) {
        PageDto page = new PageDto();
        page.setPageSize(6);
        List<OrgStudent> studentList = orgStudentDao.getStudents(orgId, unSignableUserIds, null, page, "name");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < studentList.size(); i++) {
            if (i > 0) {
                stringBuilder.append(",");
            }
            if (i < 5) {
                stringBuilder.append(studentList.get(i).getName());
            } else {
                stringBuilder.append("...等");
                break;
            }

        }
        String chargeUnitDesc = "课次";
        if (ChargeUnit.isByTime(chargeUnit)) {
            chargeUnitDesc = "课时";
        }
        return String.format(SIGN_TIP, stringBuilder.toString(), chargeUnitDesc);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void orgUnionStudentsMultiLessonBatchSign(Long orgId, Long courseId, List<Long> lessonIds,
        List<Long> userIds, Integer status, int confirm) {
        Long cascadeId = TianxiaoMContext.getTXCascadeIdLongZeroFill();
        this.orgLessonSignDao.orgLessonSignBatchEdit(lessonIds, userIds, status, cascadeId,
            OrgLessonSignSourceEnum.BATCH.getValue());// 先update旧签到

        Map<Long, Set<Long>> inDbSigninLessonIdUserIdsMap = // 获取数据库中存在的签到
            makeInDbSigninLessonIdUserIdsMap(orgId, courseId, lessonIds, userIds);

        Set<Long> signedUserIds = new HashSet<>();
        for (Long lessonId : inDbSigninLessonIdUserIdsMap.keySet()) {
            signedUserIds.addAll(inDbSigninLessonIdUserIdsMap.get(lessonId));
        }

        log.info("orgUnionStudentsMultiLessonBatchSign inDB signin lessonIdUserIds map:{}",
            inDbSigninLessonIdUserIdsMap);
        Map<Long, Set<Long>> inDbStudentLessonIdUserIdsMap = // 获取数据库中存在的<课节,学生>
            makeInDbStudentLessonIdUserIdsMap(lessonIds, userIds);
        log.info("orgUnionStudentsMultiLessonBatchSign inDB students lessonIdUserIds map:{}",
            inDbStudentLessonIdUserIdsMap);
        Map<Long, Set<Long>> newSigninLessonIdUserIdsMap = // 差集
            makeDifferenceSetLessonIdUserIdsMap(inDbSigninLessonIdUserIdsMap, inDbStudentLessonIdUserIdsMap);
        log.info("orgUnionStudentsMultiLessonBatchSign deference students lessonIdStudentId map:{}",
            newSigninLessonIdUserIdsMap);

        List<OrgLessonSign> newSignStudents = Lists.newArrayList();
        for (Long lessonId : newSigninLessonIdUserIdsMap.keySet()) {
            for (Long studentId : newSigninLessonIdUserIdsMap.get(lessonId)) {
                OrgLessonSign lessonSign = new OrgLessonSign();
                lessonSign.setCourseId(courseId);
                lessonSign.setCreateTime(new Date());
                lessonSign.setLessonId(lessonId);
                lessonSign.setOrgId(orgId);
                lessonSign.setStatus(status);
                lessonSign.setUserId(studentId);
                lessonSign.setUpdateTime(new Date());
                lessonSign.setUserRole(UserRole.STUDENT.getRole());
                lessonSign.setCascadeId(cascadeId);
                lessonSign.setTeacherId(0);
                lessonSign.setSource(OrgLessonSignSourceEnum.BATCH.getValue());
                newSignStudents.add(lessonSign);
            }
        }

        log.info("save sign students length:{}", newSignStudents.size());
        if (CollectionUtils.isNotEmpty(newSignStudents)) {
            orgLessonSignDao.saveAll(newSignStudents, false, "courseId", "createTime", "lessonId", "orgId", "status",
                "userId", "updateTime", "userRole", "cascadeId", "source", "teacherId");
        }
        long realCourseId = courseId;
        OrgCourse course = orgCourseDao.getById(courseId);
        if (CourseTypeEnum.isOneToOne(course.getCourseType())) {
            realCourseId = course.getParentId();
        }
        OrgCourseConsumeRule rule = courseConsumeRuleDao.getRuleByCourseId(orgId, realCourseId);
        LessonStatus lessonStatus = null;
        if (rule != null) {
            lessonStatus = KexiaoUtil.getKexiaoStatus(status, rule.getRuleValue());
            if (lessonStatus == LessonStatus.FINISHED) {// 修改为已上
                resetLesson(orgId, courseId, lessonIds, signedUserIds, course.getChargeUnit(), confirm);
            }
        }

        if (status != SignStatus.SIGNED.getCode()) {
            if (rule != null && rule.getRuleValue() > 0) {
                if (status != 0 && lessonStatus != LessonStatus.FINISHED) {// 如果修改后不计算课消，则取消关联订单
                    for (Long lessonId : lessonIds) {
                        Set<Long> allUserIds = new HashSet<>(userIds);
                        allUserIds.addAll(signedUserIds);
                        courseLessonService.cancelSign(orgId, lessonId, allUserIds);
                    }
                }
            }
        }

        changeLogService.addBatchSignLog(orgId, userIds, lessonIds, status);
    }

    private Map<Long, Set<Long>> makeDifferenceSetLessonIdUserIdsMap(Map<Long, Set<Long>> inDbSigninLessonIdUserIdsMap,
        Map<Long, Set<Long>> inDbStudentLessonIdUserIdsMap) {
        Map<Long, Set<Long>> result = Maps.newHashMap();
        for (Long lessonId : inDbStudentLessonIdUserIdsMap.keySet()) {
            Set<Long> someUserIds = inDbSigninLessonIdUserIdsMap.get(lessonId);
            Set<Long> allUserIds = inDbStudentLessonIdUserIdsMap.get(lessonId);
            result.put(lessonId, Sets.<Long> newHashSet(
                CollectionUtils.subtract(allUserIds, (null == someUserIds) ? Sets.newHashSet() : someUserIds)));
        }
        return result;
    }

    private Map<Long, Set<Long>> makeInDbStudentLessonIdUserIdsMap(List<Long> lessonIds, List<Long> userIds) {
        Map<Long, Set<Long>> result = Maps.newHashMap();
        List<OrgStudentLesson> studentLessons =
            orgStudentLessonDao.getByLessonIdsStudentIds(lessonIds, userIds, "lessonId", "userId");
        for (OrgStudentLesson studentLesson : studentLessons) {
            if (result.containsKey(studentLesson.getLessonId())) {
                result.get(studentLesson.getLessonId()).add(studentLesson.getUserId());
            } else {
                result.put(studentLesson.getLessonId(), Sets.newHashSet(studentLesson.getUserId()));
            }
        }
        return result;
    }

    private Map<Long, Set<Long>> makeInDbSigninLessonIdUserIdsMap(Long orgId, Long courseId, List<Long> lessonIds,
        List<Long> userIds) {
        Map<Long, Set<Long>> result = Maps.newHashMap();
        List<OrgLessonSign> signList = orgLessonSignDao.getByOrgIdCourseIdLessonIdsStudentIds(orgId, courseId,
            lessonIds, userIds, "lessonId", "userId");
        for (OrgLessonSign sign : signList) {
            if (result.containsKey(sign.getLessonId())) {
                result.get(sign.getLessonId()).add(sign.getUserId());
            } else {
                result.put(sign.getLessonId(), Sets.newHashSet(sign.getUserId()));
            }
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void orgStudentLessonBatchFastSign(Long orgId, Long courseId, List<Long> lessonIds,
        Map<Long, Integer> studentIdSignInStatus) {
        Set<Long> studentIds = studentIdSignInStatus.keySet();
        if (CollectionUtils.isEmpty(studentIds) || CollectionUtils.isEmpty(lessonIds)) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "课节ID和学生ID不能为空");
        }
        log.info("create studentsSignIns:{} in lesson:{}", studentIdSignInStatus, lessonIds);
        Long cascadeId = TianxiaoMContext.getTXCascadeIdLongZeroFill();

        Map<Long, Long> map = orgStudentDao.getStudentIdUserIdMap(studentIds);
        Map<Long, Integer> userIdSignInStatus = new HashMap<>();
        List<OrgLessonSign> newSignStudents = Lists.newArrayList();
        OrgCourse course = orgCourseDao.getById(courseId);
        long realCourseId = courseId;
        if (CourseTypeEnum.isOneToOne(course.getCourseType())) {
            realCourseId = course.getParentId();
        }
        OrgCourseConsumeRule rule = courseConsumeRuleDao.getRuleByCourseId(orgId, realCourseId);
        LessonStatus lessonStatus = null;
        if (MapUtils.isNotEmpty(map)) {
            for (Long lessonId : lessonIds) {
                OrgClassLesson lesson = orgClassLessonDao.getById(lessonId);
                Preconditions.checkArgument(lesson != null && orgId.equals(lesson.getOrgId()), "课节ID不正确");
                Map<Long, Integer> invalidUsers =
                    orgStudentCourseDao.userMapByStatus(orgId, courseId, map.values(), Arrays.asList(1, 2));
                Set<Long> allUserIds = new HashSet<>();
                for (Map.Entry<Long, Long> studentEntry : map.entrySet()) {
                    if (invalidUsers.containsKey(studentEntry.getValue())) {
                        continue;
                    }
                    OrgLessonSign lessonSign = new OrgLessonSign();
                    lessonSign.setCourseId(lesson.getCourseId());
                    lessonSign.setCreateTime(new Date());
                    lessonSign.setLessonId(lessonId);
                    lessonSign.setOrgId(orgId);
                    lessonSign.setStatus(studentIdSignInStatus.get(studentEntry.getKey()));
                    lessonSign.setUserId(studentEntry.getValue());
                    lessonSign.setUpdateTime(new Date());
                    lessonSign.setUserRole(UserRole.STUDENT.getRole());
                    lessonSign.setCascadeId(cascadeId);
                    lessonSign.setTeacherId(0);
                    lessonSign.setSource(OrgLessonSignSourceEnum.FAST.getValue());
                    newSignStudents.add(lessonSign);
                    userIdSignInStatus.put(lessonSign.getUserId(), lessonSign.getStatus());
                    if (rule != null) {
                        lessonStatus = KexiaoUtil.getKexiaoStatus(lessonSign.getStatus(), rule.getRuleValue());
                    }
                    if (lessonSign.getStatus() != SignStatus.SIGNED.getCode()) {
                        if (rule != null && rule.getRuleValue() > 0) {
                            if (lessonSign.getStatus() != 0 && lessonStatus != LessonStatus.FINISHED) {// 如果修改后不计算课消，则取消关联订单
                                allUserIds.add(lessonSign.getUserId());
                            }
                        }
                    }
                }
                if (allUserIds.size() > 0) {
                    courseLessonService.cancelSign(orgId, lessonId, allUserIds);
                }
            }

            log.info("save sign students:{}", newSignStudents);
            orgLessonSignDao.saveAll(newSignStudents, false, "courseId", "createTime", "lessonId", "orgId", "status",
                "userId", "updateTime", "userRole", "cascadeId", "source", "teacherId");
            changeLogService.addFastSignLog(orgId, lessonIds, userIdSignInStatus);

        }
    }

    /**
     * 签到提醒
     *
     * @param orgInfo
     * @param student
     * @param teacherName
     * @param lesson
     * @param course
     * @param orgLessonSign
     * @return
     */
    private SendMsgRequest getSendMsgRequest(OrgInfo orgInfo, OrgStudent student, String teacherName,
        OrgClassLesson lesson, OrgCourse course, OrgLessonSign orgLessonSign) {
        String studentName = getStringValue(student.getName());
        String orgName = orgInfo.getShortName();
        String courseName = course.getName();
        String extention = getStringValue(orgInfo.getExtension());
        teacherName = getStringValue(teacherName);
        int type = 1;
        if (orgLessonSign.getStatus() == SignStatus.SIGNED.getCode()) {
            type = 1;
        } else if (orgLessonSign.getStatus() == SignStatus.LEAVE.getCode()) {
            type = 2;
        } else if (orgLessonSign.getStatus() == SignStatus.ABSENT.getCode()) {
            type = 3;
        }
        // 构建短信内容
        String smsContent = SmsContentHelper.createSignRecordSmsMsg(type, studentName, lesson.getStartTime().getTime(),
            courseName, orgName);
        String url = ErpUtils.createClassSchedule(orgInfo.getOrgId().longValue(), student.getId());
        // 构建微信内容
        SignWechatTemplateMsg msg = SignWechatTemplateMsg.newInstance(studentName, orgName, orgLessonSign.getStatus(),
            courseName, lesson.getStartTime().getTime(), lesson.getEndTime().getTime(),
            orgLessonSign.getUpdateTime().getTime(), teacherName, extention, url);
        SendMsgRequest createSendMsgRequestToStu =
            WechatTemplateMsgHelper.createSendMsgRequestToStu(orgInfo.getOrgId().longValue(), student.getMobile(),
                student.getId(), student.getWeixin(), smsContent, WechateTemplateMsgType.COURSE_SIGNIN_TO_STU, msg);
        return createSendMsgRequestToStu;
    }

    /**
     * 签到提醒
     *
     * @return
     */
    // private SendMsgRequest getSendMsg(OrgInfo orgInfo, OrgStudent student, String teacherName, OrgClassLesson lesson,
    // OrgCourse course, OrgLessonSign orgLessonSign) {
    // SendMsgRequest request = new SendMsgRequest();
    // request.setOrgId(orgInfo.getOrgId().longValue());
    // request.setMobile(student.getMobile());
    // request.setCountSms(false);
    // request.setReceiverId(student.getId());
    // request.setWeixinOpenId(student.getWeixin());
    // request.setReceiverRole(UserRoleEnum.STUDENT);
    // request.setSenderId(orgInfo.getOrgId().longValue());
    // request.setSenderRole(UserRoleEnum.ORG);
    // request.setWechatTemplateId(WechateTemplateMsgType.COURSE_SIGNIN_TO_STU.getValue());
    // String studentName = getStringValue(student.getName());
    // String orgName = orgInfo.getShortName();
    // String courseName = course.getName();
    // String signStatusStr = SignStatus.getSignStatusByCode(orgLessonSign.getStatus()).getMessage();
    // String extention = getStringValue(orgInfo.getExtension());
    // teacherName = getStringValue(teacherName);
    // int type = 1;
    // if (orgLessonSign.getStatus() == SignStatus.SIGNED.getCode()) {
    // type = 1;
    // } else if (orgLessonSign.getStatus() == SignStatus.LEAVE.getCode()) {
    // type = 2;
    // } else if (orgLessonSign.getStatus() == SignStatus.ABSENT.getCode()) {
    // type = 3;
    // }
    // String smsContent = SmsContentHelper.createSignRecordSmsMsg(type, studentName, lesson.getStartTime().getTime(),
    // courseName, orgName);
    // makeSmsContent(studentName, orgName, courseName, lesson.getName(), signStatusStr, extention,
    // orgLessonSign.getSignRemark(), orgLessonSign.getSendToStu());
    // request.setSmsContent(smsContent);

    // WeixinTemplateMsgCreatorDto dto = new WeixinTemplateMsgCreatorDto();
    // dto.setCourseName(courseName);
    // dto.setCourseTime(lesson.createCourseTime());
    // dto.setExtention(extention);
    // dto.setLessonName(lesson.getName());
    // dto.setOrgId(orgInfo.getOrgId().longValue());
    // dto.setOrgName(orgName);
    // dto.setSendToStu(orgLessonSign.getSendToStu());
    // dto.setSignRemark(orgLessonSign.getSignRemark());
    // dto.setSignStatus(orgLessonSign.getStatus());
    // dto.setStudentId(student.getId());
    // dto.setStudentName(studentName);
    // dto.setTeacherName(teacherName);
    // request.setWechatParams(this.WeixinTemplateMsgCreator.createSignMsg(dto));

    // Map<String, Object> params = Maps.newHashMap();
    // String url = createClassSchedule(orgInfo.getOrgId().longValue(), student.getId());
    // Date now = new Date();
    // String courseTime = lesson.createCourseTime();
    // params.put("first", WeixinUtils.getTemplateMsgNode(markFirst(studentName, orgName, orgLessonSign.getStatus(),
    // courseTime, orgLessonSign.getSignRemark(), orgLessonSign.getSendToStu()), "#27B2ED"));
    // params.put("remark",
    // WeixinUtils.getTemplateMsgNode(String.format(OrgLessonSignServiceImpl.remark, extention), "#27B2ED"));
    // params.put("url", url);
    // params.put("keyword1", WeixinUtils.getTemplateMsgNode(studentName, "#878788"));
    // params.put("keyword2",
    // WeixinUtils.getTemplateMsgNode(DateUtil.getStrByDateFormate(now, "yyyy-MM-dd HH:mm"), "#878788"));
    // params.put("keyword3", WeixinUtils
    // .getTemplateMsgNode(courseName + NotifyMessageUtils.generateLessonName(lesson.getName(), true), "#878788"));
    // params.put("keyword4", WeixinUtils.getTemplateMsgNode(getStringValue(teacherName), "#878788"));
    // request.setWechatParams(params);
    // log.debug("remind student comment the course! data={}", request);
    // return request;
    // }

    public String createClassSchedule(Long orgId, Long studentId) {
        try {
            Properties fillProperties = PropertiesReader.fillProperties("erp.properties");
            log.info("fillProperties is:{} ", fillProperties);
            String scheduleUrl = fillProperties.getProperty("student_class_schedule");
            if (GenericsUtils.isNullOrEmpty(scheduleUrl)) {
                return "";
            }
            StudentSmsTokenDto token = new StudentSmsTokenDto(orgId, null, studentId, null);
            token.setStudentId(studentId);
            return scheduleUrl.replace("#{TOKEN}", token.toTokenStr());
        } catch (Exception e) {
            log.error("error :{} ", e);
            log.info("can not create token with orgId:{} and studentId:{} ", orgId, studentId);
            return "";
        }
    }

    @SuppressWarnings("unused")
    private String makeFirst(String studentName, String orgName, String courseName, String signStatusStr,
        String signRemark, Integer sendToStu) {
        if (sendToStu != null && sendToStu == Flag.TRUE.getInt() && StringUtils.isNotBlank(signRemark)) {
            return String.format(OrgLessonSignServiceImpl.contentWithRemark, studentName, orgName, courseName,
                signStatusStr, signRemark);
        } else {
            return String.format(OrgLessonSignServiceImpl.content, studentName, orgName, courseName, signStatusStr);

        }
    }

    public static final String firstFormat = "%s同学在%s课程%s\n上课时间为%s";

    public String markFirst(String stuName, String orgName, int signStatus, String courseTime, String remak,
        Integer sendToStu) {
        String signStatusStr = SignStatus.createSignStr(signStatus);
        String retStr = String.format(firstFormat, stuName, orgName, signStatusStr, courseTime);
        if (GenericsUtils.notNullAndEmpty(remak) && (sendToStu != null && sendToStu == Flag.TRUE.getInt())) {
            retStr += ("备注为:" + remark);
        }
        retStr += "\n";
        return retStr;
    }

    private String makeSmsContent(String studentName, String orgName, String courseName, String lessonName,
        String signStatusStr, String extention, String signRemark, Integer sendToStu) {
        if (sendToStu != null && sendToStu == Flag.TRUE.getInt() && StringUtils.isNotBlank(signRemark)) {
            return String.format(OrgLessonSignServiceImpl.smsContentWithRemark, studentName, orgName, courseName,
                NotifyMessageUtils.generateLessonName(lessonName, false), signStatusStr, extention, signRemark);
        } else {
            return String.format(OrgLessonSignServiceImpl.smsContent, studentName, orgName, courseName,
                NotifyMessageUtils.generateLessonName(lessonName, false), signStatusStr, extention);
        }
    }

    /**
     * 没有名称返回“－”
     *
     * @param message
     * @return
     */
    private String getStringValue(String message) {
        if (StringUtils.isBlank(message)) {
            return defaultName;
        }
        return message;
    }

    /**
     * 
     * @param teacherId 个人中心老师id nullable 
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void orgStudentLessonSign(@NonNull Long orgId, Long courseId, @NonNull Long lessonId,
        @NonNull Long studentId, Integer status, Integer teacherId) {

        Preconditions.checkArgument(status != null && status >= 0, "签到状态不正确");
        Preconditions.checkArgument(lessonId != null && lessonId >= 0, "课节ID不正确");
        Preconditions.checkArgument(orgId != null && orgId >= 0, "机构ID不正确");
        Preconditions.checkArgument(studentId != null && studentId >= 0, "学生ID不正确");

        OrgClassLesson lesson = orgClassLessonDao.getByIdForUpdate(lessonId);
        Preconditions.checkArgument(lesson != null && orgId.equals(lesson.getOrgId()), "课节ID不正确");

        OrgCourse course = orgCourseDao.getById(lesson.getCourseId());
        Preconditions.checkArgument(course != null, " 课节ID不正确");
        OrgStudent student = orgStudentDao.getById(studentId);
        Long userId = student == null ? null : student.getUserId();
        Preconditions.checkArgument(userId != null && userId >= 0, "无法找到对应的学生ID:" + studentId);

        Map<Long, Integer> uIdStatusWithdrawMap =
            orgStudentCourseDao.userMapByStatus(orgId, courseId, Arrays.asList(userId),
                Arrays.asList(StudentCourseStatus.WITHDRAW.getCode(), StudentCourseStatus.TRANSFER.getCode()));
        log.info("Quit class can not modify status.InvalidUserIds={}", uIdStatusWithdrawMap);
        if (uIdStatusWithdrawMap.containsKey(userId)) {
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "已退班学员签到状态不可更改");
        }

        Long cascadeId = TianxiaoMContext.getTXCascadeIdLongZeroFill();

        OrgLessonSign obj =
            orgLessonSignDao.getStudentLessonSign(orgId, courseId, lessonId, userId, UserRole.STUDENT.getRole());
        if (obj != null && status != null && !status.equals(obj.getStatus())) {
            // 签到提醒
            // this.sendLessonSignMsg(orgId, courseId, lessonId, studentId, status);
            obj.setStatus(status);
            if(null != teacherId){
                obj.setCascadeId(0L);
                obj.setTeacherId(teacherId);
                obj.setSource(OrgLessonSignSourceEnum.WECHAT.getValue());
            }else {
                obj.setTeacherId(0);
                obj.setCascadeId(cascadeId);
                obj.setSource(OrgLessonSignSourceEnum.NORMAL.getValue());
            }
            orgLessonSignDao.update(obj, "status", "cascadeId", "source", "teacherId");
        } else if (obj == null && status != null) {
            obj = new OrgLessonSign();
            obj.setCourseId(lesson.getCourseId());
            obj.setCreateTime(new Date());
            obj.setLessonId(lessonId);
            obj.setOrgId(orgId);
            obj.setStatus(status);
            obj.setUpdateTime(new Date());
            obj.setUserId(userId);
            obj.setUserRole(UserRole.STUDENT.getRole());
            if(null != teacherId){
                obj.setCascadeId(0L);
                obj.setTeacherId(teacherId);
                obj.setSource(OrgLessonSignSourceEnum.WECHAT.getValue());
            }else {
                obj.setTeacherId(0);
                obj.setCascadeId(cascadeId);
                obj.setSource(OrgLessonSignSourceEnum.NORMAL.getValue());
            }
            orgLessonSignDao.saveOrUpdate(obj, "courseId", "createTime", "lessonId", "orgId", "status", "userId",
                "updateTime", "userRole", "cascadeId", "source", "teacherId");
        }
        changeLogService.addBatchSignLog(orgId, Arrays.asList(lessonId), Arrays.asList(userId), status);
        if (!checkOrgPermissionSignMsg(orgId.intValue())) {
            return;
        }
        if (lesson.getStartTime().after(DateUtil.getCurrentDate())
            && lesson.getStartTime().before(DateUtil.getDiffDateTime(DateUtil.getCurrentDate(), 1))) {
            List<OrgLessonSign> signInList = Lists.newArrayList();
            signInList.add(obj);
            addToSigninMsgAsynModel(signInList);

        }
    }

    @Override
    @Transactional(readOnly = true)
    public OrgStudentLessonSignDto getStudentLessonSign(@NonNull Long orgId, Long courseId, @NonNull Long lessonId,
        @NonNull Long studentId) {

        Long userId = orgStudentDao.getUserId(studentId);

        OrgLessonSign obj =
            orgLessonSignDao.getStudentLessonSign(orgId, courseId, lessonId, userId, UserRole.STUDENT.getRole());
        if (obj != null) {
            OrgStudentLessonSignDto dto = new OrgStudentLessonSignDto();
            dto.setCourseId(obj.getCourseId());
            dto.setCreateTime(obj.getCreateTime());
            dto.setId(obj.getId());
            dto.setLessonId(obj.getLessonId());
            dto.setSignStatusEnum(SignStatus.getSignStatusByCode(obj.getStatus()));
            dto.setUpdateTime(obj.getUpdateTime());

            return dto;
        }
        return null;
    }

    @Override
    @Transactional(readOnly = true)
    @Deprecated
    public Map<String, Map<String, Integer>> getLessonStudentSign(Long orgId, Collection<Long> lessonIds,
        Map<Long, Long> userIdMap) {
        List<OrgLessonSign> signs = this.orgLessonSignDao.getStudentLessonSign(orgId, null, lessonIds);

        Map<String, Map<String, Integer>> signUserIdMap = Maps.newHashMap();

        for (OrgLessonSign sign : signs) {
            if (!signUserIdMap.containsKey(String.valueOf(sign.getUserId()))) {
                Map<String, Integer> map = Maps.newHashMap();
                signUserIdMap.put(String.valueOf(sign.getUserId()), map);
            }
            signUserIdMap.get(String.valueOf(sign.getUserId())).put(String.valueOf(sign.getLessonId()),
                sign.getStatus());
        }

        Map<String, Map<String, Integer>> signStudentIdMap = Maps.newHashMap();
        for (String userId : signUserIdMap.keySet()) {
            signStudentIdMap.put(String.valueOf(userIdMap.get(Long.parseLong(userId))), signUserIdMap.get(userId));
        }

        return signStudentIdMap;

    }

    @Override
    @Transactional(readOnly = true)
    public Map<String, Map<String, SignStatusRemarkDto>> getLessonStudentSignReport(Long orgId,
        Collection<Long> lessonIds, Map<Long, Long> userIdMap, Long courseId) {
        // lessonIds:课程所有课节Id，userIdMap.keySet()所有userId
        Preconditions.checkArgument(courseId != null && courseId > 0, "illegal courseId = " + courseId);
        long current = System.currentTimeMillis();
        Map<Long, List<Long>> userIdsLessonMap =
            this.orgStudentLessonDao.getLessonIdsOfStudents(orgId, userIdMap.keySet(), lessonIds);
        // 从org_lesson_sign查出学生课节信息对应的签到信息
        List<OrgLessonSign> signList = orgLessonSignDao.getUserLessonSignList(orgId, userIdMap.keySet(), courseId,
            UserRole.STUDENT.getRole(), null);
        Map<Long, List<OrgLessonSign>> userIdLessonSignMap = getUserIdLessonSignMap(signList);

        Map<String, Map<String, SignStatusRemarkDto>> signStudentIdMap = Maps.newHashMap();
        for (Long userId : userIdsLessonMap.keySet()) {

            Map<String, SignStatusRemarkDto> userMap = Maps.newHashMap();

            List<Long> lessons = userIdsLessonMap.get(userId);

            List<OrgLessonSign> signs = userIdLessonSignMap.get(userId);
            Map<Long, SignStatusRemarkDto> lessonSignMap = toLessonSignMap(signs);

            for (Long lessonId : lessons) {
                SignStatusRemarkDto statusRemarkDto = lessonSignMap.get(lessonId);

                userMap.put(String.valueOf(lessonId),
                    statusRemarkDto == null ? new SignStatusRemarkDto(0, "") : statusRemarkDto);
            }

            signStudentIdMap.put(String.valueOf(userIdMap.get(userId)), userMap);
        }
        log.debug("cost:{}ms", System.currentTimeMillis() - current);
        return signStudentIdMap;
    }

    @Override
    @Transactional(readOnly = true)
    public Map<Long, Integer> getLessonStudentSignCount(Long orgId, Collection<Long> lessonIds,
        Map<Long, Long> userIdMap) {
        Map<Long, Integer> userIdCountMap =
            this.orgLessonSignDao.getOrgLessonSignCount(lessonIds, UserRole.STUDENT.getRole());
        log.debug("getLessonStudentSignCount result={}", userIdCountMap);
        log.debug("getLessonStudentSignCount userIdMap={}", userIdMap);
        Map<Long, Integer> studentIdCountMap = Maps.newHashMap();
        for (Long userId : userIdCountMap.keySet()) {
            studentIdCountMap.put(userIdMap.get(userId), userIdCountMap.get(userId));
        }
        log.debug("getLessonStudentSignCount result={}", studentIdCountMap);
        return studentIdCountMap;
    }

    @Override
    public LessonSignReportDto getLessonSignReport(@NonNull Long orgId, @NonNull Long studentId) {
        log.info("orgId = {}, studentId={}", orgId, studentId);
        LessonSignReportDto lessonSignReportDto = new LessonSignReportDto();

        // 学员基本信息
        Long userId = this.orgStudentDao.getUserId(studentId);
        Preconditions.checkArgument(userId != null && userId > 0, "student not exits!");
        OrgStudent orgStudent =
            orgStudentDao.getStudent(orgId, userId, 0, "userId", "id", "name", "nickName", "mobile", "show_mobile");
        if (orgStudent == null) {
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "学生已删除");
        }
        lessonSignReportDto.getStudentInfo().setName(buildStudentName(orgStudent));
        lessonSignReportDto.getStudentInfo().setStudentId(orgStudent.getUserId());
        Integer orgNumber = orgAccountDao.getById(orgId, "number").getNumber();
        List<OrgCourse> orgCourseList =
            orgCourseDao.getCoursesByOrgNumber(orgNumber.longValue(), DeleteStatus.DELETED.getValue(), "id");
        List<Long> deletedIds = Lists.newArrayList();
        for (OrgCourse orgCourse : orgCourseList) {
            deletedIds.add(orgCourse.getId());
        }
        // 学员的所有课程
        List<Long> courseIds = this.orgStudentCourseDao.getStudentCourseIds(orgId, userId, null);
        courseIds.removeAll(deletedIds);// 过滤删掉的课程
        log.debug("courseIds = {}", courseIds);
        // 本学生的各个课程的课节数目
        Map<Long, Integer> courseLessonCountMap =
            this.orgStudentLessonDao.getStudentLessonCountOfCourses(orgId, userId, courseIds);
        log.debug("courseLessonCountMap = {}", courseLessonCountMap);

        // 课程名列表
        List<OrgCourse> courseList = this.orgCourseDao.getByIds(courseIds, "id", "name");
        log.debug("courseIds = {}, courseList = {}", courseIds, courseList);
        if (CollectionUtils.isEmpty(courseList)) {
            return lessonSignReportDto;
        }

        // 课节id map
        List<OrgClassLesson> lessonList =
            orgClassLessonDao.queryByCourseIds(orgId, courseIds, DeleteStatus.NORMAL.getValue());
        Map<Long, OrgClassLesson> lessonMap = Maps.newHashMap();
        List<Long> allLessonIds = Lists.newArrayList();
        for (OrgClassLesson lesson : lessonList) {
            allLessonIds.add(lesson.getId());
            lessonMap.put(lesson.getId(), lesson);
        }

        // 学生在的课节列表
        Map<String, Object> studentLessonCondition = Maps.newHashMap();
        studentLessonCondition.put("orgId", orgId);
        studentLessonCondition.put("lessonId", allLessonIds);
        studentLessonCondition.put("userId", userId);
        studentLessonCondition.put("delStatus", 0);
        List<OrgStudentLesson> studentLessons = orgStudentLessonDao.queryByCondition(studentLessonCondition, null);
        // courseId,<studentId,List<studentLesson>>
        Set<Long> effectAllLesson = Sets.newHashSet();
        Set<Long> effectAllStudentId = Sets.newHashSet();
        Map<Long, Map<Long, List<OrgStudentLesson>>> courseStudentLessonMap = Maps.newHashMap();
        for (OrgStudentLesson studentLesson : studentLessons) {
            Long courseId = lessonMap.get(studentLesson.getLessonId()).getCourseId();// FIXME 卧槽
            // org_student_lesson这个表的course_id有脏数据?
            // FIXME 接上:老子脏数据都修了,坑也填了
            Long tempStudentId = studentLesson.getUserId();
            Map<Long, List<OrgStudentLesson>> studentLessonMap = courseStudentLessonMap.get(courseId);
            if (studentLessonMap == null) {
                studentLessonMap = Maps.newHashMap();
                courseStudentLessonMap.put(courseId, studentLessonMap);
            }
            List<OrgStudentLesson> tempList = studentLessonMap.get(tempStudentId);
            if (tempList == null) {
                tempList = Lists.newArrayList();
                studentLessonMap.put(tempStudentId, tempList);
            }
            tempList.add(studentLesson);
            effectAllLesson.add(studentLesson.getLessonId());
            effectAllStudentId.add(tempStudentId);
        }

        // userId|lessonId 对应的签到状态map
        List<OrgLessonSign> allsignList = Lists.newArrayList();
        if (effectAllLesson.size() > 0 && effectAllStudentId.size() > 0) {
            Map<String, Object> signLessonCondition = Maps.newHashMap();
            signLessonCondition.put("orgId", orgId);
            signLessonCondition.put("lessonId", effectAllLesson);
            signLessonCondition.put("studentId", effectAllStudentId);
            signLessonCondition.put("userRole", 2);
            allsignList = orgLessonSignDao.queryByCondition(signLessonCondition, null);
        }
        Map<String, SignStatusRemarkDto> allSignMap = Maps.newHashMap();
        for (OrgLessonSign sign : allsignList) {
            String key = sign.getUserId() + "|" + sign.getLessonId();
            allSignMap.put(key, new SignStatusRemarkDto(sign.getStatus(), sign.getSignRemark()));
        }

        // 按课程拼dto
        for (OrgCourse orgCourse : courseList) {
            LessonSignReportDto.OrgCourseInfo courseInfo = new LessonSignReportDto.OrgCourseInfo();
            courseInfo.setCourseName(orgCourse.getName());
            Integer lessonCount = courseLessonCountMap.get(orgCourse.getId());
            courseInfo.setLessonCount(lessonCount == null ? 0 : lessonCount);
            // 课程的学生
            List<Long> userIds = Lists.newArrayList(userId);
            courseInfo.setStudentCount(userIds.size());

            // 找出这个课程的课节map
            Map<Long, List<OrgStudentLesson>> userIdsLessonMap = courseStudentLessonMap.get(orgCourse.getId());
            LessonSignReportDto.CourseStudentDto studentDto = new LessonSignReportDto.CourseStudentDto();
            studentDto.setStudentName(buildStudentName(orgStudent));

            // 这个学生的所有课节
            List<OrgStudentLesson> studentLessonList = null;
            if (userIdsLessonMap != null) {
                studentLessonList = userIdsLessonMap.get(orgStudent.getUserId());
            }
            if (CollectionUtils.isNotEmpty(studentLessonList)) {
                for (OrgStudentLesson studentLesson : studentLessonList) {
                    LessonSignReportDto.StudentLessonSignInfoDto signDto =
                        new LessonSignReportDto.StudentLessonSignInfoDto();
                    signDto.setLessonId(studentLesson.getLessonId());
                    String key = studentLesson.getUserId() + "|" + studentLesson.getLessonId();
                    SignStatusRemarkDto statusRemarkDto = allSignMap.get(key);
                    signDto.setSignStatus(
                        statusRemarkDto != null ? statusRemarkDto.getSignStatus() : SignStatus.UNSIGN.getCode());
                    signDto.setSignRemark(statusRemarkDto != null ? statusRemarkDto.getSignRemark() : "");
                    OrgClassLesson lesson = lessonMap.get(studentLesson.getLessonId());
                    if (lesson != null) {
                        signDto.setLessonNumber(lesson.getNumber());
                    } else {
                        log.error("lessonId = {} not exits!", studentLesson.getLessonId());
                        throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "lessonId not found!");
                    }
                    studentDto.addLessonSignInfo(signDto);
                }
            }

            // 只在课程，没有课节的学生不反回
            if (CollectionUtils.isNotEmpty(studentDto.getLessonList())) {
                log.info("no lesson in course studentDto = {}", studentDto);
                courseInfo.getStudentList().add(studentDto);
            }

            if (userId != null) {
                log.debug("{}{}", courseInfo.getLessonCount(), courseInfo.getStudentList());
                if (courseInfo.getStudentList().size() > 0
                    && courseInfo.getLessonCount() != courseInfo.getStudentList().get(0).getLessonList().size()) {
                    log.warn("should be equal.{} != {}", courseInfo.getLessonCount(),
                        courseInfo.getStudentList().size());
                }
            }
            lessonSignReportDto.getCourseList().add(courseInfo);
        }
        return lessonSignReportDto;
    }

    private Map<Long, List<OrgLessonSign>> getUserIdLessonSignMap(List<OrgLessonSign> signList) {
        return CollectorUtil.group(signList, new Function<OrgLessonSign, Long>() {
            @Override
            public Long apply(OrgLessonSign arg0) {
                return arg0.getUserId();
            }
        }, new Function<OrgLessonSign, OrgLessonSign>() {
            @Override
            public OrgLessonSign apply(OrgLessonSign arg0) {
                return arg0;
            }
        });
    }

    private Map<Long, SignStatusRemarkDto> toLessonSignMap(List<OrgLessonSign> signList) {
        Map<Long, SignStatusRemarkDto> lessonSignMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty(signList)) {
            return Collections.emptyMap();
        }
        for (OrgLessonSign sign : signList) {
            lessonSignMap.put(sign.getLessonId(), new SignStatusRemarkDto(sign.getStatus(), sign.getSignRemark()));
        }
        return lessonSignMap;
    }

    private String buildStudentName(OrgStudent stu) {
        if (StringUtils.isNotBlank(stu.getName())) {
            return stu.getName();
        } else if (StringUtils.isNotBlank(stu.getNickName())) {
            return stu.getNickName();
        } else {
            return MaskUtil.maskMobile(stu.getMobile());
        }
    }

    @Override
    public Map<Long, Double> getAttendanceRateOfCourses(Long orgId, Collection<Long> courseIds) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "orgId is illegal");
        if (CollectionUtils.isEmpty(courseIds)) {
            return Collections.emptyMap();
        }
        Map<Long, Double> resultMap = Maps.newHashMap();
        Map<Long, Integer> shouldSignCntMap = this.orgClassLessonDao.getCourseAttendCountMap(orgId, courseIds);
        Map<Long, Integer> actualSignCntMap = this.orgLessonSignDao.getCourseSignCountMap(orgId, courseIds);
        log.debug("shouldSignCntMap={},actualSignCntMap={}", shouldSignCntMap, actualSignCntMap);
        for (Long courseId : courseIds) {
            Integer shouldSignCnt = shouldSignCntMap.get(courseId);
            Integer actualSignCnt = actualSignCntMap.get(courseId);
            if (actualSignCnt != null && shouldSignCnt != null && shouldSignCnt > 0) {
                Double attendanceRate = (double) actualSignCnt / shouldSignCnt;
                resultMap.put(courseId, attendanceRate);
            } else {
                resultMap.put(courseId, 0.00);
            }

        }
        log.debug("resultMap={}", resultMap);
        return resultMap;

    }

    @Override
    public Map<Long, Double> getAttendanceRateOfStudents(Long orgId, Collection<Long> studentds) {

        Preconditions.checkArgument(orgId != null && orgId > 0, "orgId is illegal");
        if (CollectionUtils.isEmpty(studentds)) {
            return Collections.emptyMap();
        }
        Map<Long, Long> stuUserMap = this.orgStudentDao.getStudentIdUserIdMap(studentds);
        Collection<Long> userIds = stuUserMap.values();
        log.debug("stuUserMap={}", stuUserMap);
        log.debug("userIds={}", userIds);
        if (CollectionUtils.isEmpty(userIds)) {
            return Collections.emptyMap();
        }
        Map<Long, Double> resultMap = Maps.newHashMap();
        Map<Long, Integer> shouldSignCntMap = this.orgClassLessonDao.getStudentAttendCountMap(orgId, userIds);
        Map<Long, Integer> actualSignCntMap = this.orgLessonSignDao.getStudentSignCountMap(orgId, userIds);
        log.debug("shouldSignCntMap={},actualSignCntMap={}", shouldSignCntMap, actualSignCntMap);
        for (Long studentId : studentds) {
            Long userId = stuUserMap.get(studentId);
            if (userId == null || userId <= 0) {
                continue;
            }
            Integer shouldSignCnt = shouldSignCntMap.get(userId);
            Integer actualSignCnt = actualSignCntMap.get(userId);
            if (actualSignCnt != null && shouldSignCnt != null && shouldSignCnt > 0) {
                Double attendanceRate = (double) actualSignCnt / shouldSignCnt;
                resultMap.put(studentId, attendanceRate);
            } else {
                resultMap.put(studentId, 0.00);
            }

        }
        log.debug("resultMap={}", resultMap);
        return resultMap;

    }

    @Override
    public List<Long> getStudentBySignStatus(Long orgId, Long lessonId) {

        List<OrgLessonSign> dtos =
            orgLessonSignDao.getStudentLessonByStatus(orgId, lessonId, SignStatus.UNSIGN.getCode());

        Collection<Long> studentIds = CollectorUtil.collect(dtos, new Function<OrgLessonSign, Long>() {
            @Override
            public Long apply(OrgLessonSign input) {
                return input.getUserId();
            }
        });

        return new ArrayList(studentIds);
    }

    private boolean checkOrgPermissionSignMsg(Integer orgId) {
        TXSaleClueRule tXSaleClueRule = tXSaleClueRuleService.getByOrgId(orgId);
        log.info("checkOrgPermissionSignMsg orgId={orgId},txsaleClueRule={}", orgId, tXSaleClueRule);
        if (tXSaleClueRule != null && tXSaleClueRule.getSigninMsg() == 0) {
            return true;
        } else {
            return false;
        }

    }

    // /**
    // * 根据发送的信息存储的缓存中
    // * <p/>
    // * 如果被覆盖 则不发送
    // */
    // private Map<String,String> timerSendSignCacheKey(Collection< Long> studentIds, final OrgClassLesson lesson) {
    // Map<String,String> sendMap = Maps.newHashMap();
    // if(!checkOrgPermissionSignMsg(lesson.getOrgId().intValue())){
    // return sendMap;
    // }
    // for(Long studentId:studentIds){
    // final String key = lesson.getOrgId() + "" + studentIds + "" + lesson.getId();
    // final String value = UUID.randomUUID().toString();
    //
    // redisTemplate.execute(new RedisCallback<Object>() {
    // @Override
    // public Object doInRedis(RedisConnection connection) throws DataAccessException {
    // connection.setEx(key.getBytes(), 60 * 2l, value.getBytes());
    //
    // return null;
    // }
    // });
    // sendMap.put(key, value);
    // }
    //
    // return sendMap;
    //
    //
    // }

    // /**
    // * 根据发送的信息存储的缓存中
    // * <p/>
    // * 如果被覆盖 则不发送
    // *
    // * @param orgInfo
    // * @param student
    // * @param teacher
    // * @param lesson
    // * @param course
    // * @param status
    // */
    // private void timerSendSignMsg(final OrgInfo orgInfo, final OrgStudent student, final Teacher teacher, final
    // OrgClassLesson lesson, final OrgCourse course, final Integer status) {
    //
    //
    // final String key = orgInfo.getId() + "" + student.getId() + "" + lesson.getId();
    // final String value = UUID.randomUUID().toString();
    // redisTemplate.execute(new RedisCallback<Object>() {
    // @Override
    // public Object doInRedis(RedisConnection connection) throws DataAccessException {
    // connection.setEx(key.getBytes(), 60 * 2l, value.getBytes());
    // return null;
    // }
    // });
    //
    // Timer timer = new Timer();
    // timer.schedule(new TimerTask() {
    // @Override
    // public void run() {
    // redisTemplate.execute(new RedisCallback<Object>() {
    // @Override
    // public Object doInRedis(RedisConnection connection) throws DataAccessException {
    // String olduuid = redisTemplate.getStringSerializer().deserialize(connection.get(key.getBytes()));
    // log.debug("time send sign msg =={},{}", olduuid, value);
    // if (value.equals(olduuid)) {
    // signSendMsg(orgInfo, student, teacher, lesson, course, status);
    // }
    // return null;
    // }
    // });
    // }
    // }, 60 * 1000);
    // }

    @Override
    public void signSendMsg(OrgInfo orgInfo, OrgStudent student, Teacher teacher, OrgClassLesson lesson,
        OrgCourse course, OrgLessonSign orgLessonSign) {
        try {
            SendMsgRequest sendMsgRequest = getSendMsgRequest(orgInfo, student,
                teacher == null ? null : teacher.getRealName(), lesson, course, orgLessonSign);
            log.info("sendMsgRequest is:{}", sendMsgRequest);
            sendMsgRequest.setSmsCodeType(TxSmsCodeType.SIGN_NOTIFY_PRESENT);
            this.commonMsgService.sendMsg(sendMsgRequest);
        } catch (Exception e) {
            log.error("error : {} ", e);
            log.warn(e.getMessage());
        }
    }

    private Map<String, OrgLessonSign> conver2Map(List<OrgLessonSign> lessonSignIn) {
        return CollectorUtil.collectMap(lessonSignIn, new Function<OrgLessonSign, String>() {
            @Override
            public String apply(OrgLessonSign arg0) {
                String key = arg0.getUserId() + "|" + arg0.getLessonId();
                return key;
            }
        });
    }

    private void addToSigninMsgAsynModel(List<OrgLessonSign> lessonSignIn) {

        Map<String, OrgLessonSign> newSignin = conver2Map(lessonSignIn);
        for (Map.Entry<String, OrgLessonSign> entry : newSignin.entrySet()) {
            final String cacheKey = RedisKeyEnums.ERP.SIGINMSG_PREFIX.getRedisKey() + entry.getKey();
            final String value = UUID.randomUUID().toString();
            entry.getValue().setRandomUUID(value);
            redisTemplate.execute(new RedisCallback<Object>() {
                @Override
                public Object doInRedis(RedisConnection connection) throws DataAccessException {
                    connection.setEx(cacheKey.getBytes(), 60 * 2l, value.getBytes());
                    return null;
                }
            });
        }
        SigninMsgAsynModel.addNewLessonSignIn(newSignin);
    }

    @Override
    public SigninFailedDto signWithRemark(@NonNull Long orgId, SignWithRemarkRequest request, @NonNull Integer source,
        @NonNull Boolean sendSms) {
        Preconditions.checkArgument(null != request.getSignRemark() && request.getSignRemark().length() < 101,
            "签到备注为空或长度超过100!");
        SigninFailedDto result = new SigninFailedDto();
        List<OrgLessonSign> updateSigns = updateAndSave(orgId, request, source, result);

        List<Long> lessonIds = Lists.transform(updateSigns, new Function<OrgLessonSign, Long>() {
            @Override
            public Long apply(OrgLessonSign input) {
                return input.getLessonId();
            }
        });

        fillStudentInfo(orgId, result);

        if (sendSms && checkOrgPermissionSignMsg(orgId.intValue())) {
            Map<Long, OrgClassLesson> lessonMap =
                orgClassLessonDao.getClassLessonMap(orgId, lessonIds, DeleteStatus.NORMAL.getValue());
            Iterator<OrgLessonSign> iter = updateSigns.iterator();
            while (iter.hasNext()) {
                OrgLessonSign sign = iter.next();
                OrgClassLesson lesson = lessonMap.get(sign.getLessonId());
                if (lesson.getStartTime().after(DateUtil.getCurrentDate())
                    && lesson.getStartTime().before(DateUtil.getDiffDateTime(DateUtil.getCurrentDate(), 1))) {
                    continue;
                } else {
                    iter.remove();
                }
            }
            addToSigninMsgAsynModel(updateSigns);
        }

        long realCourseId = request.getCourseId();
        OrgCourse course = orgCourseDao.getById(request.getCourseId());
        if (CourseTypeEnum.isOneToOne(course.getCourseType())) {
            realCourseId = course.getParentId();
        }
        OrgCourseConsumeRule rule = courseConsumeRuleDao.getRuleByCourseId(orgId, realCourseId);
        LessonStatus lessonStatus = null;
        if (rule != null) {
            lessonStatus = KexiaoUtil.getKexiaoStatus(request.getStatus(), rule.getRuleValue());
            if (lessonStatus == LessonStatus.FINISHED) {// 修改为已上
                resetLesson(orgId, request.getCourseId(), lessonIds, Arrays.asList(request.getUserId()),
                    course.getChargeUnit(), request.getConfirm());
            }
        }
        return result;
    }

    @Transactional(rollbackFor = Exception.class)
    private List<OrgLessonSign> updateAndSave(Long orgId, SignWithRemarkRequest request, Integer source,
        SigninFailedDto result) {
        Integer status = request.getStatus();
        Long userId = orgStudentDao.getById(request.getStudentId(), "userId").getUserId();
        request.setUserId(userId);
        // 退转班的学生
        Map<Long, Integer> uIdStatusWithdrawMap =
            orgStudentCourseDao.userMapByStatus(orgId, request.getCourseId(), Arrays.asList(userId),
                Arrays.asList(StudentCourseStatus.WITHDRAW.getCode(), StudentCourseStatus.TRANSFER.getCode()));
        Collection<Long> inValidUserIds =
            CollectionUtils.intersection(Arrays.asList(userId), uIdStatusWithdrawMap.keySet());
        for (Long temp : inValidUserIds) {
            result.addFailedStudent(new SigninFailedDto.FailedStudent(temp, uIdStatusWithdrawMap.get(temp)));
        }
        log.info("Quit class can not modify allInvalidUserIds={}", uIdStatusWithdrawMap);

        List<Long> lessonIds = getLessonIds(request.getLessonIds());
        Long cascadeId = TianxiaoMContext.getTXCascadeIdLongZeroFill();
        this.checkArguments(orgId, request, userId);
        List<OrgLessonSign> inDBSigns =
            orgLessonSignDao.getStudentSign(orgId, userId, UserRole.STUDENT.getRole(), lessonIds);
        List<Long> notInDBSignIds = getSaveLessons(lessonIds, inDBSigns);
        updateSign(inDBSigns, request, cascadeId, source, result);
        List<OrgLessonSign> saveSigns = saveSign(orgId, notInDBSignIds, status, userId, request.getSignRemark(),
            request.getSendToStu(), cascadeId, source, result);
        changeLogService.addBatchSignLog(orgId, lessonIds, Arrays.asList(userId), status);
        log.debug("updateSigns:{}, saveSigns:{}", inDBSigns, saveSigns);
        inDBSigns.addAll(saveSigns);
        inDBSigns = Lists.newLinkedList(inDBSigns);
        return inDBSigns;
    }

    private List<Long> getLessonIds(String lessonIds) {
        List<Long> result = Lists.newArrayList();
        String[] s = lessonIds.split(",");
        for (String l : s) {
            result.add(Long.parseLong(l));
        }
        return result;
    }

    private void checkArguments(Long orgId, SignWithRemarkRequest request, Long userId) {
        Integer status = request.getStatus();
        Long studentId = request.getStudentId();
        List<Long> lessonIds = getLessonIds(request.getLessonIds());
        Preconditions.checkArgument(status != null && status >= 0, "签到状态不正确");
        Preconditions.checkArgument(lessonIds != null && lessonIds.size() >= 0, "课节ID不正确");
        Preconditions.checkArgument(orgId != null && orgId >= 0, "机构ID不正确");
        Preconditions.checkArgument(studentId != null && studentId >= 0, "学生ID不正确");
        Preconditions.checkArgument(userId != null && userId >= 0, "无法找到对应的学生ID:" + studentId);
    }

    private List<Long> getSaveLessons(List<Long> lessonIds, List<OrgLessonSign> lessonSigns) {
        List<Long> saveList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(lessonIds)) {
            return saveList;
        }
        if (CollectionUtils.isEmpty(lessonSigns)) {
            return lessonIds;
        }
        Map<Long, OrgLessonSign> map = Maps.newHashMap();
        for (OrgLessonSign o : lessonSigns) {
            map.put(o.getLessonId(), o);
        }
        for (Long l : lessonIds) {
            if (!map.containsKey(l)) {
                saveList.add(l);
            }
        }
        return saveList;
    }

    private void updateSign(List<OrgLessonSign> lessonSigns, SignWithRemarkRequest request, Long cascadeId,
        Integer source, SigninFailedDto result) {
        log.debug("failedStudents:{}, request:{}", result.getFailedStudentList(), request);
        if (CollectionUtils.isEmpty(lessonSigns)) {
            return;
        }
        Integer status = request.getStatus();
        // 只有正常签到或没退班才更新签到status
        if (request.getSource() == OrgLessonSignSourceEnum.NORMAL.getValue()
            && !result.getFailedStudentMap().containsKey(request.getUserId())) {
            for (OrgLessonSign o : lessonSigns) {
                if (status != null && !status.equals(o.getStatus())
                    || o.getSendToStu() != request.getSendToStu().intValue()
                    || !o.getSignRemark().equals(request.getSignRemark())) {
                    o.setStatus(status);
                    o.setSignRemark(request.getSignRemark());
                    o.setSendToStu(request.getSendToStu());
                    o.setCascadeId(cascadeId);
                    o.setTeacherId(0);
                    o.setSource(source);
                    orgLessonSignDao.update(o, "status", "signRemark", "sendToStu", "cascadeId", "source", "teacherId");
                }
            }
        } else {
            for (OrgLessonSign o : lessonSigns) {
                SigninFailedDto.FailedStudent failedStudent = result.getFailedStudentMap().get(o.getUserId());
                if (null != failedStudent && o.getStatus() != status) {// 只有更改status失败时才有返回failedDto
                    failedStudent.setSignStatus(o.getStatus());
                    failedStudent.setSignRemark(request.getSignRemark());
                    failedStudent.setSendToStu(request.getSendToStu());
                } else {
                    log.debug("failedList clear!");
                    result.getFailedStudentList().clear();
                    result.getFailedStudentMap().clear();
                }
                if (!o.getSignRemark().equals(request.getSignRemark())
                    || o.getSendToStu() != request.getSendToStu().intValue()) {
                    o.setSignRemark(request.getSignRemark());
                    o.setSendToStu(request.getSendToStu());
                    o.setCascadeId(cascadeId);
                    o.setTeacherId(0);
                    o.setSource(source);
                    orgLessonSignDao.update(o, "signRemark", "sendToStu", "cascadeId", "source", "teacherId");
                }
            }
        }
    }

    private List<OrgLessonSign> saveSign(Long orgId, List<Long> saveLessons, Integer status, Long userId,
        String signRemark, Integer sendToStu, Long cascadeId, Integer source, SigninFailedDto result) {
        log.debug("failedStudents:{}, userId:{}, status:{}", result.getFailedStudentList(), userId, status);
        if (CollectionUtils.isEmpty(saveLessons)) {
            return Collections.emptyList();
        }
        if (!result.getFailedStudentMap().containsKey(userId) || status == SignStatus.UNSIGN.getCode()) {
            List<OrgClassLesson> classLessons = orgClassLessonDao.getByIds(saveLessons);
            List<OrgLessonSign> saveList = Lists.newArrayList();
            for (OrgClassLesson lesson : classLessons) {
                OrgLessonSign obj = new OrgLessonSign();
                obj.setCourseId(lesson.getCourseId());
                obj.setCreateTime(new Date());
                obj.setLessonId(lesson.getId());
                obj.setOrgId(orgId);
                obj.setStatus(status);
                obj.setUpdateTime(new Date());
                obj.setUserId(userId);
                obj.setUserRole(UserRole.STUDENT.getRole());
                obj.setSignRemark(signRemark != null ? signRemark : "");
                obj.setSendToStu(sendToStu);
                obj.setCascadeId(cascadeId);
                obj.setTeacherId(0);
                obj.setSource(source);
                saveList.add(obj);
            }
            orgLessonSignDao.saveAll(saveList, false, "courseId", "createTime", "lessonId", "orgId", "status", "userId",
                "updateTime", "userRole", "signRemark", "sendToStu", "cascadeId", "source", "teacherId");
            return saveList;
        } else {
            return Collections.EMPTY_LIST;
        }
    }

    @Override
    public Map<String, OrgLessonSign> getLessonSignStatus(Collection<Long> lesssonIds) {
        if (CollectionUtils.isEmpty(lesssonIds)) {
            return Maps.newHashMap();
        }
        List<OrgLessonSign> lessonSignList = orgLessonSignDao.getByStudentLessonIds(lesssonIds);
        Map<String, OrgLessonSign> userLessonSign =
            CollectorUtil.collectMap(lessonSignList, new Function<OrgLessonSign, String>() {
                @Override
                public String apply(OrgLessonSign orgLessonSign) {
                    return orgLessonSign.getLessonId().longValue() + "_" + orgLessonSign.getUserId().longValue();
                }
            });
        return userLessonSign;
    }
}
