package com.baijia.tianxiao.sal.course.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @title LessonConflictEnum
 * @author zhangrui
 */
public enum LessonConflictEnum {

    NO_CONFLICT(-1,"没有冲突"),

    TEACHER_AND_ROOM(0, "老师冲突,教室冲突"),

    TEACHER(1, "老师冲突"),

    ROOM(2, "教室冲突"),

    ;

    private int code;

    private String note;

    private static Map<Integer, LessonConflictEnum> map;

    private LessonConflictEnum(int code, String note) {
        this.code = code;
        this.note = note;
    }

    static {
        map = new HashMap<>();
        for (LessonConflictEnum sign : LessonConflictEnum.values()) {
            map.put(sign.code, sign);
        }
    }

    public int getCode() {
        return this.code;
    }

    public String getNote() {
        return this.note;
    }

    public LessonConflictEnum getSignByCode(Integer code) {
        return map.get(code);
    }
}
