
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.course.dto.response;

import org.apache.commons.collections4.CollectionUtils;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import lombok.Data;

/**
 * @title TeacherCourseDto
 * @desc TODO
 * @author shanyu
 * @date 2016年3月30日
 * @version 1.0
 */
@Data
public class TeacherCourseDto {

    private Long courseId;

    private String courseName;

    private int lessonCount;

    private int minutes;

    private List<OrgTeacherLessonInfoDto> lessons;
    
    private int signCount;
    
    private int studentCount;
    
    private int leaveCount;
    
    private int absentCount;

    public void setLessons(List<OrgTeacherLessonInfoDto> lessons) {
        if (CollectionUtils.isNotEmpty(lessons)) {
            Collections.sort(lessons, new Comparator<OrgTeacherLessonInfoDto>() {
                @Override
                public int compare(OrgTeacherLessonInfoDto o1, OrgTeacherLessonInfoDto o2) {
                    return o1.getStartTime().compareTo(o2.getStartTime());
                }
            });
        }
        this.lessons = lessons;
        
        int tempStudentCount = 0;
        int tempSignCount = 0;
        int tempLeaveCount = 0;
        int tempAbsentCount = 0;
        for(OrgTeacherLessonInfoDto lesson:lessons){
            tempStudentCount+=lesson.getStudentCount();
            tempSignCount+=lesson.getSignCount();
            tempLeaveCount+=lesson.getLeaveCount();
            tempAbsentCount+=lesson.getAbsentCount();
        }
        this.studentCount = tempStudentCount;
        this.signCount = tempSignCount;
        this.leaveCount = tempLeaveCount;
        this.absentCount = tempAbsentCount;
    }
}
