package com.baijia.tianxiao.sal.course.service.syncThread;

import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupRefundDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupRefund;
import com.baijia.tianxiao.sal.course.service.OrgSignupCourseService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

/**
 * @author weihongyan
 * @description 修复默认的purchaseId
 * @date 16/01/2017
 */
@Slf4j
@Service
@Deprecated
public class SyncOrgSignupCourseServiceImpl2 {
    @Autowired
    private OrgSignupRefundDao orgSignupRefundDao;
    @Autowired
    private OrgSignupCourseService orgSignupCourseService;
    
    @Transactional
    public int update(int batch){
        int result = 0;
        PageDto pageDto = new PageDto();
        pageDto.setPageNum(1);
        pageDto.setPageSize(batch);
        Map<String, Object> params = Maps.newHashMap();
        params.put("signupPurchaseId", 0);
        List<OrgSignupRefund> signupCourseList = orgSignupRefundDao.queryByCondition(params, pageDto);
        log.info("-------------------select size:{}", signupCourseList.size());
        for(OrgSignupRefund course : signupCourseList){
            if(course.getSignupPurchaseId() == Flag.FALSE.getLong()){
                course.setSignupPurchaseId(orgSignupCourseService.randomSignupPurchaseId4Excel(course.getCreateTime()));
                orgSignupRefundDao.update(course, "signupPurchaseId");
                result++;
            }
        }
        return result;
    }
}
