
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2017 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.course.service.impl;

import java.util.Date;
import java.util.Map;
import java.util.Properties;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.constants.UserRoleEnum;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.wechat.constant.WechateTemplateMsgType;
import com.baijia.tianxiao.dto.msg.SendMsgRequest;
import com.baijia.tianxiao.dto.smstoken.StudentSmsTokenDto;
import com.baijia.tianxiao.sal.common.utils.NotifyMessageUtils;
import com.baijia.tianxiao.sal.course.constant.RestConfig;
import com.baijia.tianxiao.sal.course.service.WeixinTemplateMsgCreator;
import com.baijia.tianxiao.sal.course.util.WeixinUtils;
import com.baijia.tianxiao.util.CourseSmsTokenUtil;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.ShortUrlUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.google.common.collect.Maps;

import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time May 10, 2017
 * @Desc this guy is too lazy, nothing left.
 */
@Slf4j
@Service
public class WeixinTemplateMsgCreatorImpl implements WeixinTemplateMsgCreator {

    @Resource
    private Environment environment;

    /**
     * 签到提醒
     */
    @Override
    public SendMsgRequest createSignMsg(OrgInfo orgInfo, OrgStudent student, String teacherName, OrgClassLesson lesson,
        OrgCourse course, OrgLessonSign orgLessonSign) {
        SendMsgRequest request = new SendMsgRequest();
        request.setOrgId(orgInfo.getOrgId().longValue());
        request.setMobile(student.getMobile());
        request.setCountSms(false);
        request.setReceiverId(student.getId());
        request.setWeixinOpenId(student.getWeixin());
        request.setReceiverRole(UserRoleEnum.STUDENT);
        request.setSenderId(orgInfo.getOrgId().longValue());
        request.setSenderRole(UserRoleEnum.ORG);
        request.setWechatTemplateId(WechateTemplateMsgType.COURSE_SIGNIN_TO_STU.getValue());
        String studentName = getStringValue(student.getName());
        String orgName = orgInfo.getShortName();
        String courseName = course.getName();
        String signStatusStr = SignStatus.getSignStatusByCode(orgLessonSign.getStatus()).getMessage();
        String extention = getStringValue(orgInfo.getExtension());
        teacherName = getStringValue(teacherName);
        String smsContent = makeSmsContent(studentName, orgName, courseName, lesson.getName(), signStatusStr, extention,
            orgLessonSign.getSignRemark(), orgLessonSign.getSendToStu());
        request.setSmsContent(smsContent);
        Map<String, Object> params = Maps.newHashMap();
        String url = createClassSchedule(orgInfo.getOrgId().longValue(), student.getId());
        Date now = new Date();
        String courseTime = lesson.createCourseTime();
        params.put("first", this.createFirst(markFirst(studentName, orgName, orgLessonSign.getStatus(), courseTime,
            orgLessonSign.getSignRemark(), orgLessonSign.getSendToStu())));
        params.put("remark", this.createRemark(String.format(remark, extention)));
        params.put("url", url);
        params.put("keyword1", this.createKeyword(studentName));
        params.put("keyword2", this.createKeyword(DateUtil.getStrByDateFormate(now, "yyyy-MM-dd HH:mm")));
        params.put("keyword3",
            this.createKeyword(courseName + NotifyMessageUtils.generateLessonName(lesson.getName(), true)));
        params.put("keyword4", this.createKeyword(getStringValue(teacherName)));
        request.setWechatParams(params);
        log.debug("remind student comment the course! data={}", request);
        return request;
    }

    @Override
    public Map<String, Object> createCommentNotifyMsg() {
        return null;
    }

    /**
     * 提醒学员对老师进行评价
     */
    @Override
    public SendMsgRequest createWriteCommentNotifyMsg(String teacherName, OrgClassLesson lesson, OrgCourse course,
        OrgInfo orgInfo, OrgStudent student) {

        String smsContent = getStudentSmsContent(orgInfo.getOrgId().longValue(), lesson.getCourseId(), course.getName(),
            lesson.getName(), student, lesson.getNumber(), lesson.getId(), true);
        // String content = getStudentSmsContent(orgInfo.getOrgId().longValue(), lesson.getCourseId(), course.getName(),
        // "", student, lesson.getNumber(), lesson.getId(), false);
        String url = getStudentCommentUrl(orgInfo.getOrgId().longValue(), lesson.getCourseId(), course.getName(),
            student, lesson.getNumber(), lesson.getId());

        SendMsgRequest request = new SendMsgRequest();
        request.setOrgId(orgInfo.getOrgId().longValue());
        request.setMobile(student.getMobile());
        request.setCountSms(false);
        request.setReceiverId(student.getId());
        request.setWeixinOpenId(student.getWeixin());
        request.setReceiverRole(UserRoleEnum.STUDENT);
        request.setSenderId(orgInfo.getOrgId().longValue());
        request.setSenderRole(UserRoleEnum.ORG);
        request.setWechatTemplateId(WechateTemplateMsgType.COURSE_EVALUATION_TO_STU.getValue());
        Map<String, Object> params = Maps.newHashMap();
        request.setSmsContent(smsContent);

        params.put("first", this.createFirst(
            String.format(commontNotifyFromStuToTeacherFormat, student.getName(), orgInfo.getShortName())));
        params.put("remark", this.createRemark(commentNotifyFromStuToTeaRemark));
        params.put("keyword1", this.createKeyword(getStringValue(student.getName())));
        params.put("keyword2", this.createKeyword(
            getStringValue(course.getName()) + NotifyMessageUtils.generateLessonName(lesson.getName(), true)));
        params.put("keyword3", this.createKeyword(getStringValue(teacherName)));
        params.put("url", url);
        request.setWechatParams(params);

        log.debug("remind student comment the course! data={}", request);
        return request;
    }

    /**
     * 上课通知提醒
     */
    @Override
    public SendMsgRequest createCourseNotifyMsg(String teacherName, String roomName, OrgClassLesson lesson,
        OrgCourse course, OrgInfo orgInfo, OrgStudent student) {
        SendMsgRequest request = new SendMsgRequest();
        request.setOrgId(orgInfo.getOrgId().longValue());
        request.setMobile(student.getMobile());
        request.setCountSms(false);
        request.setReceiverId(student.getId());
        request.setWeixinOpenId(student.getWeixin());
        request.setReceiverRole(UserRoleEnum.STUDENT);
        request.setSenderId(orgInfo.getOrgId().longValue());
        request.setSenderRole(UserRoleEnum.ORG);
        request.setWechatTemplateId(WechateTemplateMsgType.COURSE_START_TO_STU.getValue());
        String smsContent =
            String.format(lessonStartStudent, getStringValue(student.getName()), getStringValue(orgInfo.getShortName()),
                getStringValue(course.getName()), NotifyMessageUtils.generateLessonName(lesson.getName(), false),
                DateUtil.getStrByDateFormate(lesson.getStartTime(), "yyyy-MM-dd HH:mm"),
                getStringValue(orgInfo.getExtension()));
        // 线上环境对机构orgId=22480 上课提醒做特殊话术修改，卢佳定制,测试环境orgId=3792,小心处理
        if (orgInfo != null && orgInfo.getOrgId() != null && orgInfo.getOrgId().intValue() == 22480) {
            smsContent = String.format(lessonStartStudent22480, getStringValue(student.getName()),
                getStringValue(orgInfo.getShortName()), getStringValue(course.getName()),
                NotifyMessageUtils.generateLessonName(lesson.getName(), false),
                DateUtil.getStrByDateFormate(lesson.getStartTime(), "yyyy-MM-dd HH:mm"),
                getStringValue(orgInfo.getExtension()));
        }
        String url = createClassSchedule(orgInfo.getOrgId().longValue(), student.getId());
        Map<String, Object> params = Maps.newHashMap();
        request.setSmsContent(smsContent);
        params.put("first",
            this.createFirst(String.format(lessonStartForWeixin, student.getName(), orgInfo.getShortName())));
        params.put("remark", this.createRemark(String.format(remark, orgInfo.getExtension())));
        params.put("keyword1", this.createKeyword(lesson.createFullCourseTime()));
        params.put("keyword2", this.createKeyword(getStringValue(teacherName)));
        params.put("keyword3", this.createKeyword(
            getStringValue(course.getName()) + NotifyMessageUtils.generateLessonName(lesson.getName(), true)));
        params.put("keyword4", this.createKeyword(getStringValue(roomName)));
        params.put("url", url);
        request.setWechatParams(params);
        log.debug("send msg={}", request);
        return request;
    }

    public JSONObject createFirst(String value) {
        return WeixinUtils.getTemplateMsgNode(value, "#27B2ED");
    }

    public JSONObject createRemark(String value) {
        return WeixinUtils.getTemplateMsgNode(value, "#27B2ED");
    }

    public JSONObject createKeyword(String value) {
        return WeixinUtils.getTemplateMsgNode(value, "#878788");
    }

    public String getStudentSmsContent(Long orgId, Long courseId, String courseName, String lessonName,
        OrgStudent student, Integer index, Long lessonId, boolean withUrl) {
        String url = getStudentCommentUrl(orgId, courseId, courseName, student, index, lessonId);
        String name = student.getName();
        if (StringUtils.isBlank(name)) {
            name = student.getNickName();
        }
        if (StringUtils.isBlank(name)) {
            name = MaskUtil.maskMobile(student.getMobile());
        }
        url = ShortUrlUtil.getShortUrl(url);
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(LESSON_COMMENT_STUDENT_SMS, name, courseName,
            NotifyMessageUtils.generateLessonName(lessonName, false)));
        if (withUrl) {
            return sb.append(String.format(URL, url)).toString();
        } else {
            return sb.toString();
        }
    }

    /**
     * 获取学员评价提醒url
     * 
     * @param orgId
     * @param courseId
     * @param courseName
     * @param student
     * @param index
     * @param lessonId
     * @return
     */
    private String getStudentCommentUrl(Long orgId, Long courseId, String courseName, OrgStudent student, Integer index,
        Long lessonId) {
        Map<String, Object> params = Maps.newHashMap();
        params.put("studentId", student.getId());
        params.put("courseId", courseId);
        String token;
        try {
            token = CourseSmsTokenUtil.encodeExpireToken(params, orgId, null);
            String url = environment.getProperty(RestConfig.student_center_add_comment_url);
            url = String.format(url, token, lessonId);
            return url;
        } catch (Exception e) {
            log.warn("get lesson student comment error", e);
            return null;
        }
    }

    private String makeSmsContent(String studentName, String orgName, String courseName, String lessonName,
        String signStatusStr, String extention, String signRemark, Integer sendToStu) {
        if (sendToStu != null && sendToStu == Flag.TRUE.getInt() && StringUtils.isNotBlank(signRemark)) {
            return String.format(smsContentWithRemark, studentName, orgName, courseName,
                NotifyMessageUtils.generateLessonName(lessonName, false), signStatusStr, extention, signRemark);
        } else {
            return String.format(smsContent, studentName, orgName, courseName,
                NotifyMessageUtils.generateLessonName(lessonName, false), signStatusStr, extention);
        }
    }

    /**
     * 没有名称返回“－”
     *
     * @param message
     * @return
     */
    private String getStringValue(String message) {
        if (StringUtils.isBlank(message)) {
            return defaultName;
        }
        return message;
    }

    public String markFirst(String stuName, String orgName, int signStatus, String courseTime, String remark,
        Integer sendToStu) {
        String signStatusStr = SignStatus.createSignStr(signStatus);
        String retStr = String.format(firstFormat, stuName, orgName, signStatusStr, courseTime);
        if (GenericsUtils.notNullAndEmpty(remark) && (sendToStu != null && sendToStu == Flag.TRUE.getInt())) {
            retStr += ("备注为:" + remark);
        }
        retStr += "\n";
        return retStr;
    }

    public String createClassSchedule(Long orgId, Long studentId) {
        try {
            Properties fillProperties = PropertiesReader.fillProperties("erp.properties");
            log.info("fillProperties is:{} ", fillProperties);
            String scheduleUrl = fillProperties.getProperty("student_class_schedule");
            if (GenericsUtils.isNullOrEmpty(scheduleUrl)) {
                return "";
            }
            StudentSmsTokenDto token = new StudentSmsTokenDto(orgId, null, studentId, null);
            token.setStudentId(studentId);
            return scheduleUrl.replace("#{TOKEN}", token.toTokenStr());
        } catch (Exception e) {
            log.error("error :{} ", e);
            log.info("can not create token with orgId:{} and studentId:{} ", orgId, studentId);
            return "";
        }
    }

}
