package com.baijia.tianxiao.sal.course.service.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;

import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.google.common.base.Function;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.signup.constant.SignupCourseStatus;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.sal.course.service.OrgSignupCourseService;

import lombok.extern.slf4j.Slf4j;


/**
 * @author : zhenyujian
 * @title : OrgSignupCourseServiceImpl
 * @description :
 * @date : 2016年12月19日 上午10:38:36
 */
@Service
@Slf4j
public class OrgSignupCourseServiceImpl implements OrgSignupCourseService {

    @Autowired
    private OrgSignupCourseDao orgSignupCourseDao;

    @Autowired
    private OrgCourseDao orgCourseDao;

    
    @Override
    public Long randomSignupPurchaseId4Excel(Date date){
        String fixLenthString = String.valueOf( (1 + new Random().nextDouble()) * Math.pow(10, 9) );
        fixLenthString =  fixLenthString.substring(2, 10);
    	String str = String.format("%s%s", new SimpleDateFormat("yyMMdd").format(date), fixLenthString); 
    	return Long.parseLong(str);
    }
    

    @Override
	public OrgSignupCourse saveOrgSignupCourseByExcel(Long orgId, Long signupPurchaseId, OrgCourse orgCourse, Long studentUserId, Integer lessonCount, Double payPrice, Integer chargeUnit){
        Date now = new Date();
        if(signupPurchaseId==null){
        	signupPurchaseId = randomSignupPurchaseId4Excel(now);
        }

        OrgSignupCourse orgSignupCourse = new OrgSignupCourse();
        orgSignupCourse.setOrgId(orgId);
        orgSignupCourse.setOrgCourseId(orgCourse.getId());
        orgSignupCourse.setOrgCourseNumber(orgCourse.getNumber());
        //orgSignupCourse.setOriginPrice((int) Math.round(coursePurchase.getTotalPrices() * 100));
        orgSignupCourse.setOriginPrice((int) Math.round(orgCourse.getPrice() * 100));
        orgSignupCourse.setUserId(studentUserId);
        orgSignupCourse.setLessonCount(lessonCount);
        orgSignupCourse.setCourseDiscount(100);
        orgSignupCourse.setPreferential(0);
        orgSignupCourse.setCount(1);
        orgSignupCourse.setPayPrice((long) Math.round(payPrice * 100));
        orgSignupCourse.setStudentPayPrice(0L);
        orgSignupCourse.setCreateTime(now);
        orgSignupCourse.setUpdateTime(now);
        orgSignupCourse.setStatus(SignupCourseStatus.IMPORT.getCode());
        orgSignupCourse.setChargeUnit(chargeUnit);
        orgSignupCourse.setSyncLessonCount(1);//SyncSignupLessonCount
        orgSignupCourse.setSignupPurchaseId(signupPurchaseId);
        log.debug("save orgSignupCourse info =={}", orgSignupCourse);
        orgSignupCourseDao.save(orgSignupCourse);
        return orgSignupCourse;
    }


	@Override
	public OrgSignupCourse saveOrgSignupCourseByExcel(Long orgId, Long signupPurchaseId, OrgCourse orgCourse, Long studentUserId, Integer lessonCount, Double payPrice){
		return saveOrgSignupCourseByExcel(orgId, signupPurchaseId, orgCourse, studentUserId, lessonCount, payPrice, orgCourse.getChargeUnit());
	}

    

    @Override
    public String getSignupCourseName(Long orgId, Long signupPurchaseId) {
        StringBuilder opInfo = new StringBuilder();
        List<OrgSignupCourse> signupCourseList = orgSignupCourseDao.loadByPurchaseId(signupPurchaseId);
        Map<Long, OrgSignupCourse> signupCourseMap = CollectorUtil.collectMap(signupCourseList, new Function<OrgSignupCourse, Long>() {
                    @Override
                    public Long apply(OrgSignupCourse orgSignupCourse) {
                        return orgSignupCourse.getOrgCourseId();
                    }
                });
        List<OrgCourse> courseList = orgCourseDao.getByIds(signupCourseMap.keySet());

        Map<Long, OrgCourse> courseMap = CollectorUtil.collectMap(courseList, new Function<OrgCourse, Long>() {
            @Override
            public Long apply(OrgCourse orgCourse) {
                return orgCourse.getId();
            }
        });

        for (int i = 0; i < signupCourseList.size(); i++) {
            opInfo.append(courseMap.get(signupCourseList.get(i).getOrgCourseId()).getName());
            if (i != signupCourseList.size() - 1) {
                opInfo.append(",");
            }
        }
        return opInfo.toString();
    }

    @Override
    public void saveSignupCourse(OrgSignupCourse course) {
        orgSignupCourseDao.update(course);
    }

    @Override
    public void updateSyncLessonCount(List<Long> signupPurchaseIds) {

    }
}
