
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.course.service.impl;

import java.util.Collection;
import java.util.Date;
import java.util.Map;

import javax.annotation.Resource;

import com.baijia.tianxiao.sal.kexiao.service.KexiaoChangeLogService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.dao.OrgCourseConsumeRuleDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseConsumeRule;
import com.baijia.tianxiao.sal.course.enums.CourseConsumeRuleEnum;
import com.baijia.tianxiao.sal.course.service.OrgCourseConsumeRuleService;
import com.google.common.collect.Maps;

import lombok.extern.slf4j.Slf4j;

/**
 * @title OrgCourseConsumeRuleImpl
 * @desc TODO 
 * @author leiruiqi
 * @date 2016年8月23日
 * @version 1.0
 */
@Slf4j
@Service("orgCourseConsumeRuleService")
public class OrgCourseConsumeRuleServiceImpl implements OrgCourseConsumeRuleService{

    @Resource
    private OrgCourseDao orgCourseDao;
    
    
    @Resource
    private OrgCourseConsumeRuleDao orgCourseConsumeRuleDao;
    
    @Resource
    private KexiaoChangeLogService changeLogService;
    
    @Override
    public Map<Long, Integer> queryCourseRuleMapByCourseIds(Long orgId, Collection<Long> courseIds) {
        Map<Long,Integer> allCourseConsumeRuleMap = Maps.newHashMap();
        if(CollectionUtils.isEmpty(courseIds)){
            return allCourseConsumeRuleMap;
        }
        Map<Long,Integer> courseConsumeRuleMap = orgCourseConsumeRuleDao.queryCourseRuleMapByCourseIds(orgId, courseIds);
        
        
        if(MapUtils.isNotEmpty(courseConsumeRuleMap)){
            allCourseConsumeRuleMap.putAll(courseConsumeRuleMap);
        }
        
        for(Long courseId:courseIds){
            
            //没有则是历史数据，历史数据默认规则是0
            if(!allCourseConsumeRuleMap.containsKey(courseId)){
                allCourseConsumeRuleMap.put(courseId, 0);
            }
            
        }
        
        return courseConsumeRuleMap;
            
    }

    @Override
    public Integer getRuleValueByCourseId(Long orgId, Long courseId) {
        OrgCourseConsumeRule rule = getRuleByCourseId(orgId,courseId);
        if(rule!=null && rule.getRuleValue()!=null){
            return rule.getRuleValue();
        }else {
            return CourseConsumeRuleEnum.TIME_0.getValue();
        }

        
    }

    @Override
    public Integer getRuleValueByCourseId(Long orgId,OrgCourse orgCourse) {
        
        OrgCourseConsumeRule rule = getRuleByCourseId(orgId,orgCourse);
        return rule.getRuleValue();
    }

    @Override
    public OrgCourseConsumeRule create(Long orgId, Long courseId, Integer ruleValue) {
        
        OrgCourseConsumeRule rule = new OrgCourseConsumeRule();
        rule.setOrgId(orgId);
        rule.setCourseId(courseId);
        rule.setRuleValue(ruleValue);
        Date now = new Date();
        rule.setCreateTime(now);
        rule.setUpdateTime(now);
        
        orgCourseConsumeRuleDao.save(rule);
        log.info("OrgCourseConsumeRuleService createRule orgId:{},courseId:{},ruleValue:{}",orgId,courseId,ruleValue);
        return rule;
    }

    @Override
    public boolean updateRuleValue(Long orgId, Long courseId, Integer ruleValue) {
        
        OrgCourseConsumeRule rule = new OrgCourseConsumeRule();
        rule.setOrgId(orgId);
        rule.setCourseId(courseId);
        rule.setRuleValue(ruleValue);
        Map<String, Object> updateCondtion = Maps.newHashMap();
        updateCondtion.put("orgId", orgId);
        updateCondtion.put("courseId", courseId);
        updateCondtion.put("ruleValue", ruleValue);
        updateCondtion.put("updateTime",new Date());
        int count = orgCourseConsumeRuleDao.update(updateCondtion, "ruleValue","updateTime");
        log.info("OrgCourseConsumeRuleService updateRuleValue orgId:{},courseId:{},ruleValue:{}",orgId,courseId,ruleValue);
        if(count>0){
            return true;
        }
        return false;
    }

    @Override
    public void saveOfupdate(Long orgId, Long courseId, Integer ruleValue) {
        
        OrgCourseConsumeRule rule = orgCourseConsumeRuleDao.getRuleByCourseId(orgId, courseId);
        if(rule !=null){
            int oldRule = rule.getRuleValue();
            this.updateRuleValue(orgId, courseId, ruleValue);
            rule.setRuleValue(ruleValue);
            if(oldRule!=ruleValue) {
                changeLogService.addRuleChangedLog(rule);
            }
        }else{
            rule = this.create(orgId, courseId, ruleValue);
            changeLogService.addRuleChangedLog(rule);
        }
    }

    @Override
    public OrgCourseConsumeRule getRuleByCourseId(Long orgId, Long courseId) {
        
        OrgCourse orgCourse = this.orgCourseDao.getByCourseId(courseId);
        return this.getRuleByCourseId(orgId, orgCourse);
        
    }


    @Override
    public OrgCourseConsumeRule getRuleByCourseId(Long orgId,OrgCourse orgCourse) {
        
        Long ruleCourseId = orgCourse.getId();
        //是1v1课 并且是班级，则需要查询父课程的id看课消规则
        if(orgCourse.getCourseType()==CourseTypeEnum.COURSE_TYPE_1v1.getCode() && orgCourse.getIsClass() == CourseTypeEnum.IS_CLASS_TRUE.getCode()){
            ruleCourseId = orgCourse.getParentId();
        }
        //获取课消规则
        OrgCourseConsumeRule rule = orgCourseConsumeRuleDao.getRuleByCourseId(orgId, ruleCourseId);
        if(rule == null){
            rule = new OrgCourseConsumeRule();
        }
        //获取课消规则对应的描述
        String ruleDesc = CourseConsumeRuleEnum.getRuleDescByValue(rule.getRuleValue());
        rule.setRuleDesc(ruleDesc);
        
        return rule;
            
    }

   
    /*@Override
    public OrgCourseConsumeRule getOrgDefaultRule(Long orgId) {
        OrgCourseConsumeRule defaultRule = new OrgCourseConsumeRule();
        TXCommonRule commonRule = tXCommonRuleService.getByOrgId(orgId.intValue());
        if(commonRule!=null && commonRule.getConsumeRule()!=null){
            Integer defaultConsumeRuleValue = commonRule.getConsumeRule();
            defaultRule.setRuleValue(defaultConsumeRuleValue);
            String defaultRuleDesc = CourseConsumeRuleEnum.getRuleDescByValue(defaultConsumeRuleValue);
            defaultRule.setRuleDesc(defaultRuleDesc);
        }
        return defaultRule;
            
    }*/
    
   

}

    