package com.baijia.tianxiao.sal.course.dto.response;

import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author weihongyan
 * @description TODO
 * @date 11/01/2017
 */
@Data
public class SigninFailedDto {
    
    private List<FailedStudent> failedStudentList;
    @JsonIgnore
    private Map<Long, FailedStudent> failedStudentMap;
    
    public SigninFailedDto(){
        this.failedStudentList = new ArrayList<>();
        this.failedStudentMap = new HashMap<>();
    }
    
    public void addFailedStudent(FailedStudent failedStudent){
        failedStudentList.add(failedStudent);
        failedStudentMap.put(failedStudent.getUserId(), failedStudent);
    }
    
    public FailedStudent getFailedStudent(Long userId){
        return failedStudentMap.get(userId);
    }
    
    @Data
    public static class FailedStudent{
        @JsonIgnore
        private Long userId;
        private Long studentId;
        private String name;
        private Integer signStatus;
        private Integer sendToStu;
        private String signRemark;
        private Integer status;
        
        public FailedStudent(Long userId, Integer status){
            this.userId = userId;
            this.status = status;
            this.signStatus = SignStatus.UNSIGN.getCode();
            this.signRemark = "";
            this.sendToStu = Flag.FALSE.getInt();
        }
    }

    public static void main(String[] args) {
        SigninFailedDto dto = new SigninFailedDto();
        System.out.println(JacksonUtil.obj2Str(dto));
    }

}
