
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.course.constant;

import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.ErrorSide;
import com.baijia.tianxiao.enums.Platform;
import com.baijia.tianxiao.enums.Subsystem;

/**
 * @title CourseErrorCode
 * @desc TODO
 * @author bjhl
 * @date 2015年12月26日
 * @version 1.0
 */

public enum CourseErrorCode implements UniverseErrorCode {

    UNKNOW(1, "未知类型错误"),

    COURSE_NOT_EXIST(1001, "课程不存在"),

    LESSON_NOT_EXIST(1002, "课节不存在"),

    LESSON_NOT_SET_TEACHER_SMS(1003, "(未设置老师)无效课节，不能评价"),

    RECEIVER_NOT_EXIST(1004, "接收人数为0"),
    COURSE_EXSIST(1005, "课程重复"),
    COURSE_IMPORT_COL_FORMAT_ERROR(1006, "数据格式错误")
    ;
    private ErrorSide errorSide;
    private Subsystem subsystem;
    private Platform platform;
    private int code;
    private String message;

    private CourseErrorCode(int code, String msg) {
        this.errorSide = ErrorSide.SERVER;
        this.subsystem = Subsystem.STUDENT;
        this.platform = Platform.PC;
        this.code = code;
        this.message = msg;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getErrorSide()
     */
    @Override
    public ErrorSide getErrorSide() {
        return errorSide;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getSystem()
     */
    @Override
    public Subsystem getSystem() {
        return subsystem;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getPlatform()
     */
    @Override
    public Platform getPlatform() {
        return platform;
    }

    @Override
    public int getSubsystemErrorCode() {
        return code;
    }

    @Override
    public String getMessage() {
        return message;
    }

    @Override
    public CourseErrorCode fromCode(int code) {
        for (CourseErrorCode errorCode : values()) {
            if (errorCode.getSubsystemErrorCode() == code) {
                return errorCode;
            }
        }
        return CourseErrorCode.UNKNOW;
    }

}
