/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.course.enums;

import com.baijia.tianxiao.constant.SignStatus;
import java.util.List;

public enum CourseConsumeRuleEnum {
    TIME_0(0, "\u8bfe\u8282\u5f00\u8bfe\u81ea\u52a8\u7b97\u8bfe\u6d88"),
    SIGNIN_1(1, "\u5230\u8bfe\u7b97\u8bfe\u6d88"),
    SIGNIN_3(3, "\u5230\u8bfe\u3001\u8bf7\u5047\u7b97\u8bfe\u6d88"),
    SIGNIN_5(5, "\u5230\u8bfe\u3001\u7f3a\u8bfe\u7b97\u8bfe\u6d88"),
    SIGNIN_7(7, "\u5230\u8bfe\u3001\u8bf7\u5047\u3001\u7f3a\u8bfe\u7b97\u8bfe\u6d88");

    private Integer value;
    private String desc;

    public Integer getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    private CourseConsumeRuleEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getRuleDescByValue(Integer ruleValue) {
        if (ruleValue == null) {
            return "\u8bfe\u8282\u5f00\u8bfe\u81ea\u52a8\u7b97\u8bfe\u6d88";
        }
        for (CourseConsumeRuleEnum rule : CourseConsumeRuleEnum.values()) {
            if (rule.getValue().intValue() != ruleValue.intValue()) continue;
            return rule.getDesc();
        }
        return null;
    }

    public static CourseConsumeRuleEnum getRuleByValue(Integer ruleValue) {
        if (ruleValue == null) {
            return null;
        }
        for (CourseConsumeRuleEnum rule : CourseConsumeRuleEnum.values()) {
            if (rule.getValue().intValue() != ruleValue.intValue()) continue;
            return rule;
        }
        return null;
    }

    public static boolean checkRuleValueEffect(Integer ruleValue) {
        if (ruleValue == null) {
            return false;
        }
        for (CourseConsumeRuleEnum rule : CourseConsumeRuleEnum.values()) {
            if (rule.getValue().intValue() != ruleValue.intValue()) continue;
            return true;
        }
        return false;
    }

    public static boolean signStatusEnumIsConsume(Integer consumsRuleValue, SignStatus signStatus) {
        if (consumsRuleValue == null || consumsRuleValue == 0) {
            return true;
        }
        if (signStatus == null) {
            return false;
        }
        if (signStatus == SignStatus.UNSIGN) {
            return false;
        }
        if (signStatus == SignStatus.SIGNED) {
            return true;
        }
        if (signStatus == SignStatus.LEAVE) {
            return (2 | consumsRuleValue) == consumsRuleValue;
        }
        if (signStatus == SignStatus.ABSENT) {
            return (4 | consumsRuleValue) == consumsRuleValue;
        }
        return false;
    }

    public static boolean signStatusCodeIsConsume(Integer consumsRuleValue, Integer signCode) {
        if (signCode == null) {
            return CourseConsumeRuleEnum.signStatusEnumIsConsume(consumsRuleValue, null);
        }
        if (signCode < 0) {
            return false;
        }
        SignStatus signStatus = SignStatus.getSignStatusByCode((Integer)signCode);
        return CourseConsumeRuleEnum.signStatusEnumIsConsume(consumsRuleValue, signStatus);
    }

    public static int calculateConsumeTimesBySignCodeList(Integer consumsRuleValue, List<Integer> signCodeList) {
        if (consumsRuleValue == null || consumsRuleValue == 0) {
            throw new RuntimeException();
        }
        int count = 0;
        for (Integer code : signCodeList) {
            boolean bool = CourseConsumeRuleEnum.signStatusCodeIsConsume(consumsRuleValue, code);
            if (!bool) continue;
            ++count;
        }
        return count;
    }
}

