package com.baijia.tianxiao.sal.course.dto.response;

import java.util.List;

import org.apache.commons.collections.CollectionUtils;

import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.google.common.collect.Lists;

import lombok.Data;

@Data
public class CourseDto {

	//课程id
	private Long courseId;
	
	//课程名称
	private String courseName;

	public static List<CourseDto> converToDto(List<OrgCourse> orgCourses) {
		List<CourseDto> dtos = Lists.newArrayList();
		if(CollectionUtils.isNotEmpty(orgCourses)) {
			for(OrgCourse orgCourse : orgCourses) {
				if(orgCourse.getIsDel() == 0) {
					CourseDto dto = new CourseDto();
					dto.setCourseId(orgCourse.getId());
					dto.setCourseName(orgCourse.getName());
					dtos.add(dto);
				}				
			}	
		}
		return dtos;
	}	
	
}
