/**
 * 
 */
package com.baijia.tianxiao.sal.course.service.impl;

import com.baijia.tianxiao.dal.org.dao.*;
import com.baijia.tianxiao.dal.org.po.*;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.sal.course.dto.SigninMsgAsynModel;
import com.baijia.tianxiao.sal.course.service.OrgLessonSignService;
import com.baijia.tianxiao.sal.course.service.SendSigninMsgService;
import com.baijia.tianxiao.util.CollectorUtil;
import com.beust.jcommander.internal.Lists;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author leiruiqi
 *
 */
@Slf4j
@Service("SendSigninMsgService")
public class SendSigninMsgServiceImpl implements SendSigninMsgService{

	@Resource
    private OrgClassLessonDao orgClassLessonDao;
	
	@Resource
	private OrgLessonSignService orgLessonSignService;
	
	@Resource
    private OrgTeacherLessonDao orgTeacherLessonDao;

    @Resource
    private TeacherDao teacherDao;
    
    @Resource
    private OrgStudentDao orgStudentDao;
    
    @Resource
    private OrgCourseDao orgCourseDao;
    
    @Resource
    private OrgInfoDao orgInfoDao;
    
    @Autowired
    private StringRedisTemplate redisTemplate;
	
    @Scheduled(cron="0 0/1 * * * ?")
    @Override
    public void sendSignInMessageTask(){
    	getOldAndResetNew();
    }
	private void getOldAndResetNew(){
		Map<String,OrgLessonSign>  readySendSignInMap = SigninMsgAsynModel.getOldAndResetNew();
		int size = readySendSignInMap.size();
		log.info("sendSignInMessageTask start ,find "+size +" singIn record change");
		if(size == 0){
			return ;
		}
		Set<Long> lessonIds = Sets.newHashSet();
		Set<Long> courseIds = Sets.newHashSet();
		Set<Integer> orgIds = Sets.newHashSet();
		Set<Long> longOrgIds = Sets.newHashSet();
		Set<Long> studentUserIds = Sets.newHashSet();
		Map<Long,Long> lessonTeacherIdMap = Maps.newHashMap();
		
		Map<Long,Teacher> teacherIdNameMap = Maps.newHashMap();
		
		Map<Long,OrgClassLesson> lessonMap = Maps.newHashMap();
		
		Map<Long,OrgInfo> orgInfoMap = Maps.newHashMap();
		
		Map<Long,List<OrgLessonSign>> lessonSignInMap = Maps.newHashMap();
		
		for(OrgLessonSign orgLessonSign:readySendSignInMap.values()){
			
			lessonIds.add(orgLessonSign.getLessonId());
			courseIds.add(orgLessonSign.getCourseId());
			if(orgLessonSign.getOrgId()!=null){
			    orgIds.add(orgLessonSign.getOrgId().intValue());
	            longOrgIds.add(orgLessonSign.getOrgId());
			}
			
			studentUserIds.add(orgLessonSign.getUserId());
			List<OrgLessonSign> tempLessonSignInList = lessonSignInMap.get(orgLessonSign.getLessonId());
			if(tempLessonSignInList == null){
				tempLessonSignInList = Lists.newArrayList();
				lessonSignInMap.put(orgLessonSign.getLessonId(),tempLessonSignInList);
			}
			tempLessonSignInList.add(orgLessonSign);
		}
		Map<String, OrgStudent> studentInfos = getStudentInfos(longOrgIds, studentUserIds);
		Map<Long, OrgCourse> courseInfos = getCourseInfos(courseIds);
		
		List<OrgClassLesson> lessons = this.orgClassLessonDao.getByIds(lessonIds);
		for(OrgClassLesson lesson:lessons){
			lessonMap.put(lesson.getId(), lesson);
		}
		
		Map<Long, OrgTeacherLesson> orgTeacherLessonMap = orgTeacherLessonDao.getOrgTeacherLessonMapByLessonIds(lessonIds);
		Set<Long> teacherIds = Sets.newHashSet();
		for(Long lessonId:lessonIds){
			OrgTeacherLesson orgTeacherLesson = orgTeacherLessonMap.get(lessonId);
			if(orgTeacherLesson != null){
				teacherIds.add(orgTeacherLesson.getTeacherId());
				lessonTeacherIdMap.put(lessonId, orgTeacherLesson.getTeacherId());
			}
			
		}
		List<Teacher> teacherList = teacherDao.getByUserIds(teacherIds);
		for(Teacher teacher:teacherList){
			teacherIdNameMap.put(teacher.getUserId(), teacher);
		}
		
		List<OrgInfo> orgInfos = orgInfoDao.getOrgInfos(orgIds);
		
		orgInfoMap =  CollectorUtil.collectMap(orgInfos, new Function<OrgInfo, Long>() {
            @Override
            public Long apply(OrgInfo arg0) {
                return arg0.getOrgId().longValue();
            }
        });
		
		log.info("sendSignInMessageTask start orgInfos={}",orgInfos);
		log.info("sendSignInMessageTask start teacherList={}",teacherList);
		log.info("sendSignInMessageTask start lessons={}",lessons);
		log.info("sendSignInMessageTask start courseInfos={}",courseInfos);
		log.info("sendSignInMessageTask start studentInfos={}",studentInfos);
		for(Long lessonId:lessonIds){
			
			List<OrgLessonSign> tempLessonSignInList = lessonSignInMap.get(lessonId);
			log.info("lesson signin message lesson id={},signInList={}",lessonId,tempLessonSignInList);
			OrgClassLesson lesson = lessonMap.get(lessonId);
			if(lesson == null){
				log.info("lesson signin message send fail ,OrgClassLesson  null");
				continue;
			}
			
			OrgCourse course = courseInfos.get(lesson.getCourseId());
			if(course == null){
				log.info("lesson signin message send fail ,course  null");
				continue;
			}
			
			OrgInfo orgInfo = orgInfoMap.get(lesson.getOrgId());
			if(orgInfo == null){
				log.info("lesson signin message send fail ,orgInfo null");
				continue;
			}
			Teacher teacher = null;
			Long teacherId = lessonTeacherIdMap.get(lessonId);
			if(teacherId!=null){
				teacher = teacherIdNameMap.get(teacherId);
			}
			
			for(OrgLessonSign orgLessonSign :tempLessonSignInList){
				
				
				OrgStudent student  = studentInfos.get(String.valueOf(orgInfo.getOrgId()) + String.valueOf('|') + String.valueOf(orgLessonSign.getUserId()));
				if(student==null){
					log.info("lesson signin message send fail ,student  null");
					continue;
				}
				if(checkKeyValueMatch(orgLessonSign)){
					orgLessonSignService.signSendMsg(orgInfo, student, teacher, lesson, course, orgLessonSign.getStatus());
				}
				
				
			}
			
		}
		
	}
	
	
	private Map<String, OrgStudent> getStudentInfos(Collection<Long> orgIds, Collection<Long> userIds) {
        List<OrgStudent> students = this.orgStudentDao.getStudentsByUserIdsAndOrgIds(orgIds, userIds);
        return CollectorUtil.collectMap(students, new Function<OrgStudent, String>() {
            @Override
            public String apply(OrgStudent arg0) {
                return String.valueOf(arg0.getOrgId()) + String.valueOf('|') + String.valueOf(arg0.getUserId());
            }
        });
    }
	
	/**
     * 获取课程信息
     *
     * @param courseIds
     * @return
     */
    private Map<Long, OrgCourse> getCourseInfos(Collection<Long> courseIds) {
        List<OrgCourse> courses = this.orgCourseDao.getByIds(courseIds);
        return CollectorUtil.collectMap(courses, new Function<OrgCourse, Long>() {
            @Override
            public Long apply(OrgCourse arg0) {
                return arg0.getId();
            }
        });
    }
    
    private boolean checkKeyValueMatch(OrgLessonSign orgLessonSign){
    	final String cacheKey = "siginMsg_"+orgLessonSign.getUserId() + "|" + orgLessonSign.getLessonId();
    	Object result = redisTemplate.execute(new RedisCallback<Object>() {
            @Override
            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                String olduuid = redisTemplate.getStringSerializer().deserialize(connection.get(cacheKey.getBytes()));
                return olduuid;
            }
        });
    	if(result==null){
    	    return true;
    	}
    	else if(result instanceof String){
    		String olduuid = (String)result;
    		return StringUtils.equals(orgLessonSign.getRandomUUID(), olduuid);
    	}
    	return false;
    }
	
}
