
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.course.service.impl;

import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassRoomDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.po.ClassHour;
import com.baijia.tianxiao.dal.org.po.LessonSignAudit;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.excel.dto.ExportField;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.course.dto.request.TeacherClassHourRequestDto;
import com.baijia.tianxiao.sal.course.dto.response.OrgTeacherLessonInfoDto;
import com.baijia.tianxiao.sal.course.dto.response.TeacherClassHourDto;
import com.baijia.tianxiao.sal.course.dto.response.TeacherCourseDto;
import com.baijia.tianxiao.sal.course.service.OrgTeacherClassHourService;
import com.baijia.tianxiao.sal.course.util.ExcelExportService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.stereotype.Service;

/**
 * @title OrgTeacherClassHourServiceImpl
 * @desc TODO
 * @author shanyu
 * @date 2016年3月31日
 * @version 1.0
 */
@Slf4j
@Service
public class OrgTeacherClassHourServiceImpl implements OrgTeacherClassHourService {

    @Resource
    private OrgClassLessonDao orgClassLessonDao;

    @Resource
    private OrgLessonSignDao orgLessonSignDao;

    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;

    @Resource
    private TeacherDao teacherDao;

    @Resource
    private StorageDao storageDao;

    @Resource
    private OrgCourseDao orgCourseDao;

    @Resource
    private OrgClassRoomDao orgClassRoomDao;

    @Resource
    private OrgTeacherLessonDao orgTeacherLessonDao;

    @Resource
    private OrgInfoDao orgInfoDao;

    @Override
    public List<TeacherClassHourDto> queryTeacherClassHourList(Long orgId, TeacherClassHourRequestDto params,
        PageDto page) {
        Preconditions.checkArgument(orgId != null, "orgId is null!");
        Preconditions.checkArgument(params.getStartTimeDate() != null, "startTime is null!");
        Preconditions.checkArgument(params.getEndTimeDate() != null, "endTime is null!");
        log.info("query classHour list of teacher, orgId={},params={},page={}", orgId, params, page);
        List<Long> lessonIds =
            orgClassLessonDao.queryFinishedLessonIds(orgId, null, params.getStartTimeDate(), params.getEndTimeDate());
        log.debug("teacher lessonIds={},size={}", lessonIds, lessonIds.size());
        if (CollectionUtils.isEmpty(lessonIds)) {
            return Lists.newArrayList();
        } else {
            List<ClassHour> classHourList = orgClassLessonDao.queryTeacherClassHourList(lessonIds, null, page, false);
            log.debug("teacher ClassHourList={},size={}", classHourList, classHourList.size());
            Set<Long> teacherIds = Sets.newHashSet();
            for (ClassHour classHour : classHourList) {
                teacherIds.add(classHour.getTeacherId());
            }
            
            List<Teacher> teacherList = this.teacherDao.getByTeacherIds(teacherIds);
            Map<Long, Teacher> teacherMap = CollectorUtil.collectMap(teacherList, new Function<Teacher, Long>() {
                @Override
                public Long apply(Teacher arg0) {
                    return arg0.getUserId();
                }
            });
            
            
                
            Map<Long, LessonSignAudit> signAuditMap = this.orgLessonSignDao.queryLessonSignAudit(orgId, lessonIds);
          
            Map<Long, Integer> lessonStudentCountMap = orgStudentLessonDao.queryLessonStudentCountMap(orgId, lessonIds);
            Map<Long,Long> lessonTeacherMap = orgTeacherLessonDao.queryLessonTeacherIdMap(orgId, lessonIds);
            
            Map<Long,Integer> teacherSignCountMap =  buildAllTeacherLessonSign(lessonIds,lessonTeacherMap,signAuditMap,lessonStudentCountMap);
            
            return buildDtoList(classHourList, teacherMap,teacherSignCountMap);
        }
    }
    
    private Map<Long,Integer> buildAllTeacherLessonSign(List<Long> lessonIds, Map<Long,Long> lessonTeacherMap,Map<Long, LessonSignAudit> signAuditMap,Map<Long, Integer> lessonStudentCountMap){
        Map<Long,Integer> teacherSignCountMap = Maps.newHashMap();
        
        for (Long lessonId : lessonIds) {
            Long teacherId = lessonTeacherMap.get(lessonId);
            if (teacherId != null) {
                if (signAuditMap != null && signAuditMap.containsKey(lessonId) && lessonStudentCountMap.containsKey(lessonId)) {
                    int studentCount = lessonStudentCountMap.get(lessonId);
                    LessonSignAudit signAudit = signAuditMap.get(lessonId);
                    int signCount = signAudit.getSignCount() > studentCount ? studentCount : signAudit.getSignCount();
                    int leaveCount =
                        signAudit.getLeaveCount() > studentCount ? studentCount : signAudit.getLeaveCount();
                    int absentCount =
                        signAudit.getAbsentCount() > studentCount ? studentCount : signAudit.getAbsentCount();
                    int unsignCount = studentCount - signCount - leaveCount - absentCount;
                    unsignCount = unsignCount < 0 ? 0 : unsignCount;

                    Integer teacherSignCount = teacherSignCountMap.get(teacherId);
                    
                    if(teacherSignCount==null){
                        teacherSignCount = new Integer(0);
                        //teacherSignCountMap.put(teacherId, teacherSignCount);
                    }
                    teacherSignCount+=signCount;
                    teacherSignCountMap.put(teacherId, teacherSignCount);
                }
            }
        }
        return teacherSignCountMap;
    }

    private List<TeacherClassHourDto> buildDtoList(List<ClassHour> classHourList, Map<Long, Teacher> teacherMap,Map<Long,Integer> teacherSignCountMap) {
        
        if (!teacherMap.isEmpty()) {
            List<TeacherClassHourDto> result = Lists.newArrayList();
            Set<Long> avatarIds = Sets.newHashSet();
            for (Teacher teacher : teacherMap.values()) {
                if (teacher.getAvatar() != null && teacher.getAvatar() > 0) {
                    avatarIds.add(teacher.getAvatar());
                }
            }
            List<Storage> storageList = storageDao.getByIds(avatarIds);
            Map<Long, String> avatarMap = getAvatarMap(storageList);
            for (ClassHour classHour : classHourList) {
                //buildTeacherCourseDto();
                
                TeacherClassHourDto dto = new TeacherClassHourDto();
                Teacher teacher = teacherMap.get(classHour.getTeacherId());
                if(teacher==null){
                    continue;
                }
                dto.setTeacherId(teacher.getUserId());
                dto.setTeacherName(teacher.getRealName());
                dto.setAvatar(avatarMap.get(teacher.getAvatar()));
                dto.setMinutes(classHour.getMinutes());
                dto.setLessonCount(classHour.getLessonCount());
                
                Integer signCount = teacherSignCountMap.get(classHour.getTeacherId());
                if(signCount!=null){
                    dto.setSignCount(signCount); 
                }
                result.add(dto);
            }
            return result;
        }
        return Collections.emptyList();
    }

    private Map<Long, String> getAvatarMap(List<Storage> storageList) {
        if (CollectionUtils.isNotEmpty(storageList)) {
            Map<Long, String> result = Maps.newHashMap();
            for (Storage storage : storageList) {
                result.put(storage.getId(),
                    StorageUtil.constructUrl(storage.getFid(), storage.getMimetype(), storage.getSn()));
            }
            return result;
        } else {
            return Collections.emptyMap();
        }
    }

    @Override
    public TeacherClassHourDto queryTeacherClassHourDetail(Long orgId, TeacherClassHourRequestDto params,
        PageDto page) {
        Preconditions.checkArgument(orgId != null, "orgId is null!");
        Preconditions.checkArgument(params.getStartTimeDate() != null, "startTime is null!");
        Preconditions.checkArgument(params.getEndTimeDate() != null, "endTime is null!");
        Preconditions.checkArgument(params.getTeacherId() != null, "teacherId is null!");
        log.info("query classHour detail of teacher, orgId={},page={},params={}", orgId, page, params);
        List<Long> lessonIds = orgClassLessonDao.queryFinishedLessonIds(orgId, params.getTeacherId(),
            params.getStartTimeDate(), params.getEndTimeDate());
        log.debug("teacher lessonIds={},size={}", lessonIds, lessonIds.size());
        final TeacherClassHourDto teacherClassHourDto = new TeacherClassHourDto();
        if (CollectionUtils.isEmpty(lessonIds)) {
            return teacherClassHourDto;
        }
        teacherClassHourDto.setLessonCount(lessonIds.size());
        List<ClassHour> classHourList =
            orgClassLessonDao.queryTeacherClassHourList(lessonIds, params.getTeacherId(), page, true);
        ClassHour teacherClassHour = orgClassLessonDao.queryTeacherClassHour(lessonIds, params.getTeacherId());
        teacherClassHourDto.setMinutes(teacherClassHour.getMinutes());
        log.debug("teacher classHourList={},size={}", classHourList, classHourList.size());
        Map<Long, ClassHour> classHourMap = CollectorUtil.collectMap(classHourList, new Function<ClassHour, Long>() {
            @Override
            public Long apply(ClassHour arg0) {
                return arg0.getCourseId();
            }
        });
        log.debug("teacher courseIds={},size={}", classHourMap.keySet(), classHourMap.keySet().size());

        Map<Long, List<OrgClassLesson>> lessonMap =
            this.orgClassLessonDao.getLessonMapByCourseAndLessonIds(orgId, classHourMap.keySet(), lessonIds);

        Map<Long, String> courseNameMap = this.orgCourseDao.getCourseNameMap(classHourMap.keySet());
        log.debug("courseNameMap={}", courseNameMap);
        
        Map<Long, LessonSignAudit> signAuditMap = this.orgLessonSignDao.queryLessonSignAudit(orgId, lessonIds);
        Map<Long, Integer> lessonStudentCountMap = orgStudentLessonDao.queryLessonStudentCountMap(orgId, lessonIds);
        
        List<TeacherCourseDto> result = Lists.newArrayList();
        for (ClassHour classHour : classHourList) {
            result.add(buildTeacherCourseDto(classHourMap.get(classHour.getCourseId()),
                lessonMap.get(classHour.getCourseId()), courseNameMap.get(classHour.getCourseId()), null, signAuditMap, lessonStudentCountMap));
        }
        teacherClassHourDto.setCourses(result);
        return teacherClassHourDto;
    }

    private TeacherCourseDto buildTeacherCourseDto(ClassHour classHour, List<OrgClassLesson> lessons, String courseName,
        Map<Long, String> roomNameMap, Map<Long, LessonSignAudit> signAuditMap,
        Map<Long, Integer> lessonStudentCountMap) {
        TeacherCourseDto teacherCourseDto = new TeacherCourseDto();
        teacherCourseDto.setCourseId(classHour.getCourseId());
        teacherCourseDto.setCourseName(courseName);
        teacherCourseDto.setMinutes(classHour.getMinutes());
        teacherCourseDto.setLessonCount(classHour.getLessonCount());
        List<OrgTeacherLessonInfoDto> teacherLessons = Lists.newArrayList();
        for (OrgClassLesson lesson : lessons) {
            OrgTeacherLessonInfoDto dto = new OrgTeacherLessonInfoDto();
            dto.setLessonId(lesson.getId());
            dto.setStartTime(lesson.getStartTime());
            dto.setEndTime(lesson.getEndTime());
            dto.setMinutes(DateUtil.getMinuteDiff(lesson.getStartTime(), lesson.getEndTime()));
            dto.setIndex(lesson.getNumber());
            if (roomNameMap != null && lesson.getRoomId() != null) {
                dto.setRoomName(roomNameMap.get(lesson.getRoomId()));
            }
            if (lessonStudentCountMap != null && lessonStudentCountMap.containsKey(lesson.getId())) {
                dto.setStudentCount(lessonStudentCountMap.get(lesson.getId()));
            }
            if (signAuditMap != null && signAuditMap.containsKey(lesson.getId())) {
                LessonSignAudit signAudit = signAuditMap.get(lesson.getId());
                int signCount =
                    signAudit.getSignCount() > dto.getStudentCount() ? dto.getStudentCount() : signAudit.getSignCount();
                int leaveCount = signAudit.getLeaveCount() > dto.getStudentCount() ? dto.getStudentCount()
                    : signAudit.getLeaveCount();
                int absentCount = signAudit.getAbsentCount() > dto.getStudentCount() ? dto.getStudentCount()
                    : signAudit.getAbsentCount();
                int unsignCount = dto.getStudentCount() - signCount - leaveCount - absentCount;
                unsignCount = unsignCount < 0 ? 0 : unsignCount;
                dto.setSignCount(signCount);
                dto.setLeaveCount(leaveCount);
                dto.setAbsentCount(absentCount);
                dto.setUnsignCount(unsignCount);
            }
            teacherLessons.add(dto);
        }
        teacherCourseDto.setLessons(teacherLessons);
        return teacherCourseDto;
    }

    @Override
    public List<TeacherClassHourDto> exportTeacherClassHoursData(Long orgId, TeacherClassHourRequestDto params) {
        Preconditions.checkArgument(orgId != null, "orgId is null!");
        Preconditions.checkArgument(params.getStartTimeDate() != null, "startTime is null!");
        Preconditions.checkArgument(params.getEndTimeDate() != null, "endTime is null!");
        log.info("export teacher classHour List data,orgId={},params={}", orgId, params);
        List<Long> lessonIds = orgClassLessonDao.queryFinishedLessonIds(orgId, params.getTeacherId(),
            params.getStartTimeDate(), params.getEndTimeDate());
        log.debug("lessonIds={}", lessonIds);
        if (CollectionUtils.isEmpty(lessonIds)) {
            return Lists.newArrayList();
        }
        List<ClassHour> classHourList =
            orgClassLessonDao.queryTeacherClassHourList(lessonIds, params.getTeacherId(), null, true);
        Map<Long, List<ClassHour>> classHourMap = CollectorUtil.group(classHourList, new Function<ClassHour, Long>() {
            @Override
            public Long apply(ClassHour arg0) {
                return arg0.getTeacherId();
            }
        });
        List<Teacher> teacherList = this.teacherDao.getByTeacherIds(classHourMap.keySet());
        List<OrgClassLesson> lessons = this.orgClassLessonDao.getByIds(lessonIds);
        Map<Long, Long> lessonTeacherMap = this.orgTeacherLessonDao.queryLessonTeacherIdMap(orgId, lessonIds);
        log.debug("lessonTeacherMap={}", lessonTeacherMap);
        final Set<Long> roomIds = Sets.newHashSet();
        Map<Long, List<OrgClassLesson>> lessonMap = CollectorUtil.group(lessons, new Function<OrgClassLesson, Long>() {
            @Override
            public Long apply(OrgClassLesson arg0) {
                roomIds.add(arg0.getRoomId());
                return arg0.getCourseId();
            }
        });
        Map<Long, String> roomNameMap = orgClassRoomDao.getRoomName(orgId, roomIds);
        List<TeacherClassHourDto> result = Lists.newArrayList();
        Map<Long, String> courseNameMap = this.orgCourseDao.getCourseNameMap(lessonMap.keySet());
        Map<Long, LessonSignAudit> signAuditMap = this.orgLessonSignDao.queryLessonSignAudit(orgId, lessonIds);
        Map<Long, Integer> lessonStudentCountMap = orgStudentLessonDao.queryLessonStudentCountMap(orgId, lessonIds);
        log.debug("signAuditMap={}", signAuditMap);
        log.debug("lessonStudentCountMap={}", lessonStudentCountMap);

        for (Teacher teacher : teacherList) {
            result.add(buildTeacherClassHourDto(teacher, classHourMap.get(teacher.getUserId()), lessonMap,
                courseNameMap, roomNameMap, signAuditMap, lessonStudentCountMap, lessonTeacherMap));
        }
        sortTeacherClassHourDto(result);
        return result;
    }

    /**
     * 老师时长倒序
     * 
     * @param result
     */
    private void sortTeacherClassHourDto(List<TeacherClassHourDto> result) {
        Collections.sort(result, new Comparator<TeacherClassHourDto>() {
            @Override
            public int compare(TeacherClassHourDto o1, TeacherClassHourDto o2) {
                Integer minute1 = 0;
                Integer minute2 = 0;
                if (CollectionUtils.isNotEmpty(o1.getCourses())) {
                    for (TeacherCourseDto teacherCourseDto : o1.getCourses()) {
                        minute1 += teacherCourseDto.getMinutes();
                    }

                }
                if (CollectionUtils.isNotEmpty(o2.getCourses())) {
                    for (TeacherCourseDto teacherCourseDto : o2.getCourses()) {
                        minute2 += teacherCourseDto.getMinutes();
                    }
                }
                return minute2.compareTo(minute1);
            }
        });
    }

    private TeacherClassHourDto buildTeacherClassHourDto(Teacher teacher, List<ClassHour> classHours,
        Map<Long, List<OrgClassLesson>> lessonMap, Map<Long, String> courseNameMap, Map<Long, String> roomNameMap,
        Map<Long, LessonSignAudit> signAuditMap, Map<Long, Integer> lessonStudentCountMap,
        Map<Long, Long> lessonTeacherMap) {
        TeacherClassHourDto teacherClassHourDto = new TeacherClassHourDto();
        teacherClassHourDto.setTeacherId(teacher.getUserId());
        teacherClassHourDto.setTeacherName(teacher.getRealName());
        List<TeacherCourseDto> courses = Lists.newArrayList();
        for (ClassHour classHour : classHours) {
            List<OrgClassLesson> lessons = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty(lessonMap.get(classHour.getCourseId()))) {
                for (OrgClassLesson orgClassLesson : lessonMap.get(classHour.getCourseId())) {
                    if (teacher.getUserId().equals(lessonTeacherMap.get(orgClassLesson.getId()))) {
                        lessons.add(orgClassLesson);
                    }
                }
            }
            courses.add(buildTeacherCourseDto(classHour, lessons, courseNameMap.get(classHour.getCourseId()),
                roomNameMap, signAuditMap, lessonStudentCountMap));
        }
        teacherClassHourDto.setCourses(courses);
        return teacherClassHourDto;
    }

    @Override
    public void export(HttpServletResponse response, Long orgId, Date date, List<TeacherClassHourDto> dtoList) {
        Preconditions.checkArgument(date != null, "日期不能为空");
        Preconditions.checkArgument(orgId != null && orgId > 0, "机构ID不能为空");

        String orgName = orgInfoDao.getOrgShortNameByOrgId(orgId.intValue());
        String timeStr = TianXiaoConstant.MONTH_FORMAT.format(date);
        String fileName = orgName + "-课时统计-" + timeStr + ".xlsx";

        Workbook workbook = null;
        try {
            workbook = new SXSSFWorkbook(100);
            Map<String, CellStyle> cellStyleMap = new HashMap<>();
            List<ExportField> summaryFields = Lists.newArrayList();
            summaryFields.add(new ExportField("老师名称", "@", 20 * 256));
            summaryFields.add(new ExportField("班级名称", "@", 40 * 256));
            summaryFields.add(new ExportField("课节数", "0", 10 * 256, 0));
            summaryFields.add(new ExportField("总时长(分钟)", "0", 20 * 256, 0));
            summaryFields.add(new ExportField("应到人数", "0", 20 * 256, 0));
            summaryFields.add(new ExportField("签到人数", "0", 20 * 256, 0));
            summaryFields.add(new ExportField("请假人数", "0", 20 * 256, 0));
            summaryFields.add(new ExportField("缺勤人数", "0", 20 * 256, 0));
            summaryFields.add(new ExportField("单课课酬（元／节）", "0.0", 20 * 256, 0));
            summaryFields.add(new ExportField("课酬总金额", "0.0", 20 * 256, 0));
            summaryFields.add(new ExportField("每小时课酬（元／小时）", "0.0", 20 * 256, 0));
            summaryFields.add(new ExportField("课酬总金额", "0.0", 20 * 256, 0));
            summaryFields.add(new ExportField("单人报酬（元／人次）", "0.0", 20 * 256, 0));
            summaryFields.add(new ExportField("课酬总金额", "0.0", 20 * 256, 0));
            summaryFields.add(new ExportField("应结总额", "0.0", 20 * 256, 0));
            List<Map<String,Object>> titles = Lists.newArrayList();
            Map<String,Object> title1 = Maps.newHashMap();
            title1.put("row", 0);
            title1.put("titleName", "(课消汇总表)");
            title1.put("startCell",0);
            title1.put("endCell",summaryFields.size()-1);
            titles.add(title1);
            
            Map<String,Object> title2 = Maps.newHashMap();
            title2.put("row", 1);
            title2.put("titleName", "(填写单课节课酬,自动计算应结总课酬)");
            title2.put("startCell",0);
            title2.put("endCell",7);
            titles.add(title2);
            
            Map<String,Object> title3 = Maps.newHashMap();
            title3.put("row", 1);
            title3.put("titleName", "(按课次计算)");
            title3.put("startCell",8);
            title3.put("endCell",9);
            titles.add(title3);
            
            Map<String,Object> title4 = Maps.newHashMap();
            title4.put("row", 1);
            title4.put("titleName", "(按时长计算)");
            title4.put("startCell",10);
            title4.put("endCell",11);
            titles.add(title4);
            
            Map<String,Object> title5 = Maps.newHashMap();
            title5.put("row", 1);
            title5.put("titleName", "(按学员计算)");
            title5.put("startCell",12);
            title5.put("endCell",13);
            titles.add(title5);

            List<ExportField> detailFields = Lists.newArrayList();
            detailFields.add(new ExportField("老师名称", "@", 20 * 256));
            detailFields.add(new ExportField("班级名称", "@", 50 * 256));
            detailFields.add(new ExportField("课节", "@", 10 * 256));
            detailFields.add(new ExportField("教室", "@", 30 * 256));
            detailFields.add(new ExportField("日期", "yyyy-MM-dd", 20 * 256));
            detailFields.add(new ExportField("上课时间", "@", 50 * 256));
            detailFields.add(new ExportField("时长(分钟)", "0", 20 * 256));
            detailFields.add(new ExportField("安排学员", "0", 20 * 256));
            detailFields.add(new ExportField("签到人数", "0", 20 * 256));
            detailFields.add(new ExportField("请假人数", "0", 20 * 256));
            detailFields.add(new ExportField("旷课人数", "0", 20 * 256));
            detailFields.add(new ExportField("未签到人数", "0", 20 * 256));
            detailFields.add(new ExportField("签到率", "@", 20 * 256));

            ExcelExportService.createSheet(workbook, "汇总", titles, cellStyleMap, summaryFields, dtoList, false);
            ExcelExportService.createSheet(workbook, "老师详情", null, cellStyleMap, detailFields, dtoList, true);

            ExcelExportService.exportExcel(response, workbook, fileName);
        } catch (Exception e) {
            log.error("export catch exception:", e);
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "导出数据处理异常");
        } finally {
            try {
                workbook.close();
            } catch (IOException e) {
                log.error("close workbook catch error:", e);
            }
        }

    }

    public static void main(String[] args) throws IOException {

       // String json = FileUtils.readFileToString(new File("/Users/wengshengli/Downloads/response1.json"));

      //  List<TeacherClassHourDto> dtoList = JacksonUtil.str2List(json, TeacherClassHourDto.class);
        List<TeacherClassHourDto> dtoList = Lists.newArrayList();
        String timeStr = TianXiaoConstant.MONTH_FORMAT.format(new Date());
        Workbook workbook = null;
        
            workbook = new SXSSFWorkbook(100);
            Map<String, CellStyle> cellStyleMap = new HashMap<>();
            List<ExportField> summaryFields = Lists.newArrayList();
            summaryFields.add(new ExportField("老师名称", "@", 20 * 256));
            summaryFields.add(new ExportField("班级名称", "@", 40 * 256));
            summaryFields.add(new ExportField("课节数", "0", 10 * 256, 0));
            summaryFields.add(new ExportField("总时长(分钟)", "0", 20 * 256, 0));
            summaryFields.add(new ExportField("应到人数", "0", 20 * 256, 0));
            summaryFields.add(new ExportField("签到人数", "0", 20 * 256, 0));
            summaryFields.add(new ExportField("请假人数", "0", 20 * 256, 0));
            summaryFields.add(new ExportField("缺勤人数", "0", 20 * 256, 0));
            summaryFields.add(new ExportField("单课课酬（元／节）", "0.0", 20 * 256, 0));
            summaryFields.add(new ExportField("课酬总金额", "0.0", 20 * 256, 0));
            summaryFields.add(new ExportField("每小时课酬（元／小时）", "0.0", 20 * 256, 0));
            summaryFields.add(new ExportField("课酬总金额", "0.0", 20 * 256, 0));
            summaryFields.add(new ExportField("单人报酬（元／人次）", "0.0", 20 * 256, 0));
            summaryFields.add(new ExportField("课酬总金额", "0.0", 20 * 256, 0));
            summaryFields.add(new ExportField("应结总额", "0.0", 20 * 256, 0));
            List<Map<String,Object>> titles = Lists.newArrayList();
            Map<String,Object> title1 = Maps.newHashMap();
            title1.put("row", 0);
            title1.put("titleName", timeStr + "课消汇总表");
            title1.put("startCell",0);
            title1.put("endCell",summaryFields.size()-1);
            titles.add(title1);
            
            Map<String,Object> title2 = Maps.newHashMap();
            title2.put("row", 1);
            title2.put("titleName", "(填写单课节课酬,自动计算应结总课酬)");
            title2.put("startCell",0);
            title2.put("endCell",7);
            titles.add(title2);
            
            Map<String,Object> title3 = Maps.newHashMap();
            title3.put("row", 1);
            title3.put("titleName", "(按课次计算)");
            title3.put("startCell",8);
            title3.put("endCell",9);
            titles.add(title3);
            
            Map<String,Object> title4 = Maps.newHashMap();
            title4.put("row", 1);
            title4.put("titleName", "(按时长计算)");
            title4.put("startCell",10);
            title4.put("endCell",11);
            titles.add(title4);
            
            Map<String,Object> title5 = Maps.newHashMap();
            title5.put("row", 1);
            title5.put("titleName", "(按学员计算)");
            title5.put("startCell",12);
            title5.put("endCell",13);
            titles.add(title5);

            List<ExportField> detailFields = Lists.newArrayList();
            detailFields.add(new ExportField("老师名称", "@", 20 * 256));
            detailFields.add(new ExportField("班级名称", "@", 50 * 256));
            detailFields.add(new ExportField("课节", "@", 10 * 256));
            detailFields.add(new ExportField("教室", "@", 30 * 256));
            detailFields.add(new ExportField("日期", "yyyy-MM-dd", 20 * 256));
            detailFields.add(new ExportField("上课时间", "@", 50 * 256));
            detailFields.add(new ExportField("时长(分钟)", "0", 20 * 256));
            detailFields.add(new ExportField("安排学员", "0", 20 * 256));
            detailFields.add(new ExportField("签到人数", "0", 20 * 256));
            detailFields.add(new ExportField("请假人数", "0", 20 * 256));
            detailFields.add(new ExportField("旷课人数", "0", 20 * 256));
            detailFields.add(new ExportField("未签到人数", "0", 20 * 256));
            detailFields.add(new ExportField("签到率", "@", 20 * 256));

            ExcelExportService.createSheet(workbook, "汇总", titles, cellStyleMap, summaryFields, dtoList, false);
        File excelFile = new File("/Users/bjhl/Documents/testclass.xlsx");
        workbook.write(new FileOutputStream(excelFile));
    }

}
