
package com.baijia.tianxiao.sal.course.service;

import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.sal.course.dto.response.LessonSignReportDto;
import com.baijia.tianxiao.sal.course.dto.response.OrgStudentLessonSignDto;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * 签到
 *
 * @author shizuwei
 * @version 1.0
 * @title OrgLessonSignService
 * @desc TODO
 * @date 2016年1月3日
 * @see com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao
 */
public interface OrgLessonSignService {

    /**
     * 学生批量签到
     *
     * @param orgId
     * @param courseId
     * @param lessonId
     * @param studentIds
     * @return
     */
    void orgStudentLessonBatchSign(Long orgId, Long courseId, Long lessonId, List<Long> studentIds, Integer status);

    /**
     * 多课节并集学员签到
     * 
     * @param orgId
     * @param courseId
     * @param lessonIds
     * @param studentIds
     * @param status
     */
    void orgUnionStudentsMultiLessonBatchSign(Long orgId, Long courseId, List<Long> lessonIds, List<Long> studentIds, Integer status);

    public void orgStudentLessonBatchFastSign(Long orgId, Long courseId, List<Long> lessonIds, Map<Long,Integer> studentIdSignInStatus );
    /**
     * 单个学生签到
     *
     * @param orgId
     * @param courseId
     * @param lessonId
     * @param studentId
     * @param status
     */
    void orgStudentLessonSign(Long orgId, Long courseId, Long lessonId, Long studentId, Integer status);

    /**
     * 单个学生的签到情况
     *
     * @param orgId
     * @param courseId
     * @param lessonId
     * @param studentId
     * @return
     */
    OrgStudentLessonSignDto getStudentLessonSign(Long orgId, Long courseId, Long lessonId, Long studentId);

    /**
     * 获取课节学员签到数量
     *
     * @param orgId
     * @param lessonIds
     * @param userIdMap userId:studentId map
     * @return
     */
    Map<Long, Integer> getLessonStudentSignCount(Long orgId, Collection<Long> lessonIds, Map<Long, Long> userIdMap);

    /**
     * 获取课节学员签到情况
     *
     * @param orgId
     * @param lessonIds
     * @param userIdMap userId:studentId map
     * @return
     */
    public Map<String, Map<String, Integer>> getLessonStudentSign(Long orgId, Collection<Long> lessonIds,
                                                                  Map<Long, Long> userIdMap);

    /**
     * 获取签到报表
     * @return
     */
    LessonSignReportDto getLessonSignReport(Long orgId, Long studentId);

    /**
     * 获取课程出勤率
     */

    public Map<Long, Double> getAttendanceRateOfCourses(Long orgId, Collection<Long> courseIds);

    /**
     * 获取学生出勤率
     */
    public Map<Long, Double> getAttendanceRateOfStudents(Long orgId, Collection<Long> studentIds);


    Map<String, Map<String, Integer>> getLessonStudentSignReport(Long orgId, Collection<Long> lessonIds,
                                                                 Map<Long, Long> userIdMap, Long courseId);


    List<Long> getStudentBySignStatus(Long orgId, Long lessonId);
    
    public void signSendMsg(OrgInfo orgInfo, OrgStudent student, Teacher teacher, OrgClassLesson lesson, OrgCourse course, Integer status);
    
}
