
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.course.dto.response;

import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import lombok.Data;

/**
 * @title OrgLessonInfoDto
 * @desc TODO
 * @author shanyu
 * @date 2016年3月30日
 * @version 1.0
 */
@Data
public class OrgTeacherLessonInfoDto {

    private static String LESSON_NUMBER_FORMAT = "第%d节";

    private Long lessonId;

    private Long courseId;

    private String roomName; // 教室名

    private int studentCount; // 学员数

    private int signCount; // 签到学员数

    private int leaveCount; // 请假学员数

    private int absentCount; // 旷课学员数

    private int unsignCount; // 为签到学员数

    private Date startTime; // 开始时间

    private Date endTime; // 结束时间

    private Integer index;

    private int minutes; // 时长

    public String getLessonNumberInfo() {
        return String.format(LESSON_NUMBER_FORMAT, index);
    }

    public String getLessonTime() {
        Preconditions.checkArgument(startTime != null, "lesson start time can not be null");
        Preconditions.checkArgument(endTime != null, "lesson end time can not be null");

        String startTimeStr = TianXiaoConstant.TIME_MINUTE_FORMAT.format(this.startTime);
        String endTimeStr = TianXiaoConstant.TIME_MINUTE_FORMAT.format(this.endTime);

        return startTimeStr + "-" + endTimeStr;
    }

    public String getSignRate() {
        if (studentCount == 0) {
            return "0%";
        }
        String rate = new BigDecimal(this.studentCount - this.unsignCount).multiply(new BigDecimal(100))
            .divide(new BigDecimal(this.studentCount), 2, RoundingMode.HALF_UP).toString();
        return rate + "%";
    }

}
