/**
 * 
 */
package com.baijia.tianxiao.sal.course.dto;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

import lombok.extern.slf4j.Slf4j;

import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.sal.course.service.impl.OrgLessonSignServiceImpl;

/**
 * @author leiruiqi
 *
 */

@Slf4j
public class SigninMsgAsynModel {

	private static LinkedList<Map<String,OrgLessonSign>> signinMsgAsynList = new LinkedList<Map<String,OrgLessonSign>>();;
	
	static {
		signinMsgAsynList.addFirst(new HashMap<String,OrgLessonSign>());
		signinMsgAsynList.addLast(new HashMap<String,OrgLessonSign>());
	}
	public static void addNewLessonSignIn(Map<String,OrgLessonSign> newSignin){
		int size = signinMsgAsynList.size();
		
		if(size<2){
			log.error("signinMsgAsynList size error,size="+size);
			throw new RuntimeException("signinMsgAsynList.size() error");
		}
		
		signinMsgAsynList.getLast().putAll(newSignin);
		Set<String> keys = newSignin.keySet();
		
		for(String key:keys){
			if(signinMsgAsynList.getFirst().containsKey(key)){
				signinMsgAsynList.getFirst().remove(key);
			}
			
		}
		log.info("add new singin succese ,siginInfo ={}",newSignin);
		
	}
	
	public static synchronized Map<String,OrgLessonSign> getOldAndResetNew(){
		signinMsgAsynList.add(new HashMap<String,OrgLessonSign>());
		Map<String,OrgLessonSign> readySendSignInMap = signinMsgAsynList.removeFirst();
		return readySendSignInMap;
	}
}
