
package com.baijia.tianxiao.sal.course.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.sal.course.dto.response.*;
import lombok.NonNull;

import com.baijia.tianxiao.dto.PersonBaseDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;


/**
 * 课程学生相关操作，主要用于ERP排课
 * 
 * @title CourseStudentService
 * @desc TODO
 * @author shizuwei
 * @date 2016年1月18日
 * @version 1.0
 */
public interface CourseStudentService {
    
    /**
     * 获取同一个课程内多课节的并集学生
     *
     * @param orgId
     * @param courseId
     * @param lessonIds
     * @return
     */
    MultiLessonsUnionStudentsResponse multiLessonUnionStudents(Long orgId, Long courseId, List<Long> lessonIds);

    /**
     * crm学员删除后调用此接口，其功能为，找出学员所有的班级，并且依次调用退班接口 deleteOrgCourseStudent
     * 
     * @param orgId
     * @param studentId
     */
    public void deleteOrgCourseStudentForDelStudent(Long orgId,Long studentId);
    /**
     * 学生退班 1.从课程中删除：不改变删除标记，只是更改status字段为退班状态。 2.涉及到选座位的删除学生座位关联关系。(为了和PC兼容)
     * 3.从删除学生的未上完课节(课节和学生关联表操作)4.更新tts.org_course_student_op表，记录退班操作记录和退班原因。
     * 
     * @param orgId 机构ID
     * @param courseId 课程ID
     * @param studentId 学生ID org_students表主键
     * @param cause 退班原因
     */
    void deleteOrgCourseStudent(Long orgId, Long courseId, Long studentId, String cause);

    /**
     * 学生转班，只包含转出逻辑，不包含转入逻辑。 1.从课程中删除：不改变删除标记，只是更改status字段为转班状态。 2.涉及到选座位的删除学生座位关联关系。(为了和PC兼容)
     * 3.从删除学生的未上完课节(课节和学生关联表操作)4.更新tts.org_course_student_op表，记录转班操作记录和转班原因。
     * 
     * @param orgId 机构ID
     * @param courseId 课程ID
     * @param studentId 学生ID org_students表主键
     * @param cause 转班原因
     */
    void transferOrgCourseStudent(Long orgId, Long studentId, Long fromCourseId, Long toCourseId, String cause);

    /**
     * 课程学生列表 1.返回班级中的学生列表（包含学生头像url），不包含已经退班和转班的学生。
     * 
     * @param orgId
     * @param courseId
     * @return
     */
    List<StudentResponseDto> getOrgCourseStudentList(Long orgId, Long courseId);
    /**
     * 课程学生列表 1.返回班级中的学生列表（包含学生头像url），不包含已经退班和转班的学生。关键字查询
     * 
     * @param orgId
     * @param courseId
     * @param key
     * @return
     */
    List<StudentResponseDto> getOrgCourseStudentList(Long orgId, Long courseId, String key);
    
    /**
     * 查看课节的学生，并集
     * 
     * @param orgId
     * @param courseId
     * @param lessonIds
     * @return
     */
        
    public List<StudentResponseDto> getLessonsStudentList(@NonNull Long orgId, @NonNull Long courseId,@NonNull List<Long> lessonIds);

    /**
     * 返回机构学生列表，对于选了本课程的进行剔除
     * 
     * @param orgId
     * @param courseId 当前课程ID,非必填项
     * @param key
     * @param page
     * @return
     */
    List<OrgStudentsChooseListDto> getStudentChooseList(Long orgId, Long courseId, String key, PageDto page);

    /**
     * 返回机构学生列表，对于选了本课程的进行标记
     *
     * @param orgId
     * @param courseId 当前课程ID,非必填项
     * @param key
     * @param page
     * @return
     */
    List<OrgStudentsChooseListDto> getAllStudentChooseList(Long orgId, Long courseId, String key, PageDto page);


    /**
     * 返回班级学生详情页
     * 
     * @param orgId
     * @param courseId
     * @param studentId
     * @return
     */
    CourseStudentDetailDto getCourseStudentDetail(Long orgId, Long courseId, Long studentId);

    /**
     * 查询学生所有课节的ids
     * 
     * @param orgId
     * @param studentId
     * @return
     */
    List<Long> getStudentLessonIds(Long orgId, Long studentId);

    /**
     * 查询课节学生 课节的学生列表，包含签到信息，按时间排序。
     * 
     * @author cxm
     * @param orgId
     * @param lessonId
     * @return
     */
    List<OrgStudentsChooseListDto> getLessonStudent(Long orgId, Long lessonId, boolean needSignStatus);

    /**
     * 添加学生到课节
     * 
     * @author cxm
     * @param orgId
     * @param courseId
     * @param lessonId
     * @param studentIds
     * @param isStudentId
     */
    void addStudentToLesson(Long orgId, Long courseId, Long lessonId, Collection<Long> studentIds, boolean isStudentId);

    
    
    /**
     * 重置课节中的学生.在编辑课节中适用
     * 
     * @author cxm
     * @param orgId
     * @param courseId
     * @param lessonId
     * @param studentIds
     * @param isStudentId
     */
    void resetLessonStudent(Long orgId, Long courseId, Long lessonId, Collection<Long> studentIds);

    /**
     * 删除课节中的学生,如果没指定学生的userId则删除全部学生
     * 
     * @author cxm
     * @param orgId
     * @param lessonId
     * @param userIds
     * @return
     */
    int deleteStudentFromLesson(Long orgId, Long lessonId, Collection<Long> userIds);
    
  
    /**
     * 获取课程学员id
     * 
     * @param orgId
     * @param courseId
     * @return
     */
    List<Long> getCourseStudentUserIdsByOrgIdCourseId(Long orgId, Long courseId);

    /**
     * 返回学生姓名和头像URL
     * 
     * @param orgId
     * @param studentId
     * @return
     */
    Map<String, String> getStudentNameAndAvatar(Long orgId, Long studentId);

    /**
     * 返回机构学生的签到数目，课程数目，今日课节数目
     * 
     * @param orgId
     * @param studentId
     * @return
     */
    Map<String, Integer> getStudentCourseLessonInfo(Long orgId, Long studentId);

    /**
     * 从课节删除学生，对于已经签到和评论的不允许删除
     * 
     * @param orgId
     * @param lessonId
     * @param studentId
     * @return
     */
    int delLessonStudent(Long orgId, Long lessonId, Long studentId);

    /**
     * 获取课程的学生数目
     * @param orgId
     * @param courseIds
     * @param tradeComplete
     * @return
     */
    Map<Long, Integer> getCourseStudentCntMap(Long orgId, Collection<Long> courseIds, Boolean tradeComplete);

    /**
     * 获取班级学员列表(PC-ERP排课，包含学员课节情况)
     * @param orgId
     * @param courseId
     * @return
     */
    List<CourseStudentSumDto> getCourseStudents(Long orgId, Long courseId, PageDto pageDto);
    
    /**
     * 获取班级学员基本信息列表(pc-erp排课)
     * @param orgId
     * @param courseId
     * @return
     */
    List<PersonBaseDto> getCourseStudentsBase(Long orgId, Long courseId);
    
    /**
     * 获取不在某个课节的班级学员列表(pc-erp排课)
     * @param orgId
     * @param lessonId
     * @return
     */
    List<PersonBaseDto> getCourseStudentsNotInLesson(Long orgId, Long lessonId);

}
