
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.course.enums;

import com.baijia.tianxiao.constant.SignStatus;

import java.util.List;

/**
 * @title CourseConsumeRuleEnum
 * @desc TODO 
 * @author leiruiqi
 * @date 2016年8月24日
 * @version 1.0
 */

public enum CourseConsumeRuleEnum {

    TIME_0(0,"课节开课自动算课消"),
    SIGNIN_1(1,"到课算课消"),
    SIGNIN_3(3,"到课、请假算课消"),
    SIGNIN_5(5,"到课、缺课算课消"),
    SIGNIN_7(7,"到课、请假、缺课算课消"),
    ;
    private Integer value;
    private String desc;
    
    public Integer getValue() {
    
        return value;
    }


    public String getDesc() {
    
        return desc;
    }


    private CourseConsumeRuleEnum(Integer value,String desc) {

        this.value = value;
        this.desc = desc;
    }
    
    public static String getRuleDescByValue(Integer ruleValue){
        if(ruleValue==null){
            return "课节开课自动算课消";
        }
        for(CourseConsumeRuleEnum rule:CourseConsumeRuleEnum.values()){
            if(rule.getValue().intValue() == ruleValue){
                return rule.getDesc();
            }
        }
        return null;
    }

    public static CourseConsumeRuleEnum getRuleByValue(Integer ruleValue){
        if(ruleValue==null){
            return null;
        }
        for(CourseConsumeRuleEnum rule:CourseConsumeRuleEnum.values()){
            if(rule.getValue().intValue() == ruleValue){
                return rule;
            }
        }
        return null;
    }

    public static boolean checkRuleValueEffect(Integer ruleValue){
        if(ruleValue==null){
            return false;
        }
        for(CourseConsumeRuleEnum rule:CourseConsumeRuleEnum.values()){
            if(rule.getValue().intValue() == ruleValue){
                return true;
            }
        }
        return false;
    }
    
    public static boolean signStatusEnumIsConsume(Integer consumsRuleValue,SignStatus signStatus){
        if(consumsRuleValue == null||consumsRuleValue==0){
            return true;
        }
        if(signStatus ==null){
            return false;
        }else if(signStatus==SignStatus.UNSIGN){
            return false;
        }
        else if(signStatus==SignStatus.SIGNED){
            return true;
        }else if(signStatus==SignStatus.LEAVE){
            return (2|consumsRuleValue)==consumsRuleValue;
        }else if(signStatus==SignStatus.ABSENT){
            return (4|consumsRuleValue)==consumsRuleValue;
        }
        return false;
    }
    
    public static boolean signStatusCodeIsConsume(Integer consumsRuleValue,Integer signCode){
        if(signCode == null) {
            return signStatusEnumIsConsume(consumsRuleValue,null);
        }
        if(signCode<0){
            return false;
        }
        
        SignStatus signStatus = SignStatus.getSignStatusByCode(signCode);
        return signStatusEnumIsConsume(consumsRuleValue,signStatus);
    }
    
    public static int calculateConsumeTimesBySignCodeList(Integer consumsRuleValue,List<Integer> signCodeList){
        if(consumsRuleValue == null||consumsRuleValue==0){
            throw new RuntimeException();
        }
        int count = 0;
        for(Integer code:signCodeList){
            
            boolean bool = signStatusCodeIsConsume(consumsRuleValue,code);
            if(bool){
                count++;
            }
        }
        return count;
    }
}

    