
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.course.dto;

import com.baijia.tianxiao.dal.org.po.OrgInfo;

import java.util.Map;

import lombok.Data;

/**
 * @title MsgSendResult
 * @desc TODO 
 * @author leiruiqi
 * @date 2016年9月2日
 * @version 1.0
 */
@Data
public class MsgSendResult {

    private String orgName;
    private Integer orgId;
    
    private Integer lessonCount = 0;
    
    private Integer lessonStudentCount = 0;
    
    
    private Integer failLessonCount = 0;
    
    private Integer failStudentCount = 0;
    
    private Integer failLessonCountByDelCourse = 0;
    
    private Integer failLessonStudentCountByDelCourse = 0;
    
    private Integer failLessonCountByRule = 0;
    
    private Integer failLessonStudentCountByRule = 0;
    
    private Integer failLessonStudentByDelStu = 0;
    
    private Integer failLessonStudentBySend = 0;
    
    public static ThreadLocal<Map<Integer,MsgSendResult>> lessonSyncResult = new ThreadLocal<Map<Integer,MsgSendResult>>();
    
    public static void addLessonCount(OrgInfo orgInfo,int addLessonCount,int addStudentCount){
        Integer orgId = orgInfo.getOrgId();
        
        MsgSendResult tempOrgResult = lessonSyncResult.get().get(orgId);
        if(tempOrgResult == null){
            tempOrgResult = new MsgSendResult();
            tempOrgResult.setOrgId(orgId);
            tempOrgResult.setOrgName(orgInfo.getName());
            lessonSyncResult.get().put(orgId, tempOrgResult);
        }
        tempOrgResult.addLessonCount(addLessonCount);
        tempOrgResult.addLessonStudentCount(addStudentCount);
    }
    
   
    
    public static void addFailDelCourse(OrgInfo orgInfo,int addFaillesson,int addFailStudent){
        MsgSendResult tempOrgResult = lessonSyncResult.get().get(orgInfo.getOrgId());
        tempOrgResult.addFailDelCourse(addFaillesson, addFailStudent);
        
    }
    
    public static void addFailRule(OrgInfo orgInfo,int addFaillesson,int addFailStudent){
        MsgSendResult tempOrgResult = lessonSyncResult.get().get(orgInfo.getOrgId());
        tempOrgResult.addFailRule(addFaillesson, addFailStudent);
        
    }
    
    public static void addFailDelStudent(OrgInfo orgInfo,int addFailStudent){
        MsgSendResult tempOrgResult = lessonSyncResult.get().get(orgInfo.getOrgId());
        tempOrgResult.addFailDelStudent(addFailStudent);
       
    }
    
    public static void addFailSend(OrgInfo orgInfo,int addFailStudent){
        MsgSendResult tempOrgResult = lessonSyncResult.get().get(orgInfo.getOrgId());
        tempOrgResult.addFailSend(addFailStudent);
    }
    
    public void addLessonCount(int addCount){
        this.lessonCount+=addCount;
    }
    
    public void addLessonStudentCount(int addCount){
        lessonStudentCount += addCount;
    }
    
    public void addFailDelCourse(int addFaillesson,int addFailStudent){
        failLessonCountByDelCourse+=addFaillesson;
        failLessonCount+=addFaillesson;
        failLessonStudentCountByDelCourse+=addFailStudent;
        failStudentCount+=addFailStudent;
        
    }
    
    public void addFailRule(int addFaillesson,int addFailStudent){
        failLessonCountByRule+=addFaillesson;
        failLessonCount+=addFaillesson;
        failLessonStudentCountByRule+=addFailStudent;
        failStudentCount+=addFailStudent;
    }
    
    public void addFailDelStudent(int addFailStudent){
        failLessonStudentByDelStu+=addFailStudent;
        failStudentCount+=addFailStudent;
    }
    
    public void addFailSend(int addFailStudent){
        failLessonStudentBySend+=addFailStudent;
        failStudentCount+=addFailStudent;
    }
}

    