package com.baijia.tianxiao.sal.course.constant;
/**
 * 授课方式
 * 
 * @title LessonWay
 * @desc TODO
 * @author zhangbing
 * @date 2014年12月16日
 * @version 1.0
 */
public enum LessonWay {

    // OTO：一对一授课方式
    DISCUSS(1, "协商地点"),

    ONLINE(2, "在线授课"),

    // 机构线下课、学生上门
    STU_ACTIVE(4, "学生上门"),

    TEA_ACTIVE(8, "老师上门"),

    OTHER(12, "其他");

    private Integer value;

    private String label;

    private LessonWay(Integer value, String label) {
        this.value = value;
        this.label = label;
    }

    public Integer getValue() {
        return value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public static LessonWay get(Integer value) {
        return LessonWay.values()[Integer.bitCount(value - 1)];
    }
}
