/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.course.service.impl;

import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseRoomDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseSeatDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseSmsDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseStudentOpDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonCommentDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseSeat;
import com.baijia.tianxiao.dal.org.po.OrgCourseStudentOp;
import com.baijia.tianxiao.dal.org.po.OrgLessonComment;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dal.user.dao.StudentDao;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.po.Student;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoMContext;
import com.baijia.tianxiao.sal.course.dto.response.ClassLessonInfoDto;
import com.baijia.tianxiao.sal.course.dto.response.CourseStudentDetailDto;
import com.baijia.tianxiao.sal.course.dto.response.OrgStudentsChooseListDto;
import com.baijia.tianxiao.sal.course.dto.response.StudentResponseDto;
import com.baijia.tianxiao.sal.course.service.CourseStudentService;
import com.baijia.tianxiao.sal.course.util.StudentNameUtil;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CourseStudentServiceImpl
implements CourseStudentService {
    private static final Logger log = LoggerFactory.getLogger(CourseStudentServiceImpl.class);
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Resource
    private TeacherDao teacherDao;
    @Resource
    private CoursePurchaseDao coursePurchaseDao;
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgCourseSeatDao orgCourseSeatDao;
    @Resource
    private OrgClassLessonDao orgClassLessonDao;
    @Resource
    private OrgCourseRoomDao orgCourseRoomDao;
    @Resource
    private OrgCourseSmsDao orgCourseSmsDao;
    @Resource
    private StorageDao storageDao;
    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;
    @Resource
    private OrgCourseStudentOpDao orgCourseStudentOpDao;
    @Resource
    private StudentDao studentDao;
    @Resource
    private OrgLessonSignDao orgLessonSignDao;
    @Resource
    private OrgLessonCommentDao orgLessonCommentDao;
    @Autowired
    private TxCascadeCredentialService txCascadeCredentialService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteOrgCourseStudent(Long orgId, Long courseId, Long studentId, String cause) throws BussinessException {
        log.debug("\u5220\u9664 orgId = {}, courseId = {}, studentId = {} cause = {} ", new Object[]{orgId, courseId, studentId, cause});
        Long userId = this.orgStudentDao.getUserId(studentId);
        if (userId == null) {
            log.error("userId == null, studentId = {}", (Object)studentId);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        this.orgStudentCourseDao.deleteOrgCourseStudent(orgId, courseId, userId, Integer.valueOf(1));
        OrgCourseSeat seat = this.orgCourseSeatDao.getCourseSeat(courseId, userId);
        if (seat != null) {
            this.orgCourseSeatDao.delById((Serializable)seat.getId());
        }
        this.deleteStudentFromCourseLesson(orgId, courseId, userId);
        this.orgCourseSmsDao.delCourseSmsRecord(orgId, courseId, Integer.valueOf(UserRole.STUDENT.getRole()), (Collection)Lists.newArrayList((Object[])new Long[]{userId}));
        OrgCourseStudentOp orgCourseStudentStatus = new OrgCourseStudentOp();
        orgCourseStudentStatus.setCause(cause);
        orgCourseStudentStatus.setFromCourseId(courseId);
        orgCourseStudentStatus.setStatus(Integer.valueOf(1));
        orgCourseStudentStatus.setStudentId(studentId);
        orgCourseStudentStatus.setOrgId(orgId);
        this.orgCourseStudentOpDao.save((Object)orgCourseStudentStatus, new String[0]);
    }

    @Override
    public Map<Long, Integer> getCourseStudentCntMap(Long orgId, Collection<Long> courseIds, Boolean tradeComplete) {
        return this.orgStudentCourseDao.getStudentCount(orgId, courseIds, tradeComplete);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void transferOrgCourseStudent(Long orgId, Long studentId, Long fromCourseId, Long toCourseId, String cause) throws BussinessException {
        log.debug("course student transfer orgId = {}, from = {}, to = {}, \u00e5studentId = {} cause = {} ", new Object[]{orgId, fromCourseId, toCourseId, studentId, cause});
        Long userId = this.orgStudentDao.getUserId(studentId);
        if (userId == null) {
            log.error("userId == null, studentId = {}", (Object)studentId);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        this.orgStudentCourseDao.deleteOrgCourseStudent(orgId, fromCourseId, userId, Integer.valueOf(2));
        OrgCourseSeat seat = this.orgCourseSeatDao.getCourseSeat(fromCourseId, userId);
        if (seat != null) {
            this.orgCourseSeatDao.delById((Serializable)seat.getId());
        }
        this.deleteStudentFromCourseLesson(orgId, fromCourseId, userId);
        this.orgCourseSmsDao.delCourseSmsRecord(orgId, fromCourseId, Integer.valueOf(UserRole.STUDENT.getRole()), (Collection)Lists.newArrayList((Object[])new Long[]{userId}));
        OrgCourseStudentOp orgCourseStudentStatus = new OrgCourseStudentOp();
        orgCourseStudentStatus.setCause(cause);
        orgCourseStudentStatus.setFromCourseId(fromCourseId);
        orgCourseStudentStatus.setToCourseId(toCourseId);
        orgCourseStudentStatus.setStatus(Integer.valueOf(2));
        orgCourseStudentStatus.setStudentId(studentId);
        orgCourseStudentStatus.setOrgId(orgId);
        this.orgCourseStudentOpDao.save((Object)orgCourseStudentStatus, new String[0]);
    }

    private Map<Long, String> getOrgStudentAvatarUrlMap(Collection<Long> usrIds) {
        HashMap map = Maps.newHashMap();
        if (CollectionUtils.isEmpty(usrIds)) {
            return map;
        }
        List students = this.studentDao.getByUserIds(usrIds, new String[]{"userId", "avatar"});
        HashMap userIdStorageIdMap = Maps.newHashMap();
        HashSet avatarIds = Sets.newHashSet();
        for (Student student : students) {
            if (student.getAvatar() != null) {
                avatarIds.add(student.getAvatar());
            }
            userIdStorageIdMap.put(student.getUserId(), student.getAvatar());
        }
        HashMap storageIdUrlMap = Maps.newHashMap();
        List storages = this.storageDao.getByIds((Collection)avatarIds, new String[0]);
        for (Storage storage : storages) {
            storageIdUrlMap.put(storage.getId(), StorageUtil.constructUrl((Long)storage.getFid(), (String)storage.getMimetype(), (String)storage.getSn()));
        }
        for (Student student : students) {
            if (student.getAvatar() == null) continue;
            map.put(student.getUserId(), storageIdUrlMap.get(((Integer)userIdStorageIdMap.get(student.getUserId())).longValue()));
        }
        return map;
    }

    @Override
    @Transactional(readOnly=true)
    public List<StudentResponseDto> getOrgCourseStudentList(@NonNull Long orgId, @NonNull Long courseId) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (courseId == null) {
            throw new NullPointerException("courseId");
        }
        List courseStudents = this.orgStudentCourseDao.getStudentListByCourseId(orgId, courseId, new String[0]);
        HashMap map = Maps.newHashMap();
        HashSet userIds = Sets.newHashSet();
        for (OrgStudentCourse orgStudentCourse : courseStudents) {
            if (orgStudentCourse.getStatus() != 0) continue;
            userIds.add(orgStudentCourse.getUserId());
            map.put(orgStudentCourse.getUserId(), orgStudentCourse);
        }
        List orgStudents = this.orgStudentDao.getStudentByUserIds(orgId, (Collection)userIds, new String[0]);
        Map<Long, String> studentUrlMap = this.getOrgStudentAvatarUrlMap(userIds);
        boolean isShow = this.txCascadeCredentialService.isShowMobile(orgId, TianxiaoMContext.getTXCascadeId());
        ArrayList orgStudentCourseResponseDtos = Lists.newArrayList();
        for (OrgStudent orgStudent : orgStudents) {
            StudentResponseDto studentResponseDto = new StudentResponseDto();
            studentResponseDto.setStatus(((OrgStudentCourse)map.get(orgStudent.getUserId())).getStatus());
            this.buildStudentResponseDto(studentResponseDto, orgStudent, studentUrlMap);
            if (!isShow) {
                studentResponseDto.setMobile(MaskUtil.maskMobile((String)studentResponseDto.getMobile()));
            }
            orgStudentCourseResponseDtos.add(studentResponseDto);
        }
        return orgStudentCourseResponseDtos;
    }

    @Override
    @Transactional(readOnly=true)
    public List<OrgStudentsChooseListDto> getStudentChooseList(@NonNull Long orgId, @NonNull Long courseId, String key, PageDto page) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (courseId == null) {
            throw new NullPointerException("courseId");
        }
        HashSet userIds = Sets.newHashSet();
        if (courseId != null && courseId > 0L) {
            List userIdList = this.orgStudentCourseDao.getStudents(orgId, courseId, Integer.valueOf(0));
            log.debug("userIdList= {}", (Object)userIdList);
            userIds.addAll(userIdList);
        }
        List students = this.orgStudentDao.getStudentsNotInUserIds(orgId, (Collection)userIds, key, Integer.valueOf(DeleteStatus.NORMAL.getValue()), page, new String[0]);
        log.debug("students= {}", (Object)students);
        ArrayList chooseList = Lists.newArrayList();
        ArrayList studentUserIds = Lists.newArrayList();
        for (OrgStudent stu : students) {
            studentUserIds.add(stu.getUserId());
        }
        Map<Long, String> studentAvatarUrlMap = this.getOrgStudentAvatarUrlMap(studentUserIds);
        boolean isMaskMobile = this.txCascadeCredentialService.isShowMobile(orgId, TianxiaoMContext.getTXCascadeId());
        log.debug("studentAvatarUrlMap= {}", studentAvatarUrlMap);
        for (OrgStudent stu : students) {
            OrgStudentsChooseListDto dto = new OrgStudentsChooseListDto();
            dto.setStudentId(stu.getId());
            dto.setMobile(this.getShowMobile(stu));
            if (!isMaskMobile) {
                dto.setMobile(MaskUtil.maskMobile((String)dto.getMobile()));
            }
            dto.setIsChosen(userIds.contains(stu.getUserId()));
            dto.setName(StudentNameUtil.buildStudentName(stu));
            dto.setAvatarUrl(studentAvatarUrlMap.get(stu.getUserId()));
            dto.setOpenId(stu.getWeixin());
            chooseList.add(dto);
        }
        return chooseList;
    }

    private String getShowMobile(OrgStudent stu) {
        if (StringUtils.isNotBlank((String)stu.getShowMobile()) && !stu.getShowMobile().contains("*")) {
            return stu.getShowMobile();
        }
        return stu.getMobile();
    }

    private void deleteStudentFromCourseLesson(Long orgId, Long courseId, Long userId) {
        List leftLessonIds = this.orgClassLessonDao.getLeftLessonIds(orgId, courseId);
        log.info("leftLessonIds = {}", (Object)leftLessonIds);
        this.orgStudentLessonDao.delStudentFromLesson(orgId, (Collection)leftLessonIds, userId);
    }

    private void buildStudentResponseDto(StudentResponseDto studentResponseDto, OrgStudent orgStudent, Map<Long, String> urlMap) {
        studentResponseDto.setStudentId(orgStudent.getId());
        studentResponseDto.setMobile(orgStudent.getMobile());
        studentResponseDto.setWeixin(orgStudent.getWeixin());
        studentResponseDto.setName(StudentNameUtil.buildStudentName(orgStudent));
        studentResponseDto.setAvatarUrl(urlMap.get(orgStudent.getUserId()));
    }

    @Override
    @Transactional(readOnly=true)
    public CourseStudentDetailDto getCourseStudentDetail(@NonNull Long orgId, @NonNull Long courseId, @NonNull Long studentId) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (courseId == null) {
            throw new NullPointerException("courseId");
        }
        if (studentId == null) {
            throw new NullPointerException("studentId");
        }
        CourseStudentDetailDto detailDto = new CourseStudentDetailDto();
        OrgCourse orgCourse = (OrgCourse)this.orgCourseDao.getById((Serializable)courseId, new String[]{"name"});
        OrgStudent orgStudent = (OrgStudent)this.orgStudentDao.getById((Serializable)studentId, new String[0]);
        if (orgCourse == null) {
            log.error("course not exist!");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        detailDto.setCourseName(orgCourse.getName());
        detailDto.setCourseId(courseId);
        boolean isShow = this.txCascadeCredentialService.isShowMobile(orgId, TianxiaoMContext.getTXCascadeId());
        if (orgStudent != null) {
            log.debug("orgStudent = {}", (Object)orgStudent);
            detailDto.setStudentId(orgStudent.getId());
            detailDto.setStudentName(StudentNameUtil.buildStudentName(orgStudent));
            detailDto.setMobile(this.getShowMobile(orgStudent));
            if (!isShow) {
                detailDto.setMobile(MaskUtil.maskMobile((String)detailDto.getMobile()));
            }
        } else {
            log.error("student not exist!");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        Map<Long, String> mapUrl = this.getOrgStudentAvatarUrlMap(Lists.newArrayList((Object[])new Long[]{orgStudent.getUserId()}));
        detailDto.setAvatarUrl(mapUrl.get(orgStudent.getUserId()));
        List orgLessonSign = this.orgLessonSignDao.getStudentLessonSign(orgId, courseId, orgStudent.getUserId());
        log.debug("orgLessonSign = {}, orgId = {}, courseId ={},  userId = {}", new Object[]{orgLessonSign, orgId, courseId, orgStudent.getUserId()});
        ArrayList lessons = Lists.newArrayList();
        for (OrgLessonSign sign : orgLessonSign) {
            ClassLessonInfoDto lessonDto = new ClassLessonInfoDto();
            OrgClassLesson orgClassLesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)sign.getLessonId(), new String[0]);
            if (orgClassLesson != null) {
                lessonDto.setStartTime(orgClassLesson.getStartTime());
                lessonDto.setEndTime(orgClassLesson.getEndTime());
            }
            lessonDto.setIndex(sign.getIndex());
            lessonDto.setLessonId(sign.getLessonId());
            lessonDto.setStatus(sign.getStatus() == null ? 0 : sign.getStatus());
            lessons.add(lessonDto);
        }
        log.debug("lessons ={}", (Object)lessons);
        detailDto.setLessons(lessons);
        return detailDto;
    }

    @Override
    @Transactional(readOnly=true)
    public List<OrgStudentsChooseListDto> getLessonStudent(@NonNull Long orgId, @NonNull Long lessonId, boolean needSignStatus) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (lessonId == null) {
            throw new NullPointerException("lessonId");
        }
        ArrayList chooseList = Lists.newArrayList();
        List userIdList = this.orgStudentLessonDao.getUserIds(lessonId, orgId);
        HashSet userIds = Sets.newHashSet((Iterable)userIdList);
        List students = this.orgStudentDao.getStudentByUserIds(orgId, (Collection)userIds, new String[]{"mobile", "id", "name", "userId"});
        Map<Long, String> studentAvatarUrlMap = this.getOrgStudentAvatarUrlMap(userIdList);
        HashMap studentSignMap = Maps.newHashMap();
        if (needSignStatus) {
            List lessonSigns = this.orgLessonSignDao.getLessonSignList(orgId, null, lessonId, null, Integer.valueOf(UserRole.STUDENT.getRole()), null, null, null, new String[]{"userId", "status"});
            for (OrgLessonSign lessonSign : lessonSigns) {
                studentSignMap.put(lessonSign.getUserId(), SignStatus.getSignStatusByCode((Integer)lessonSign.getStatus()));
            }
        }
        log.debug("student avatar:{}", studentAvatarUrlMap);
        for (OrgStudent stu : students) {
            OrgStudentsChooseListDto dto = new OrgStudentsChooseListDto();
            dto.setStudentId(stu.getId());
            dto.setMobile(this.getShowMobile(stu));
            dto.setIsChosen(userIds.contains(stu.getUserId()));
            dto.setName(StudentNameUtil.buildStudentName(stu));
            dto.setAvatarUrl(studentAvatarUrlMap.get(stu.getUserId()));
            dto.setStudentSignStatus((SignStatus)studentSignMap.get(stu.getUserId()));
            chooseList.add(dto);
        }
        Collections.sort(chooseList, new Comparator<OrgStudentsChooseListDto>(){

            @Override
            public int compare(OrgStudentsChooseListDto o1, OrgStudentsChooseListDto o2) {
                if (o1.getSignStatus() == null) {
                    o1.setStudentSignStatus(SignStatus.UNSIGN);
                }
                if (o2.getSignStatus() == null) {
                    o2.setStudentSignStatus(SignStatus.UNSIGN);
                }
                return o1.getSignStatus().compareTo(o2.getSignStatus());
            }
        });
        return chooseList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int delLessonStudent(Long orgId, Long lessonId, Long studentId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((studentId != null && studentId > 0L ? 1 : 0) != 0, (Object)"studentId is illegal");
        Preconditions.checkArgument((lessonId != null && lessonId > 0L ? 1 : 0) != 0, (Object)"lessonId is illegal");
        Long userId = this.orgStudentDao.getUserId(studentId);
        OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)lessonId, new String[]{"startTime", "endTime"});
        if (lesson == null) {
            log.warn("can not found lesson by lessonId:{}", (Object)lessonId);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfe\u8282ID\u4e0d\u6b63\u786e");
        }
        boolean isSign = this.orgLessonSignDao.isStudentSignInLesson(orgId, lessonId, userId);
        if (isSign) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8be5\u5b66\u751f\u5df2\u7b7e\u5230\u4e0d\u80fd\u5220\u9664");
        }
        OrgLessonComment comment = this.orgLessonCommentDao.getLessonCommentDetail(lessonId, userId, Integer.valueOf(UserRole.STUDENT.getRole()), Boolean.valueOf(false), new String[]{"id"});
        if (comment != null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8be5\u5b66\u751f\u5df2\u7ecf\u8fdb\u884c\u4e86\u8bc4\u4ef7,\u4e0d\u80fd\u5220\u9664");
        }
        HashMap condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("lessonId", lessonId);
        condition.put("userId", userId);
        return this.orgStudentLessonDao.delByCondition((Map)condition);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int deleteStudentFromLesson(Long orgId, Long lessonId, Collection<Long> userIds) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((lessonId != null && lessonId > 0L ? 1 : 0) != 0, (Object)"lessonId is illegal");
        OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)lessonId, new String[]{"startTime", "endTime"});
        if (lesson == null) {
            log.warn("can not found lesson by lessonId:{}", (Object)lessonId);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfe\u8282ID\u4e0d\u6b63\u786e");
        }
        HashMap condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("lessonId", lessonId);
        if (CollectionUtils.isNotEmpty(userIds)) {
            condition.put("userId", userIds);
        }
        return this.orgStudentLessonDao.delByCondition((Map)condition);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addStudentToLesson(Long orgId, Long courseId, Long lessonId, Collection<Long> studentIds, boolean isStudentId) {
        List addedStuIds;
        List courseStudents;
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((lessonId != null && lessonId > 0L ? 1 : 0) != 0, (Object)"lessonId is illegal");
        if (CollectionUtils.isEmpty(studentIds)) {
            log.warn("add student ids is empty");
            return;
        }
        if (isStudentId) {
            Map userIdMap = this.orgStudentDao.getStudentIdUserIdMap(studentIds);
            if (MapUtils.isEmpty((Map)userIdMap)) {
                log.warn("add student ids is empty");
                return;
            }
            studentIds = userIdMap.values();
        }
        if (courseId == null) {
            OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)lessonId, new String[]{"courseId", "orgId"});
            Preconditions.checkArgument((lesson != null && lesson.getOrgId().equals(orgId) ? 1 : 0) != 0, (Object)"\u8bfe\u8282ID\u4e0d\u6b63\u786e");
            courseId = lesson.getCourseId();
        }
        if (!(courseStudents = this.orgStudentCourseDao.getStudents(orgId, courseId, Integer.valueOf(0))).containsAll(studentIds)) {
            log.warn("lesson teacher:{} is not all course teacher ids:{}", studentIds, (Object)courseStudents);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5fc5\u987b\u4ece\u8bfe\u7a0b\u5b66\u751f\u4e2d\u6dfb\u52a0\u8bfe\u8282\u5b66\u751f");
        }
        Map lessonStudentIds = this.orgStudentLessonDao.getLessonStudentList((Collection)Lists.newArrayList((Object[])new Long[]{lessonId}));
        if (lessonStudentIds.containsKey(lessonId) && CollectionUtils.isNotEmpty((Collection)(addedStuIds = (List)lessonStudentIds.get(lessonId)))) {
            studentIds.removeAll(addedStuIds);
        }
        ArrayList saveStudentLessons = Lists.newArrayList();
        OrgStudentLesson po = null;
        for (Long studentId : studentIds) {
            po = new OrgStudentLesson();
            po.setCreateTime(new Date());
            po.setLessonId(lessonId);
            po.setOrgId(orgId);
            po.setUserId(studentId);
            saveStudentLessons.add(po);
        }
        log.info("save students :{} to lessonid:{}", (Object)saveStudentLessons, (Object)lessonId);
        this.orgStudentLessonDao.saveAll((List)saveStudentLessons, new String[]{"createTime", "lessonId", "orgId", "userId"});
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void resetLessonStudent(Long orgId, Long courseId, Long lessonId, Collection<Long> studentIds) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"courseId is illegal");
        Preconditions.checkArgument((lessonId != null && lessonId > 0L ? 1 : 0) != 0, (Object)"lessonId is illegal");
        this.deleteStudentFromLesson(orgId, lessonId, null);
        Map userIdMap = this.orgStudentDao.getStudentIdUserIdMap(studentIds);
        if (MapUtils.isEmpty((Map)userIdMap)) {
            log.warn("add student ids is empty");
            return;
        }
        Collection<Long> userIds = userIdMap.values();
        this.addStudentToLesson(orgId, courseId, lessonId, userIds, false);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Long> getStudentLessonIds(@NonNull Long orgId, @NonNull Long studentId) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (studentId == null) {
            throw new NullPointerException("studentId");
        }
        Long userId = this.orgStudentDao.getUserId(studentId);
        if (userId == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "student not found!");
        }
        return this.orgStudentLessonDao.getLessonIdsOfStudent(orgId, userId);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Long> getCourseStudentUserIds(Long orgId, Long courseId) {
        return this.orgStudentCourseDao.getStudents(orgId, courseId, Integer.valueOf(0));
    }

    @Override
    @Transactional(readOnly=true)
    public Map<String, String> getStudentNameAndAvatar(Long orgId, Long studentId) {
        Long userId = this.orgStudentDao.getUserId(studentId);
        Preconditions.checkArgument((userId != null && userId > 0L ? 1 : 0) != 0, (Object)"student not found!");
        Map<Long, String> urlMap = this.getOrgStudentAvatarUrlMap(Lists.newArrayList((Object[])new Long[]{userId}));
        String avatarUrl = urlMap.get(userId);
        OrgStudent orgStudent = this.orgStudentDao.getStudent(orgId, userId, Integer.valueOf(0), new String[]{"name"});
        HashMap map = Maps.newHashMap();
        map.put("name", orgStudent != null ? orgStudent.getName() : "");
        map.put("avatarUrl", avatarUrl);
        return map;
    }

    @Override
    @Transactional(readOnly=true)
    public Map<String, Integer> getStudentCourseLessonInfo(Long orgId, Long studentId) {
        Long userId = this.orgStudentDao.getUserId(studentId);
        Preconditions.checkArgument((userId != null && userId > 0L ? 1 : 0) != 0, (Object)"student not exists!");
        HashMap map = Maps.newHashMap();
        List courseIds = this.orgStudentCourseDao.getStudentCourseIds(orgId, userId, null);
        Integer courseCount = 0;
        OrgAccount orgAccount = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[]{"number"});
        if (orgAccount == null) {
            log.error("orgId = {} not exist in orgAccount", (Object)orgId);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u673a\u6784\u5e10\u53f7\u9519\u8bef");
        }
        Long orgNumber = orgAccount.getNumber().longValue();
        List orgCourses = this.orgCourseDao.getByIds((Collection)courseIds, new String[0]);
        ArrayList courseNoDeleteIds = Lists.newArrayList();
        for (OrgCourse orgCourse : orgCourses) {
            if (orgCourse.getIsDel() != 0 || !orgCourse.getOrgNumber().equals(orgNumber)) continue;
            Integer n = courseCount;
            Integer n2 = courseCount = Integer.valueOf(courseCount + 1);
            courseNoDeleteIds.add(orgCourse.getId());
        }
        map.put("lessonToday", this.orgStudentLessonDao.getStudentLessonCountTodayByCourseId(orgId, userId, (List)courseNoDeleteIds));
        map.put("courseCount", courseCount);
        map.put("commentCount", this.orgLessonCommentDao.getStudentLessonCommentCount(orgId, userId, null));
        return map;
    }
}

