/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.course.service.impl;

import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constants.CourseType;
import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupRelateDao;
import com.baijia.tianxiao.dal.course.dao.OrgCoursePhotoDao;
import com.baijia.tianxiao.dal.course.po.OrgCoursePhoto;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassRoomDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseRoomDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseSeatDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseSmsDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseRoom;
import com.baijia.tianxiao.dal.org.po.OrgCourseSms;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.course.constant.ArrangeStatus;
import com.baijia.tianxiao.sal.course.constant.CourseErrorCode;
import com.baijia.tianxiao.sal.course.constant.ViewStatus;
import com.baijia.tianxiao.sal.course.dto.request.WeikeRequestDto;
import com.baijia.tianxiao.sal.course.dto.response.CourseListReponseDto;
import com.baijia.tianxiao.sal.course.service.OrgCourseListService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Resource;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgCourseListServiceImpl
implements OrgCourseListService {
    private static final Logger log = LoggerFactory.getLogger(OrgCourseListServiceImpl.class);
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private OrgClassRoomDao orgClassRoomDao;
    @Autowired
    private OrgCourseTeacherDao orgCourseTeacherDao;
    @Resource
    private TeacherDao teacherDao;
    @Resource
    private CoursePurchaseDao coursePurchaseDao;
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgCourseSeatDao orgCourseSeatDao;
    @Resource
    private OrgClassLessonDao orgClassLessonDao;
    @Resource
    private OrgCourseRoomDao orgCourseRoomDao;
    @Resource
    private OrgCourseSmsDao orgCourseSmsDao;
    @Resource
    private StorageDao storageDao;
    @Resource
    private Environment environment;
    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;
    @Resource
    private OrgLessonSignDao orgLessonSignDao;
    @Resource
    private OrgCourseGroupRelateDao orgCourseGroupRelateDao;
    @Resource
    private OrgCoursePhotoDao orgCoursePhotoDao;

    @Override
    public List<CourseListReponseDto> getCourseList(List<OrgCourse> courses, Long orgId, boolean needLesson, boolean needSms, boolean needTeacher, Boolean needStudent, boolean needRoom, boolean needCover, boolean needUrl) {
        OrgCourseListService.CourseListParam param = new OrgCourseListService.CourseListParam();
        param.setCourses(courses).setNeedLesson(needLesson).setNeedSms(needSms).setNeedTeacher(needTeacher).setNeedStudent(needStudent).setNeedRoom(needRoom).setNeedCover(needCover).setNeedUrl(needUrl).setOrgId(orgId);
        return this.getCourseList(param);
    }

    @Override
    public List<CourseListReponseDto> getWeikeList(Long orgId, WeikeRequestDto requestDto) {
        List courseIds;
        log.info("{},{}", (Object)orgId, (Object)requestDto);
        String key = requestDto.getSearchKey();
        List<Long> teacherIds = requestDto.getTeacherIdList();
        List<Integer> groupIds = requestDto.getGroupIdList();
        List<Integer> exGroupIds = requestDto.getExGroupIdList();
        Long orgNumber = this.getOrgNumber(orgId);
        List courseIdsOfTeachers = null;
        if (CollectionUtils.isNotEmpty(teacherIds)) {
            courseIdsOfTeachers = this.orgCourseTeacherDao.getCourseIdsByteacherIds(teacherIds);
        }
        Collection courseOfGroups = null;
        if (CollectionUtils.isNotEmpty(groupIds)) {
            courseOfGroups = this.orgCourseGroupRelateDao.getCourseIdsByGroups(groupIds, Integer.valueOf(CourseType.ORG_COURSE.getCode()));
        }
        Collection exCourseOfGroups = null;
        if (CollectionUtils.isNotEmpty(exGroupIds)) {
            exCourseOfGroups = this.orgCourseGroupRelateDao.getCourseIdsByGroups(exGroupIds, Integer.valueOf(CourseType.ORG_COURSE.getCode()));
        }
        Collection filteredCourses = null;
        if (courseIdsOfTeachers != null) {
            filteredCourses = courseIdsOfTeachers;
            if (courseOfGroups != null) {
                filteredCourses.retainAll(courseOfGroups);
            }
        } else {
            filteredCourses = courseOfGroups;
        }
        if (CollectionUtils.isNotEmpty((Collection)(courseIds = this.orgCourseDao.getCourseList(orgNumber, filteredCourses, requestDto.getLPrice(), requestDto.getHPrice(), null, key, requestDto.getStatus()))) && CollectionUtils.isNotEmpty((Collection)exCourseOfGroups)) {
            courseIds.removeAll(exCourseOfGroups);
        }
        Map<String, String> orderConditionMap = requestDto.getOrderConditionMap();
        OrgCourseDao.OrgCourseListParam param = new OrgCourseDao.OrgCourseListParam();
        param.setPage((PageDto)requestDto);
        if (MapUtils.isNotEmpty(orderConditionMap)) {
            String studentCountOrder = orderConditionMap.get("studentCount");
            if (StringUtils.isNotBlank((String)studentCountOrder)) {
                if ("ASC".equals(studentCountOrder)) {
                    courseIds = this.orgStudentCourseDao.getOrgCourseIds(orgId, courseIds, true, (PageDto)requestDto);
                } else if ("DESC".equals(studentCountOrder)) {
                    courseIds = this.orgStudentCourseDao.getOrgCourseIds(orgId, courseIds, false, (PageDto)requestDto);
                }
                param.setPage(null);
            } else {
                if (StringUtils.isNotBlank((String)orderConditionMap.get("beginTime"))) {
                    param.setOrderType(orderConditionMap.get("beginTime"));
                    param.setOrderField("beginTime");
                }
                if (StringUtils.isNotBlank((String)orderConditionMap.get("createTime"))) {
                    param.setOrderType(orderConditionMap.get("createTime"));
                    param.setOrderField("createTime");
                }
            }
        } else {
            param.setOrderType("DESC");
            param.setOrderField("createTime");
        }
        List orgCourses = this.orgCourseDao.getCourseList(orgNumber, (Collection)courseIds, param, new String[0]);
        OrgCourseListService.CourseListParam courseListParam = new OrgCourseListService.CourseListParam();
        courseListParam.setCourses(orgCourses).setNeedCover(true).setNeedUrl(true).setOrgId(orgId);
        return this.getCourseList(courseListParam);
    }

    private void batchUpdateColor(Set<Long> courseIds, List<OrgCourse> courses) {
        ArrayList courseList = Lists.newArrayList();
        String colorsStr = "";
        try {
            colorsStr = PropertiesReader.getValueNoCache((String)"erp.properties", (String)"course.colors");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String[] colors = null;
        if (StringUtils.isNotBlank((String)colorsStr)) {
            colors = colorsStr.split(",");
        }
        Random rd = new Random();
        for (OrgCourse orgCourse : courses) {
            if (StringUtils.isBlank((String)orgCourse.getColor())) {
                if (colors != null) {
                    orgCourse.setColor(colors[rd.nextInt(colors.length - 1)]);
                }
                courseList.add(orgCourse);
            }
            courseIds.add(orgCourse.getId());
        }
        if (colors != null) {
            this.orgCourseDao.changeCourseColor((Collection)courseList);
        }
    }

    private void getSmsCount(Map<Long, Integer> studentSms, Map<Long, Integer> teacherSms, Map<Long, Integer> studentView, Map<Long, Integer> teacherView, List<OrgCourseSms> courseSms, Map<Long, List<Long>> courseStudentMap, Map<Long, List<Long>> courseTeacherMap) {
        for (OrgCourseSms orgCourseSms : courseSms) {
            if (!studentSms.containsKey(orgCourseSms.getCourseId())) {
                studentSms.put(orgCourseSms.getCourseId(), 0);
            }
            if (!teacherSms.containsKey(orgCourseSms.getCourseId())) {
                teacherSms.put(orgCourseSms.getCourseId(), 0);
            }
            if (!studentView.containsKey(orgCourseSms.getCourseId())) {
                studentView.put(orgCourseSms.getCourseId(), 0);
            }
            if (!teacherView.containsKey(orgCourseSms.getCourseId())) {
                teacherView.put(orgCourseSms.getCourseId(), 0);
            }
            if (orgCourseSms.getUserRole().intValue() == UserRole.STUDENT.getRole()) {
                List<Long> studentIds = courseStudentMap.get(orgCourseSms.getCourseId());
                if (studentIds == null || !studentIds.contains(orgCourseSms.getUserId())) continue;
                if (orgCourseSms.getSend() > 0) {
                    studentSms.put(orgCourseSms.getCourseId(), studentSms.get(orgCourseSms.getCourseId()) + 1);
                }
                if (orgCourseSms.getViewStatus().intValue() != ViewStatus.VIEW.getCode()) continue;
                studentView.put(orgCourseSms.getCourseId(), studentView.get(orgCourseSms.getCourseId()) + 1);
                continue;
            }
            List<Long> teacherIds = courseTeacherMap.get(orgCourseSms.getCourseId());
            if (teacherIds == null || !teacherIds.contains(orgCourseSms.getUserId())) continue;
            if (orgCourseSms.getSend() > 0) {
                teacherSms.put(orgCourseSms.getCourseId(), teacherSms.get(orgCourseSms.getCourseId()) + 1);
            }
            if (orgCourseSms.getViewStatus().intValue() != ViewStatus.VIEW.getCode()) continue;
            teacherView.put(orgCourseSms.getCourseId(), teacherView.get(orgCourseSms.getCourseId()) + 1);
        }
    }

    @Override
    public Map<Integer, String> getCoverMap(List<OrgCourse> courses) {
        Collection coverList = CollectorUtil.collect(courses, (Function)new Function<OrgCourse, Integer>(){

            public Integer apply(OrgCourse arg0) {
                return arg0.getCover();
            }
        });
        List storages = this.storageDao.getByIds(coverList, new String[0]);
        return CollectorUtil.collectMap((Collection)storages, (Function)new Function<Storage, Integer>(){

            public Integer apply(Storage arg0) {
                return arg0.getId().intValue();
            }
        }, (Function)new Function<Storage, String>(){

            public String apply(Storage arg0) {
                if (StringUtils.isNotBlank((String)arg0.getAttach_url())) {
                    return arg0.getAttach_url();
                }
                return StorageUtil.constructUrl((Long)arg0.getFid(), (String)arg0.getMimetype(), (String)arg0.getSn());
            }
        });
    }

    @Override
    public Map<Long, OrgCoursePhoto> getPhoteMap(List<Long> courseIds) {
        HashMap<String, List<Long>> condition = new HashMap<String, List<Long>>();
        condition.put("orgCourseId", courseIds);
        List list = this.orgCoursePhotoDao.queryByCourseIds(courseIds);
        HashMap<Long, OrgCoursePhoto> map = new HashMap<Long, OrgCoursePhoto>();
        for (OrgCoursePhoto coursePhoto : list) {
            map.put(coursePhoto.getOrgCourseId(), coursePhoto);
        }
        return map;
    }

    private void buildCourseListResponseDto(OrgCourse po, CourseListReponseDto dto) {
        dto.setOrgCourseId(po.getId());
        dto.setOrgCourseNumber(po.getNumber());
        dto.setColor(po.getColor());
        dto.setCourseName(po.getName());
        dto.setMaxStudent(po.getMaxStudent());
        dto.setFreq(po.getFreq());
        dto.setStartTime(po.getBeginTime());
        dto.setEndTime(po.getEndTime());
        dto.setPrice(po.getPrice());
        dto.setStatus(po.getStatus());
        String intro = BaseUtils.blobToString((Blob)po.getIntroduction(), (String)"UTF-8");
        dto.setIntroduction(intro);
    }

    private void buildLessonCount(OrgCourse po, CourseListReponseDto dto, Map<Long, Integer> arrangeMap, Map<Long, Integer> finishMap) {
        if (arrangeMap.containsKey(po.getId())) {
            dto.setLessonCount(arrangeMap.get(po.getId()));
        } else {
            dto.setLessonCount(0);
        }
        if (finishMap.containsKey(po.getId())) {
            dto.setLessonFinish(finishMap.get(po.getId()));
        } else {
            dto.setLessonFinish(0);
        }
        if (dto.getLessonCount() != null && dto.getLessonFinish() != null && dto.getLessonCount() > dto.getLessonFinish() && dto.getLessonFinish() > 0) {
            dto.setArrageStatus(ArrangeStatus.BEGIN.getCode());
        } else if (dto.getLessonCount() != null && dto.getLessonCount() > 0) {
            dto.setArrageStatus(ArrangeStatus.ARRANGEED.getCode());
        } else {
            dto.setArrageStatus(ArrangeStatus.UNARRANGE.getCode());
        }
    }

    private void buildTeacher(OrgCourse po, CourseListReponseDto dto, Map<Long, Integer> teacherMap) {
        Integer count = teacherMap.get(po.getId());
        if (count != null) {
            dto.setTeacherCount(count);
        } else {
            dto.setTeacherCount(0);
        }
    }

    private void buildStudent(OrgCourse po, CourseListReponseDto dto, Map<Long, Integer> studentMap) {
        Integer count = studentMap.get(po.getId());
        if (count != null) {
            dto.setStudentCount(count);
        } else {
            dto.setStudentCount(0);
        }
    }

    private void buildRoom(OrgCourse po, CourseListReponseDto dto, Map<Long, Integer> roomMap) {
        Integer count = roomMap.get(po.getId());
        if (count != null) {
            dto.setRoomCount(count);
        } else {
            dto.setRoomCount(0);
        }
    }

    private void buildSmsCount(OrgCourse po, CourseListReponseDto dto, Map<Long, Integer> studentSms, Map<Long, Integer> teacherSms, Map<Long, Integer> studentView, Map<Long, Integer> teacherView) {
        int studentSmsCount = 0;
        int teacherSmsCount = 0;
        int studentViewCount = 0;
        int teacherViewCount = 0;
        if (studentSms.get(po.getId()) != null) {
            studentSmsCount = studentSms.get(po.getId());
        }
        if (teacherSms.get(po.getId()) != null) {
            teacherSmsCount = teacherSms.get(po.getId());
        }
        if (studentView.get(po.getId()) != null) {
            studentViewCount = studentView.get(po.getId());
        }
        if (teacherView.get(po.getId()) != null) {
            teacherViewCount = teacherView.get(po.getId());
        }
        log.debug("studentSmsCount={}, teacherSmsCount={}", (Object)studentSmsCount, (Object)teacherSmsCount);
        dto.setSmsStudent(dto.getStudentCount() - studentSmsCount);
        dto.setViewStudent(dto.getStudentCount() - studentViewCount);
        dto.setSmsTeacher(dto.getTeacherCount() - teacherSmsCount);
        dto.setViewTeacher(dto.getTeacherCount() - teacherViewCount);
    }

    private Long getOrgNumber(Long orgId) {
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[]{"number"});
        if (orgAccount == null) {
            log.error("orgId={} not exist in orgAccount.", (Object)orgId);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u673a\u6784\u5e10\u53f7\u9519\u8bef");
        }
        return orgAccount.getNumber().longValue();
    }

    @Override
    @Transactional(readOnly=true)
    public List<CourseListReponseDto> getCourseList(@NonNull Long orgId, @NonNull Long studentId, PageDto pageDto) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (studentId == null) {
            throw new NullPointerException("studentId");
        }
        Long userId = this.orgStudentDao.getUserId(studentId);
        Preconditions.checkArgument((userId != null && userId > 0L ? 1 : 0) != 0, (Object)"student not exits!");
        List stuCourses = this.orgStudentCourseDao.getOrgCourseIds(orgId, userId, pageDto);
        if (CollectionUtils.isEmpty((Collection)stuCourses)) {
            return Collections.emptyList();
        }
        HashMap idCourseMap = Maps.newHashMap();
        for (OrgStudentCourse course : stuCourses) {
            idCourseMap.put(course.getCourseId(), course);
        }
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[]{"number"});
        if (orgAccount == null) {
            log.error("orgId={} not exist in orgAccount.", (Object)orgId);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u673a\u6784\u5e10\u53f7\u9519\u8bef");
        }
        Long orgNumber = orgAccount.getNumber().longValue();
        List courses = this.orgCourseDao.getCourseList(idCourseMap.keySet(), orgNumber, null, new String[0]);
        log.debug("OrgStudentCourses = {}, courses = {}, page = {}", new Object[]{stuCourses, courses, pageDto});
        if (CollectionUtils.isEmpty((Collection)courses)) {
            return Collections.emptyList();
        }
        List<CourseListReponseDto> list = this.getCourseList(courses, orgId, true, false, false, false, false, true, false);
        if (CollectionUtils.isNotEmpty(list)) {
            Map lessonCountMap = this.orgStudentLessonDao.getStudentLessonCountOfCourses(orgId, userId, idCourseMap.keySet());
            log.debug("list={},lessonCountMap={}", list, (Object)lessonCountMap);
            for (CourseListReponseDto dto : list) {
                Integer lessonCount = (Integer)lessonCountMap.get(dto.getOrgCourseId());
                if (lessonCount == null) {
                    lessonCount = 0;
                }
                dto.setLessonCount(lessonCount);
                dto.setStatus(((OrgStudentCourse)idCourseMap.get(dto.getOrgCourseId())).getStatus());
            }
        }
        return list;
    }

    @Override
    @Transactional(readOnly=true)
    public CourseListReponseDto getCourseDetail(Long orgId, Long orgCourseId) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId is null!");
        Preconditions.checkArgument((orgCourseId != null ? 1 : 0) != 0, (Object)"orgCourseId is null!");
        OrgCourse course = this.orgCourseDao.getByCourseId(orgCourseId, new String[0]);
        OrgAccount account = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
        if (course == null || account == null || course.getOrgNumber().longValue() != account.getNumber().longValue()) {
            throw new BussinessException((UniverseErrorCode)CourseErrorCode.COURSE_NOT_EXIST);
        }
        Integer lessonCount = this.orgClassLessonDao.getLessonCount(orgId, orgCourseId, Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        Integer finishCount = this.orgClassLessonDao.getFinishLessonCount(orgId, orgCourseId, Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        List roomIds = this.orgCourseRoomDao.getCourseRoomIds(orgId, orgCourseId);
        List teacherIds = this.orgCourseTeacherDao.getTeacherIdsByCourseId(orgCourseId);
        List studentIds = this.orgStudentCourseDao.getStudents(orgId, orgCourseId, Integer.valueOf(0));
        CourseListReponseDto dto = new CourseListReponseDto();
        dto.setCourseName(course.getName());
        dto.setOrgCourseId(orgCourseId);
        dto.setOrgCourseNumber(course.getNumber());
        dto.setFreq(course.getFreq());
        String courseUrl = this.environment.getProperty("org_class_course.url");
        dto.setCourseUrl(course.getNumber() == null ? "" : courseUrl + course.getNumber());
        dto.setLessonCount(lessonCount);
        dto.setLessonFinish(finishCount);
        dto.setRoomCount(roomIds.size());
        dto.setTeacherCount(teacherIds.size());
        dto.setStudentCount(studentIds.size());
        dto.setStatus(course.getStatus());
        dto.setMaxStudent(course.getMaxStudent());
        dto.setColor(course.getColor());
        dto.setCreateTime(course.getCreateTime());
        dto.setCascadeId(course.getCascadeId());
        return dto;
    }

    @Override
    @Transactional(noRollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public List<CourseListReponseDto> getCourseList(OrgCourseListService.CourseListParam param) {
        List<OrgCourse> courses = param.getCourses();
        Long studentId = param.getStudentId();
        Long teacherId = param.getTeacherId();
        Long orgId = param.getOrgId();
        boolean needLesson = param.isNeedLesson();
        boolean needSms = param.isNeedSms();
        boolean needTeacher = param.isNeedTeacher();
        boolean needStudent = param.isNeedStudent();
        boolean needRoom = param.isNeedRoom();
        boolean needCover = param.isNeedCover();
        boolean needUrl = param.isNeedUrl();
        log.debug("needLesson={},needSms={},needTeacher={},needStudent={},needRoom={},needCover={},needUrl={}", new Object[]{needLesson, needSms, needTeacher, needStudent, needRoom, needCover, needUrl});
        ArrayList response = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(courses)) {
            HashSet courseIds = Sets.newHashSet();
            this.batchUpdateColor(courseIds, courses);
            log.debug("courseIds={}", (Object)courseIds);
            Map<Integer, String> coverMap = null;
            Map<Long, OrgCoursePhoto> photoMap = null;
            if (needCover) {
                coverMap = this.getCoverMap(courses);
                photoMap = this.getPhoteMap(new ArrayList<Long>(courseIds));
                log.debug("orgCoursePhotoMap={}", photoMap);
            }
            Map arrangeMap = null;
            Map finishMap = null;
            if (needLesson) {
                arrangeMap = this.orgClassLessonDao.getCourseLessonCount(orgId, (Collection)courseIds, studentId, teacherId, null);
                finishMap = this.orgClassLessonDao.getCourseLessonCount(orgId, (Collection)courseIds, studentId, teacherId, new Date());
            }
            Map teacherMap = null;
            if (needTeacher) {
                teacherMap = this.orgCourseTeacherDao.getTeacherCount((Collection)courseIds);
            }
            Map<Long, Integer> studentMap = null;
            Map studentIdMap = null;
            if (needStudent) {
                studentIdMap = this.orgStudentCourseDao.getStudentIdMapBycourseIds((Collection)courseIds, orgId);
                studentMap = this.getCourseStudentMap(studentIdMap, orgId);
                log.debug("studentMap = {}", studentMap);
            }
            Map roomMap = null;
            Map mapCourseRoom = null;
            Map roomNameMap = null;
            if (needRoom) {
                roomMap = this.orgCourseRoomDao.getCourseRoomCount(orgId, (Collection)courseIds);
                mapCourseRoom = this.orgCourseRoomDao.getCourseRoomMap(orgId, (Collection)courseIds, new String[0]);
                HashSet roomIds = Sets.newHashSet();
                for (Long k : mapCourseRoom.keySet()) {
                    List rooms = (List)mapCourseRoom.get(k);
                    for (OrgCourseRoom room : rooms) {
                        roomIds.add(room.getRoomId());
                    }
                }
                roomNameMap = this.orgClassRoomDao.getRoomName(orgId, (Collection)roomIds);
            }
            HashMap studentSms = Maps.newHashMap();
            HashMap teacherSms = Maps.newHashMap();
            HashMap studentView = Maps.newHashMap();
            HashMap teacherView = Maps.newHashMap();
            if (needSms) {
                if (studentIdMap == null) {
                    studentIdMap = this.orgStudentCourseDao.getStudentIdMapBycourseIds((Collection)courseIds, orgId);
                }
                Map courseTeacherMap = this.orgCourseTeacherDao.getTeacherMap((Collection)courseIds);
                List courseSms = this.orgCourseSmsDao.getOrgCourseSmsList(orgId, (Collection)courseIds, null, new String[0]);
                this.getSmsCount(studentSms, teacherSms, studentView, teacherView, courseSms, studentIdMap, courseTeacherMap);
                log.debug("student sms count ={},teacher sms count ={}", (Object)studentSms, (Object)teacherSms);
            }
            String url = this.environment.getProperty("org_class_course.url");
            Map courseTeacherMap = this.orgCourseTeacherDao.getAllTeacherNames((Collection)courseIds);
            Map orgStudentMap = this.orgStudentCourseDao.getStudentMapBycourseIds((Collection)courseIds, null);
            for (OrgCourse course : courses) {
                CourseListReponseDto responseDto = new CourseListReponseDto();
                this.buildCourseListResponseDto(course, responseDto);
                if (needCover) {
                    responseDto.setCoverUrl(coverMap.get(course.getCover()));
                    OrgCoursePhoto orgCoursePhoto = photoMap.get(course.getId());
                    if (orgCoursePhoto != null) {
                        responseDto.setCutUrl(orgCoursePhoto.getCutUrl());
                        responseDto.setCutInfo(responseDto.getCutInfo());
                    }
                }
                if (needUrl) {
                    responseDto.setCourseUrl(url + course.getNumber());
                }
                if (needLesson) {
                    this.buildLessonCount(course, responseDto, arrangeMap, finishMap);
                }
                if (needTeacher) {
                    List teacherList = (List)courseTeacherMap.get(course.getId());
                    responseDto.setTeacherNames(StringUtils.join((Collection)teacherList, (String)","));
                    if (teacherList != null) {
                        responseDto.setTeacherCount(teacherList.size());
                    }
                }
                if (needStudent) {
                    List courseList = (List)orgStudentMap.get(course.getId());
                    Collection students = CollectorUtil.collect((Collection)courseList, (Function)new Function<OrgStudentCourse, Object>(){

                        public Object apply(OrgStudentCourse input) {
                            return input.getStudentName();
                        }
                    });
                    responseDto.setStudentNames(StringUtils.join((Collection)students, (String)","));
                    if (students != null) {
                        responseDto.setStudentCount(students.size());
                    }
                }
                if (needRoom) {
                    this.buildRoom(course, responseDto, roomMap);
                    List roomsOfCourse = (List)mapCourseRoom.get(course.getId());
                    if (CollectionUtils.isNotEmpty((Collection)roomsOfCourse)) {
                        String roomNames = "";
                        log.debug("roomsOfCourse ==={}", (Object)roomsOfCourse);
                        for (OrgCourseRoom room : roomsOfCourse) {
                            ArrayList roomNamesList = Lists.newArrayList();
                            roomNamesList.add(roomNameMap.get(room.getRoomId()));
                            roomNames = StringUtils.join((Collection)roomNamesList, (String)",");
                            if (!room.isDefault()) continue;
                            break;
                        }
                        responseDto.setRoomNames(roomNames);
                    }
                }
                if (needSms) {
                    this.buildSmsCount(course, responseDto, studentSms, teacherSms, studentView, teacherView);
                }
                responseDto.setCreateTime(course.getCreateTime());
                responseDto.setCascadeId(course.getCascadeId());
                responseDto.setAddress(course.getAddress());
                response.add(responseDto);
            }
        }
        return response;
    }

    private Map<Long, Integer> getCourseStudentMap(Map<Long, List<Long>> courseStudentMap, Long orgId) {
        HashMap result = Maps.newHashMap();
        HashSet userIds = Sets.newHashSet();
        for (Map.Entry<Long, List<Long>> entry : courseStudentMap.entrySet()) {
            List<Long> value = entry.getValue();
            userIds.addAll(value);
        }
        log.info("userIds in course ={}", (Object)userIds);
        Map userIdStudentMap = this.orgStudentDao.getUserIdStudentIdMap((Collection)userIds, orgId);
        userIds.removeAll(userIdStudentMap.keySet());
        log.info("userIds not in org course ={}", (Object)userIds);
        for (Map.Entry<Long, List<Long>> entry : courseStudentMap.entrySet()) {
            Long key = entry.getKey();
            List<Long> value = entry.getValue();
            value.removeAll(userIds);
            result.put(key, value.size());
        }
        return result;
    }
}

