/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.consult.service.impl;

import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.org.po.TXSaleClueRule;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.roster.dao.ConsultCustomSourceDao;
import com.baijia.tianxiao.dal.roster.po.ConsultCustomSource;
import com.baijia.tianxiao.sal.consult.dto.ConsultCustomSourceDto;
import com.baijia.tianxiao.sal.consult.service.ConsultSourceService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ConsultSourceServiceImpl
implements ConsultSourceService {
    private static final Logger log = LoggerFactory.getLogger(ConsultSourceServiceImpl.class);
    @Autowired
    private ConsultCustomSourceDao customSourceDao;

    @Override
    public List<ConsultCustomSourceDto> listConsultSystemSource(Boolean selection) {
        List list = MessageSource.listConsultSource((Boolean)selection);
        ArrayList<ConsultCustomSourceDto> result = new ArrayList<ConsultCustomSourceDto>();
        ConsultCustomSourceDto dto = null;
        for (MessageSource source : list) {
            dto = new ConsultCustomSourceDto();
            dto.setId(Long.parseLong(source.getValue() + ""));
            dto.setIsPaused(Flag.FALSE.getInt());
            dto.setLabel(source.getDesc());
            dto.setSystemId(source.getValue());
            result.add(dto);
        }
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public String getConsultSourceStr(Long sourceId) {
        String str = null;
        MessageSource source = MessageSource.getByType((Integer)sourceId.intValue());
        if (source != null && source.isConsultSource()) {
            str = source.getDesc();
        } else {
            ConsultCustomSource csource = (ConsultCustomSource)this.customSourceDao.getById((Serializable)sourceId, new String[0]);
            if (csource != null) {
                str = csource.getLabel();
            }
        }
        return str;
    }

    @Override
    @Transactional(readOnly=true)
    public Map<Long, ConsultCustomSourceDto> mapConsultSourceDto(Long orgId, Boolean selection) {
        HashMap<Long, ConsultCustomSourceDto> map = new HashMap<Long, ConsultCustomSourceDto>();
        List customSourcelist = this.customSourceDao.list(orgId, null);
        List<ConsultCustomSourceDto> systemSourcelist = this.listConsultSystemSource(selection);
        if (CollectionUtils.isNotEmpty((Collection)customSourcelist)) {
            for (ConsultCustomSource source : customSourcelist) {
                map.put(source.getId(), ConsultCustomSourceDto.buildBy(source));
            }
        }
        if (CollectionUtils.isNotEmpty(systemSourcelist)) {
            for (ConsultCustomSourceDto dto : systemSourcelist) {
                map.put(dto.getId(), dto);
            }
        }
        return map;
    }

    @Override
    @Transactional(readOnly=true)
    public ConsultCustomSourceDto getByLabel(Long orgId, String label) {
        List customSourcelist;
        List<ConsultCustomSourceDto> systemSourcelist = this.listConsultSystemSource(null);
        if (CollectionUtils.isNotEmpty(systemSourcelist)) {
            for (ConsultCustomSourceDto dto : systemSourcelist) {
                if (!dto.getLabel().equals(label)) continue;
                return dto;
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(customSourcelist = this.customSourceDao.list(orgId, null)))) {
            for (ConsultCustomSource source : customSourcelist) {
                if (!source.getLabel().equals(label)) continue;
                return ConsultCustomSourceDto.buildBy(source);
            }
        }
        return null;
    }

    @Override
    public boolean isSystemSource(Long sourceId) {
        MessageSource source;
        return sourceId != null && (source = MessageSource.getByType((Integer)sourceId.intValue())) != null && source.isConsultSource();
    }

    @Override
    public List<ConsultCustomSourceDto> selection(Long orgId, TXSaleClueRule rule, Integer scope, Integer isPaused) {
        List list;
        ArrayList<ConsultCustomSourceDto> dtos = new ArrayList<ConsultCustomSourceDto>();
        if (isPaused != null && !isPaused.equals(Flag.TRUE.getInt()) && !isPaused.equals(Flag.FALSE.getInt())) {
            isPaused = null;
        }
        if (scope != null && scope == 0) {
            dtos.addAll(this.listConsultSystemSource(true));
        } else if (scope != null && scope == 1) {
            list = this.customSourceDao.list(orgId, isPaused);
            for (ConsultCustomSource ccSource : list) {
                dtos.add(ConsultCustomSourceDto.buildBy(ccSource));
            }
        } else {
            list = this.customSourceDao.list(orgId, isPaused);
            for (ConsultCustomSource ccSource : list) {
                dtos.add(ConsultCustomSourceDto.buildBy(ccSource));
            }
            dtos.addAll(this.listConsultSystemSource(true));
        }
        if (CollectionUtils.isNotEmpty(dtos)) {
            LinkedHashMap<Long, ConsultCustomSourceDto> dtosMap = new LinkedHashMap<Long, ConsultCustomSourceDto>();
            for (ConsultCustomSourceDto dto : dtos) {
                dtosMap.put(dto.getId(), dto);
            }
            String sort = rule.getConsultSourceSort();
            if (StringUtils.isNotBlank((CharSequence)sort)) {
                int i = 1;
                Long sourceId = null;
                ConsultCustomSourceDto dto = null;
                for (String s : sort.split(",")) {
                    sourceId = Long.parseLong(s);
                    dto = (ConsultCustomSourceDto)dtosMap.get((long)sourceId);
                    if (dto == null || Flag.getBoolean((Integer)dto.getIsPaused())) continue;
                    dto.setSort(i);
                    ++i;
                }
            }
            this.sortConsultCustomSource(dtos);
        }
        return dtos;
    }

    void sortConsultCustomSource(List<ConsultCustomSourceDto> dtos) {
        for (ConsultCustomSourceDto dto : dtos) {
            if (dto.getSort() != null) continue;
            dto.setSort(Flag.NULL.getInt());
        }
        Comparator<ConsultCustomSourceDto> comparator = new Comparator<ConsultCustomSourceDto>(){

            @Override
            public int compare(ConsultCustomSourceDto o1, ConsultCustomSourceDto o2) {
                if (Flag.getBoolean((Integer)o1.getIsPaused()) && Flag.getBoolean((Integer)o2.getIsPaused())) {
                    if (o1.getUpdateTime().getTime() > o2.getUpdateTime().getTime()) {
                        return 1;
                    }
                    return -1;
                }
                if (Flag.getBoolean((Integer)o1.getIsPaused())) {
                    return 1;
                }
                if (Flag.getBoolean((Integer)o2.getIsPaused())) {
                    return -1;
                }
                if (o1.getSort() != null && o2.getSort() != null) {
                    if (o1.getSort().equals(o2.getSort())) {
                        return o1.getId() > o2.getId() ? -1 : 1;
                    }
                    return o1.getSort() > o2.getSort() ? 1 : -1;
                }
                if (o1.getSort() != null) {
                    return 1;
                }
                if (o2.getSort() != null) {
                    return -1;
                }
                return o1.getId() > o2.getId() ? -1 : 1;
            }
        };
        Collections.sort(dtos, comparator);
    }
}

