
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.common.impl;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentKexiaoRecordDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dto.KexiaoStatisticss;
import com.baijia.tianxiao.dal.org.dto.StudentClasHourDocument;
import com.baijia.tianxiao.dal.org.dto.StudentClassHourStatusDocument;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupRefundDao;
import com.baijia.tianxiao.dal.signup.dto.OrgStudentSignupStatistics;
import com.baijia.tianxiao.dal.solr.po.StudentClass;
import com.baijia.tianxiao.dal.solr.po.StudentClassHour;
import com.baijia.tianxiao.enums.StudentCourseStatus;
import com.baijia.tianxiao.sal.common.api.StudentKexiaoStatisticsApiService;
import com.baijia.tianxiao.sal.common.dto.KexiaoStatisticsSuper;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

import lombok.extern.slf4j.Slf4j;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Dec 26, 2016
 * @Desc this guy is too lazy, nothing left.
 */
@Service
@Slf4j
public class StudentKexiaoStatisticsApiServiceImpl implements StudentKexiaoStatisticsApiService {

    @Autowired
    private OrgStudentKexiaoRecordDao orgStudentKexiaoRecordDao;
    @Autowired
    private OrgSignupCourseDao orgSignupCourseDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private OrgStudentLessonDao orgStudentLessonDao;
    @Autowired
    private OrgStudentCourseDao orgStudentCourseDao;
    @Autowired
    private OrgSignupRefundDao orgSignupRefundDao;

    public List<KexiaoStatisticss> lessonKexiaoStatistics() {

        return null;
    }

    @Override
    public List<KexiaoStatisticsSuper> fillCurrentCourseInfo(Long orgId, Long userId, Collection<Long> orgCourseIds) {
        if (GenericsUtils.isNullOrEmpty(orgCourseIds) || userId == null) {
            return GenericsUtils.emptyList();
        }
        List<KexiaoStatisticsSuper> retKexiaoList = fillInfosForCourse(orgId, userId, orgCourseIds);
        Iterator<KexiaoStatisticsSuper> iter = retKexiaoList.iterator();
        while (iter.hasNext()) {
            KexiaoStatisticsSuper next = iter.next();
            if (next.getOrgStudentCourseStatus() == StudentCourseStatus.NORMAL.getCode()) {
                Integer leftClassTimesForKexiaoValue = next.getLeftClassTimesForKexiaoValue();
                Integer totalClassTimesForKexiaoValue = next.getTotalClassTimesForKexiaoValue();
                if (leftClassTimesForKexiaoValue != null && totalClassTimesForKexiaoValue != null) {
                    if ((leftClassTimesForKexiaoValue <= 0 && totalClassTimesForKexiaoValue != 0)) {
                        iter.remove();
                    }
                }
            } else {
                iter.remove();
            }
        }
        return retKexiaoList;
    }

    /**
     * @param orgId
     * @param userId
     * @param orgCourseIds
     * @return
     */

    private List<KexiaoStatisticsSuper> fillInfosForCourse(Long orgId, Long userId, Collection<Long> orgCourseIds) {
        List<KexiaoStatisticsSuper> retKexiaoList = Lists.newArrayListWithCapacity(orgCourseIds.size());
        for (Long courseId : orgCourseIds) {
            KexiaoStatisticsSuper kss = KexiaoStatisticsSuper.newInstanceWithUserId();
            kss.setUserId(userId);
            kss.setCourseId(courseId);
            retKexiaoList.add(kss);
        }
        this.fillStudentKeXiaoStatistics(orgId, retKexiaoList, 2);
        return retKexiaoList;
    }

    /**
     * @param orgId
     * @param studentRequest
     * @param fillInfoType :填充何种数据<br/>
     *            1:填充剩余学费 <br/>
     *            2:填充已上课次/总课次(课时) <br/>
     *            3:填充已上课次/购买课次(课时) <br/>
     *            =======----> 2,3只针对某个学员某门课程而言才有意义
     * @return
     */
    @Override
    public void fillStudentKeXiaoStatistics(Long orgId, Collection<? extends KexiaoStatisticsSuper> studentRequest,
        Integer fillInfoType) {

        try {
            if (GenericsUtils.isNullOrEmpty(studentRequest)) {
                return;
            }
            // 剩余学费
            // 已上课次(课时)/总课次(课时)
            // 已上课次(课时)/已购课次(课时)
            log.debug("studnetRequest are :{} ", studentRequest);

            Set<Long> courseIds = Sets.newHashSet();
            Set<Long> setCourseIds = Sets.newHashSet(); // 调动端指定的学员班级ids
            Set<Long> userIds = Sets.newHashSet();
            Map<Long, Long> one2OneCourseIdMap = Maps.newHashMap();
            for (KexiaoStatisticsSuper oss : studentRequest) {
                if (fillInfoType != 1) {
                    courseIds.add(oss.getCourseId());
                    if (oss.getParentCourseId() != null && oss.getParentCourseId() != 0) {
                        courseIds.add(oss.getParentCourseId());
                        one2OneCourseIdMap.put(oss.getCourseId(), oss.getParentCourseId());
                    }
                }
                userIds.add(oss.getUserId());
            }
            setCourseIds.addAll(courseIds);

            // log.info("userIds are :{} ", userIds);
            // log.info("courseIds are:{} ", courseIds);

            List<StudentClasHourDocument> list = this.searchStudentClasHourDocuments(userIds, orgId);
            // 获取所有课程的1:排课总次数/排课总时长 2.课消总时长/已上课次 key:#{userId_courseId}
            Map<String, StudentClassHour> studentClassHourMapSecond = buildStudentClassHourInfo(list);

            List<StudentClassHourStatusDocument> scsdl = this.searchStudentClassHourStatusDocuments(userIds, orgId);
            Map<Long, StudentClassHourStatusDocument> studentClassHourStatusDocumentMap =
                GenericsUtils.toFieldMap(scsdl, "userId");
            // 获取所有课程的1:课程报课状态 2:合同购买次数
            Map<String, StudentClass> studentCourseMap = this.buildStudentClassStatusInfo(scsdl);
            if (GenericsUtils.isNullOrEmpty(studentCourseMap)) {
                studentCourseMap = Maps.newHashMap();
            }
            for (StudentClass st : studentCourseMap.values()) {
                courseIds.add(st.getCourseId());
            }
            if (GenericsUtils.notNullAndEmpty(setCourseIds)) {
                courseIds.retainAll(setCourseIds); // 只获取指定部分班级
            }
            List<OrgCourse> courses = orgCourseDao.getByIds(courseIds);

            // 获取所有课程的信息
            Map<Long, OrgCourse> coursesMap = Maps.newHashMap();
            for (OrgCourse oc : courses) {
                coursesMap.put(oc.getId(), oc);
                if (oc.getParentId() != null && oc.getParentId() != 0) {
                    courseIds.add(oc.getParentId());
                    one2OneCourseIdMap.put(oc.getId(), oc.getParentId());
                }
            }

            // 综合数据进行课时统计准备
            Map<String, StudentClassHour> studentClassHourMap =
                findStudentClassHours(studentClassHourMapSecond, studentCourseMap, coursesMap);

            // log.info("studentClassHourMap is :{} ", studentClassHourMap);

            // 获取课程的课消金额
            List<KexiaoStatisticss> findKexiaoStatistics =
                orgStudentKexiaoRecordDao.findKexiaoStatistics(orgId, userIds, courseIds);
            // log.info(" findKexiaoStatistics are :{} ", findKexiaoStatistics);
            // 获取报名课程的统计数据 购买总金额
            List<OrgStudentSignupStatistics> findAllOrgStudentSigupStatistics =
                this.orgSignupCourseDao.findAllOrgStudentSignupStatistics(orgId, userIds, courseIds);
            // log.debug("findAllOrgStudentSigupStatistics are :{} ", findAllOrgStudentSigupStatistics);

            Map<String, Long> sumRefundMoney = this.orgSignupRefundDao.sumRefundMoney(orgId, courseIds, userIds);
            // log.debug("sumRefundMoney are:{} ", sumRefundMoney);

            Map<Long, List<OrgStudentSignupStatistics>> orgStudentSigupStatisticsMap = Maps.newHashMap();
            Set<Long> needShowTipInfo = Sets.newHashSet();
            if (GenericsUtils.notNullAndEmpty(findAllOrgStudentSigupStatistics)) {
                Iterator<OrgStudentSignupStatistics> iter = findAllOrgStudentSigupStatistics.iterator();
                while (iter.hasNext()) {
                    OrgStudentSignupStatistics next = iter.next();
                    if (!next.isInfoFillOver()) { // 如果都补充完了,chargeUnit = count(if(charge_unit=-1 or (charge_unit = 1
                        // and status = -1),1,null)) as
                        // chargeUnitStatus 之后会是0,否则会大于1
                        needShowTipInfo.add(next.getUserId());
                    }
                    long userId = next.getUserId();
                    long courseId = next.getCourseId();
                    String key = createKey(userId, courseId);
                    Long refundMoney = null;
                    if ((refundMoney = sumRefundMoney.get(key)) != null) {
                        Long retMoney = next.getPayMoney() - refundMoney;
                        next.setPayMoney(retMoney < 0 ? 0 : retMoney);
                    }
                }
                orgStudentSigupStatisticsMap = GenericsUtils.toFieldListMap(findAllOrgStudentSigupStatistics, "userId");
            }
            // log.debug("needShowTipInfo is:{} ", needShowTipInfo);

            Map<Long, List<KexiaoStatisticss>> kexiaoStaisticsMap = Maps.newHashMap();
            if (GenericsUtils.notNullAndEmpty(findKexiaoStatistics)) {
                kexiaoStaisticsMap = GenericsUtils.toFieldListMap(findKexiaoStatistics, "userId");
            }

            // log.debug("orgStudentSigupStatisticsMap is:{} and kexiaoStaisticsMap :{} ", orgStudentSigupStatisticsMap,
            // kexiaoStaisticsMap);

            for (KexiaoStatisticsSuper oss : studentRequest) {
                Long userId = oss.getUserId();
                boolean hasStudentCourse = true;
                if (fillInfoType == 1) {
                    StudentClassHourStatusDocument studentClassHourStatusDocument = null;
                    studentClassHourStatusDocument = studentClassHourStatusDocumentMap.get(userId);
                    hasStudentCourse = studentClassHourStatusDocument != null;
                }
                List<OrgStudentSignupStatistics> ossSignupInfo = orgStudentSigupStatisticsMap.get(userId);
                List<KexiaoStatisticss> ossKexiaoInfo = kexiaoStaisticsMap.get(userId);
                // log.debug("for oss:{} hasStudentCourse:{} and ossSignupInfo is :{} and ossKexiaoInfo is :{} ",
                // userId,
                // hasStudentCourse, ossSignupInfo, ossKexiaoInfo);
                if (hasStudentCourse && needShowTipInfo.contains(userId)) {
                    oss.setKexiaoInfoFillStatus(0);
                }
                if (!hasStudentCourse || (hasStudentCourse && GenericsUtils.isNullOrEmpty(ossSignupInfo))) {
                    oss.setCanShowTotalKexiaoInfo(true);
                }
                countKexiaoStatistics(oss, courseIds, one2OneCourseIdMap, studentClassHourMap, ossSignupInfo,
                    ossKexiaoInfo, fillInfoType);
                // oss.setHasLesson(hasStudentCourse);
            }
        } catch (Exception e) {
            log.error("exception is : {} ", e);
        }
    }

    /**
     * @param userId
     * @param courseId
     * @return
     */

    private String createKey(long userId, long courseId) {
        String key = String.format("%s_%s", userId, courseId);
        return key;
    }

    /**
     * @param list
     */
    private Map<String, StudentClassHour> buildStudentClassHourInfo(List<StudentClasHourDocument> list) {
        Map<String, StudentClassHour> studentClassHourMapSecond = Maps.newHashMap();
        for (StudentClasHourDocument document : list) {
            StudentClassHour classHour = buildStudentClassHour(document);
            Long userId = classHour.getUserId();
            Long courseId = classHour.getCourseId();
            String key = userId + "_" + courseId;
            studentClassHourMapSecond.put(key, classHour);
        }
        return studentClassHourMapSecond;
    }

    /**
     * @param userIds
     * @param orgId
     * @return
     */
    private List<StudentClasHourDocument> searchStudentClasHourDocuments(Set<Long> userIds, Long orgId) {
        if (GenericsUtils.isNullOrEmpty(userIds)) {
            return GenericsUtils.emptyList();
        }
        List<StudentClasHourDocument> ret = this.orgStudentLessonDao.queryStudentClassHours(userIds, orgId);
        return ret;
    }

    /**
     * @param orgId
     * @return
     */
    private List<StudentClassHourStatusDocument> searchStudentClassHourStatusDocuments(Set<Long> studentIds,
        Long orgId) {
        if (GenericsUtils.isNullOrEmpty(studentIds)) {
            return GenericsUtils.emptyList();
        }
        return this.orgStudentCourseDao.searchStudentClassHourStatus(studentIds, orgId);
    }

    /**
     * @param studentClassHourStatusDocumentLists
     * @return
     */
    private Map<String, StudentClass> buildStudentClassStatusInfo(
        List<StudentClassHourStatusDocument> studentClassHourStatusDocumentLists) {
        Map<String, StudentClass> statusMap = Maps.newHashMap();
        Iterator<StudentClassHourStatusDocument> iterator = studentClassHourStatusDocumentLists.iterator();
        while (iterator.hasNext()) {
            StudentClassHourStatusDocument next = iterator.next();
            Long userId = next.getUserId();
            Long courseId = next.getCourseId();
            Integer lessonCount = next.getLessonCount();
            StudentClass studentClass = new StudentClass();
            String key = userId + "_" + courseId;
            Integer status = next.getStatus();
            studentClass.setStatus(status);
            studentClass.setContractCount(lessonCount == null ? 0 : lessonCount);
            studentClass.setUserId(userId);
            studentClass.setCourseId(courseId);
            statusMap.put(key, studentClass);
        }
        log.debug("statusMap is :{}", statusMap);
        return statusMap;
    }

    /**
     * @param oss
     * @param courseIdsSuper
     * @param one2OneCourseIdMap
     * @param studentClassHourMap
     * @param ossSignupInfo
     * @param ossKexiaoInfo
     * @param fillInfoType
     */
    private void countKexiaoStatistics(KexiaoStatisticsSuper oss, Set<Long> courseIdsSuper,
        Map<Long, Long> one2OneCourseIdMap, Map<String, StudentClassHour> studentClassHourMap,
        List<OrgStudentSignupStatistics> ossSignupInfo, List<KexiaoStatisticss> ossKexiaoInfo, Integer fillInfoType) {
        Map<Long, OrgStudentSignupStatistics> signupStatisticsMap = GenericsUtils.toFieldMap(ossSignupInfo, "courseId");
        Map<Long, KexiaoStatisticss> kexiaoStatisticssMap = GenericsUtils.toFieldMap(ossKexiaoInfo, "courseId");
        Set<Long> courseIds = Sets.newHashSet();
        boolean singleCourse = false;
        if (oss.getCourseId() != null) {
            courseIds.add(oss.getCourseId());
            singleCourse = true;
        } else {
            courseIds.addAll(courseIdsSuper);
            if (GenericsUtils.notNullAndEmpty(one2OneCourseIdMap)) {
                courseIds.addAll(one2OneCourseIdMap.keySet());
                courseIds.removeAll(one2OneCourseIdMap.values());
            }
        }
        // log.debug("allCourseIds are:{} ", courseIds);
        // log.debug("one2OneCourseIdMap are:{} ", one2OneCourseIdMap);
        Long remainTuition = null;
        for (Long courseId : courseIds) {
            boolean canSetInfo = true;
            String key = String.format("%s_%s", oss.getUserId(), courseId);
            StudentClassHour sch = studentClassHourMap.get(key);
            // log.debug("with key :{} and StudentClassHour is:{} ", key, sch);
            if (sch == null) {
                continue;
            }
            if (sch.isArrange()) {
                oss.setHasLesson(true);
            }
            int status = sch.getStatus();
            OrgStudentSignupStatistics orgStudentSigupStatistics = null;
            KexiaoStatisticss kexiaoStatisticss = null;
            if (one2OneCourseIdMap.containsKey(courseId)) {
                Long parentCourseId = one2OneCourseIdMap.get(courseId);
                orgStudentSigupStatistics = signupStatisticsMap.get(parentCourseId);
                kexiaoStatisticss = kexiaoStatisticssMap.get(parentCourseId);
            } else {
                orgStudentSigupStatistics = signupStatisticsMap.get(courseId);
                kexiaoStatisticss = kexiaoStatisticssMap.get(courseId);
            }

            Long signupMoney = null;
            if (orgStudentSigupStatistics != null) {
                if (!orgStudentSigupStatistics.isInfoFillOver()) {
                    canSetInfo = false;
                } else {
                    signupMoney = orgStudentSigupStatistics.getPayMoney();
                }
            } else {
                oss.setHasSignupCourseRecord(false);
            }
            if (canSetInfo) {
                oss.setCanShowTotalKexiaoInfo(true); // 且具有信息补充完整班级的情况下,允许展示剩余学费.
            }
            if (fillInfoType == 1) {
                if (status != StudentCourseStatus.NORMAL.getCode()) {
                    log.info("current course was not a inStudying course , so will skip :{} ", courseId);
                    continue;
                }
            }
            oss.setCurrentCourseCanSetInfo(canSetInfo);
            Long kexiaoMoney = 0L;
            if (canSetInfo) {
                oss.setCanShowTotalKexiaoInfo(true);
                if (signupMoney != null) {
                    if (status == StudentCourseStatus.NORMAL.getCode()) {
                        if (kexiaoStatisticss != null && kexiaoStatisticss.getKexiaoMoney() != null) {
                            kexiaoMoney = kexiaoStatisticss.getKexiaoMoney();
                        }
                    } else {
                        kexiaoMoney = signupMoney;
                    }
                } else {
                    signupMoney = 0L;
                }
                remainTuition = (remainTuition == null ? 0L : remainTuition);
                remainTuition += (signupMoney - kexiaoMoney);
            }
            // log.debug("singleCourse is:{} ", singleCourse);
            if (singleCourse) {
                oss.setOrgStudentCourseStatus(status);
                setClassHourInfos(oss, sch, canSetInfo, fillInfoType);
            }
        }
        if (remainTuition != null) {
            oss.setRemainTuition(countRemainTuition(remainTuition));
            oss.setRemainTuitionValue(remainTuition);
        }
    }

    /**
     * @param fillInfoType
     */
    private void setClassHourInfos(KexiaoStatisticsSuper oss, StudentClassHour dto, boolean canSetInfo,
        Integer fillInfoType) {
        Integer totalCount = dto.getTotalCount(); // 总排的课次
        Integer finishCount = dto.getFinishCount(); // 已完成的课次
        Integer buyCount = dto.getContractCount(); // 总购买次数
        oss.setBuyCount(buyCount == null ? 0 : buyCount);
        Long totalArrangeClassHour = dto.getTotalClassHour(); // 总排课时长
        Long totalKexiaoClassHour = dto.getTotalKexiaoClassHour();
        Integer leftCount = totalCount - finishCount;
        if (fillInfoType == 3) {
            totalCount = buyCount;
        }
        oss.setChargeUnitType(dto.getChargeUnit());
        if (dto.getChargeUnit() == ChargeUnit.BY_HALF_HOUR.getCode()
            || dto.getChargeUnit() == ChargeUnit.BY_HOUR.getCode()
            || dto.getChargeUnit() == ChargeUnit.BY_MINUTE.getCode()) {
            long countClassHour = buyCount == null ? 0 : buyCount;
            if (totalArrangeClassHour == null || totalArrangeClassHour == 0 || totalArrangeClassHour < countClassHour) {
                totalArrangeClassHour = countClassHour;
            }
            if (totalKexiaoClassHour == null) {
                oss.setFinishClassTimesForKexiao("0");
                oss.setFinishClassTimesForKexiaoValue(0);
            } else {
                oss.setFinishClassTimesForKexiao(countTime(totalKexiaoClassHour));
                oss.setFinishClassTimesForKexiaoValue(totalKexiaoClassHour.intValue());
            }
            leftCount = (int) (totalArrangeClassHour - oss.getFinishClassTimesForKexiaoValue());
            // log.debug("totalArrangeClassHour is:{} ,countClassHour is :{} ,leftCount is:{} ", totalArrangeClassHour,
            // countClassHour, leftCount);
            oss.setTotalClassTimesForKexiaoValue(
                fillInfoType == 3 ? (int) countClassHour : totalArrangeClassHour.intValue());
            oss.setLeftClassTimesForKexiaoValue(leftCount);
            if (canSetInfo) {
                oss.setTotalClassTimesForKexiao(countTime(oss.getTotalClassTimesForKexiaoValue().longValue()));
                oss.setLeftClassTimesForKexiao(countTime(leftCount.longValue()));
            } else {
                oss.setTotalClassTimesForKexiao("--");
                oss.setLeftClassTimesForKexiao("--");
            }
        } else {
            oss.setFinishClassTimesForKexiao(String.valueOf(finishCount));
            oss.setFinishClassTimesForKexiaoValue(finishCount);
            oss.setTotalClassTimesForKexiaoValue(totalCount);
            oss.setLeftClassTimesForKexiaoValue(leftCount);
            if (canSetInfo) {
                oss.setTotalClassTimesForKexiao(String.valueOf(totalCount));
                oss.setLeftClassTimesForKexiao(String.valueOf((leftCount)));
            } else {
                oss.setTotalClassTimesForKexiao("--");
                oss.setLeftClassTimesForKexiao("--");
            }
        }
    }

    public static void main(String[] args) {
        String countTime = countTime(2L);
        System.out.println(countTime);
    }

    public static String countTime(Long time) {
        BigDecimal b1 = new BigDecimal(time);
        BigDecimal b2 = new BigDecimal(60);
        return b1.divide(b2, 1, BigDecimal.ROUND_HALF_UP).toPlainString();
    }

    public static String countRemainTuition(Long remainTuition) {
        BigDecimal b1 = new BigDecimal(remainTuition);
        BigDecimal b2 = new BigDecimal(100);
        return b1.divide(b2, 2, BigDecimal.ROUND_HALF_UP).toPlainString();
    }

    public static long countClassHour(int count, int chargeUnit) {
        // if (chargeUnit == ChargeUnit.BY_HALF_HOUR.getCode()) {
        // return count * 30;
        // } else if (chargeUnit == ChargeUnit.BY_HOUR.getCode()) {
        // return count * 60;
        // }
        return count;
    }

    /**
     * @param coursesMap
     * @param orgId
     * @param userIds
     * @return
     */
    public Map<String, StudentClassHour> findStudentClassHours(Map<String, StudentClassHour> map,
        Map<String, StudentClass> statusMap, Map<Long, OrgCourse> coursesMap) {
        for (Map.Entry<String, StudentClass> entry : statusMap.entrySet()) {
            String key = entry.getKey();
            StudentClass sc = entry.getValue();
            Long courseId = sc.getCourseId();
            StudentClassHour sch = map.get(key);
            if (sch == null) {
                sch = new StudentClassHour();
                sch.setTotalCount(sc.getContractCount());
                sch.setLeftCount(sc.getContractCount());
                sch.setFinishCount(0);
                sch.setArrange(false);
            } else {
                if (sc.getStatus() != StudentCourseStatus.NORMAL.getCode()) {
                    sch.setTotalCount(sch.getFinishCount());
                } else {
                    sch.setTotalCount(Math.max(sc.getContractCount(), sch.getTotalCount()));
                }
            }
            sch.setStatus(sc.getStatus());
            sch.setContractCount(sc.getContractCount());
            OrgCourse courseInfo = coursesMap.get(courseId);
            if (courseInfo != null) {
                sch.setChargeType(courseInfo.getChargeType());
                sch.setChargeUnit(courseInfo.getChargeUnit());
            }

            map.put(key, sch);
        }
        return map;
    }

    private StudentClassHour buildStudentClassHour(StudentClasHourDocument document) {
        Long studentId = document.getUserId();
        Long courseId = document.getCourseId();
        Long totalCount = document.getTotal();
        Long finishCount = document.getFinished();
        Long totalClassHourMinute = document.getTotalArrangeTime();
        Long totalKexiaoTime = document.getKexiaoTime();
        totalCount = (totalCount == null ? 0L : totalCount);
        finishCount = (finishCount == null ? 0L : finishCount);
        StudentClassHour classHour = new StudentClassHour();
        classHour.setUserId(studentId);
        classHour.setCourseId(courseId);
        classHour.setFinishCount(finishCount.intValue());
        classHour.setTotalCount(totalCount.intValue());
        classHour.setTotalClassHour(totalClassHourMinute);
        classHour.setTotalKexiaoClassHour(totalKexiaoTime);
        return classHour;
    }

}
