package com.baijia.tianxiao.sal.common.impl;

import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.finance.po.TxTransferClassRecord;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourseLesson;
import com.baijia.tianxiao.dal.signup.po.OrgSignupRefund;
import com.baijia.tianxiao.sal.common.dto.kexiao.KexiaoStatistics;
import com.baijia.tianxiao.sal.common.utils.KexiaoUtil;

/**
 * Created by lxp on 2017/5/15.
 */
public class KexiaoStatisticsBuilder {
    private OrgSignupCourse signupCourse;
    private OrgSignupCourseLesson arrangedNormalLesson;
    private OrgSignupCourseLesson arrangedFreeLesson;
    private OrgSignupCourseLesson kexiaoNormalLesson;
    private OrgSignupCourseLesson kexiaoFreeLesson;
    private TxTransferClassRecord transferRecord;
    private OrgSignupRefund refundRecord;

    private KexiaoStatistics stat;

    public KexiaoStatisticsBuilder() {

    }

    public KexiaoStatisticsBuilder(KexiaoStatistics stat) {
        this.stat = stat;
    }

    public KexiaoStatisticsBuilder addSignupCourse(OrgSignupCourse signupCourse){
        this.signupCourse = signupCourse;
        return this;
    }

    public KexiaoStatisticsBuilder addArrangedNormalLesson(OrgSignupCourseLesson arrangedNormalLesson){
        this.arrangedNormalLesson = arrangedNormalLesson;
        return this;
    }

    public KexiaoStatisticsBuilder addArrangedFreeLesson(OrgSignupCourseLesson arrangedFreeLesson){
        this.arrangedFreeLesson = arrangedFreeLesson;
        return this;
    }

    public KexiaoStatisticsBuilder addKexiaoNormalLesson(OrgSignupCourseLesson kexiaoNormalLesson){
        this.kexiaoNormalLesson = kexiaoNormalLesson;
        return this;
    }

    public KexiaoStatisticsBuilder addKexiaoFreeLesson(OrgSignupCourseLesson freeLesson){
        this.kexiaoFreeLesson = freeLesson;
        return this;
    }

    public KexiaoStatisticsBuilder addRefundRecord(OrgSignupRefund refundRecord){
        this.refundRecord = refundRecord;
        return this;
    }

    public KexiaoStatisticsBuilder addTransferRecord(TxTransferClassRecord transferRecord){
        this.transferRecord = transferRecord;
        return this;
    }

    public KexiaoStatistics build(){
        stat.setChargeUnit(signupCourse.getChargeUnit());
        stat.setContractNumber(KexiaoUtil.getClassNumber(signupCourse));
        stat.setContractAmount(signupCourse.getTotalPayPrice());
        stat.setClassId(signupCourse.getClassId());

        if (signupCourse.getLessonCount() > 0) {//所有订单都未补充的时候才表示不显示
            stat.setCompleteStatus(0);
        }

        if (arrangedNormalLesson != null) {
            if (ChargeUnit.isByTime(signupCourse.getChargeUnit())) {
                stat.setArrangeNormalNumber(arrangedNormalLesson.getLessonDuration());
            } else {
                stat.setArrangeNormalNumber(arrangedNormalLesson.getLessonCount());
            }
            stat.setArrangeNormalAmount(arrangedNormalLesson.getAmount());
        }

        if (arrangedFreeLesson != null) {
            if (ChargeUnit.isByTime(signupCourse.getChargeUnit())) {
                stat.setArrangeFreeNumber(arrangedFreeLesson.getLessonDuration());
            } else {
                stat.setArrangeFreeNumber(arrangedFreeLesson.getLessonCount());
            }
        }

        if (kexiaoNormalLesson != null) {
            if (ChargeUnit.isByTime(signupCourse.getChargeUnit())) {
                stat.setKexiaoNormalNumber(kexiaoNormalLesson.getLessonDuration());
            } else {
                stat.setKexiaoNormalNumber(kexiaoNormalLesson.getLessonCount());
            }
            stat.setKexiaoNormalAmount(kexiaoNormalLesson.getAmount());
        }

        if (kexiaoFreeLesson != null) {
            if (ChargeUnit.isByTime(signupCourse.getChargeUnit())) {
                stat.setKexiaoFreeNumber(kexiaoFreeLesson.getLessonDuration());
            } else {
                stat.setKexiaoFreeNumber(kexiaoFreeLesson.getLessonCount());
            }
        }

        if (transferRecord != null) {
            stat.setTransferAmount(transferRecord.getLessonMoney());
            stat.setTransferNormalNumber(transferRecord.getRealLessonCount());
            stat.setTransferFreeNumber(transferRecord.getFreeLessonCount());
        }

        if (refundRecord != null) {
            stat.setRefundAmount(refundRecord.getRefundFee() + refundRecord.getRefundFee());
            stat.setRefundNormalNumber(refundRecord.getRefundLessonCount().intValue());
        }
        return stat;
    }
}