package com.baijia.tianxiao.sal.common.impl;

import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

import javax.annotation.Resource;

import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constants.sms.SmsSendResult;
import com.baijia.tianxiao.constants.sms.TxSmsCodeType;
import com.baijia.tianxiao.dal.msg.dao.TxSmsDao;
import com.baijia.tianxiao.dal.msg.po.TxSms;
import com.baijia.tianxiao.dal.org.constant.TXAccountStatus;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.sal.common.api.CommonMsgService;
import com.baijia.tianxiao.sal.common.dto.msg.SendMsgRequest;
import com.baijia.tianxiao.util.SmsContentHelper;
import com.baijia.tianxiao.util.SmsSendUtil;
import com.baijia.tianxiao.validation.ParamValidateUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.common.service.WechatMsgRenderService;
import com.baijia.tianxiao.constants.sms.SmsMessageType;
import com.baijia.tianxiao.exception.MsgSendException;
import com.google.common.base.Preconditions;

import lombok.extern.slf4j.Slf4j;

/**
 * @author cxm
 * @version 1.0
 * @title MsgSendServiceImpl
 * @desc TODO
 * @date 2016年3月21日
 */
@Service
@Slf4j
public class CommonMsgServiceImpl implements CommonMsgService {

    @Autowired(required = false)
    private WechatMsgRenderService wechatMsgSenderService;

    @Resource
    private TxSmsDao txSmsDao;

    @Autowired
    private TXAccountDao txAccountDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;


    final ExecutorService exec = Executors.newFixedThreadPool(5);

    @Override
    public boolean sendMsg(final SendMsgRequest request) throws MsgSendException {
        log.info("try to send msg by request1:{}", request);
        Preconditions.checkNotNull(request);
        Preconditions.checkArgument(request.getSenderId() != null, "sender id is null");
        Preconditions.checkArgument(request.getReceiverId() != null, "receiver id is null");
        Preconditions.checkArgument(request.getOrgId() != null, "orgId id is null");

        Preconditions.checkArgument(request.getSenderRole() != null, "senderRole id is null");
        Preconditions.checkArgument(request.getReceiverRole() != null, "receiverRole id is null");
        boolean sendResult = false;
        if (StringUtils.isNoneBlank(request.getWeixinOpenId()) && request.getWechatTemplateId() != null) {
            log.info("try to send msg by wechat:{}", request.getWechatParams());
            try {
                request.getWechatParams().put("touser", request.getWeixinOpenId());
                Callable<Boolean> call = new Callable<Boolean>() {
                    @Override
                    public Boolean call() throws Exception {
                        return wechatMsgSenderService.sendMsg(request.getOrgId(),
                                wechatMsgSenderService.render(request.getWechatTemplateId(), request.getWechatParams()));
                    }
                };
                Future<Boolean> future = exec.submit(call);
                sendResult = future.get(20000, TimeUnit.MILLISECONDS); // 设置超时时间,超过这个时间任务返回
                // MARK:微信重刷token的时候经常会发生TCP握手等待,可能微信那边backlog值有点小,阻塞的情况下会导致签到的定时任务(使用SPRING
                // CRONTAB)级联阻塞.
                log.info("send msg result:{} by wechat:{}", sendResult, request.getWechatParams());
                if (sendResult) {
                    return true;
                }
            } catch (Exception e) {
                log.warn("", e);
                log.warn("send by wechat catch error,receiver id is:{},error is:{} ", request.getReceiverId(), e);
            }
        }
        if (!sendResult && StringUtils.isNoneBlank(request.getSmsContent())
                && StringUtils.isNoneBlank(request.getMobile())) {
            log.info("try to send msg by sms requet={},mobile:{},content:{}", request, request.getMobile(), request.getSmsContent());

            sendResult = sendTxSms(request.getSenderId(), request.getSenderId(), request.getSenderRole().getCode(),
                    request.getReceiverId(), request.getReceiverRole().getCode(), request.getSmsCodeType(), request.getSendSmsKey(), request.getMobile(),
                    request.getSmsContent());
            log.info("send sms msg receiver id is:{},result:{}", request.getReceiverId(), sendResult);
        }

        return sendResult;
    }

    @Override
    public boolean sendTxSms(Long orgId, Long sender, Integer senderRole, Long receiver, Integer receiverRole, TxSmsCodeType smsCodeType, Long sendSmsKey, String mobile, String smsContent) {
        if (!ParamValidateUtils.validateMobile(mobile) || StringUtils.isBlank(smsContent)) {
            log.warn("send sms error,mobile:{},content:{}", mobile, smsContent);
            return false;
        }
        sender = sender == null ? 0 : sender;
        senderRole = senderRole == null ? 0 : senderRole;
        receiver = receiver == null ? 0 : receiver;
        receiverRole = receiverRole == null ? 0 : receiverRole;


        TxSms sms = new TxSms();
        sms.setOrgId(orgId);
        sms.setCreateTime(new Date());
        sms.setMessageType(SmsMessageType.TIANXIAO_NOTIFY.getCode());
        sms.setMobile(mobile);
        sms.setReceiverId(receiver);
        sms.setReceiverRole(receiverRole);
        sms.setSenderId(sender);
        sms.setSenderRole(senderRole);
        sms.setContent(smsContent);
        sms.setSmsCode(smsCodeType.getCode());
        sms.setSendSmsKey(sendSmsKey == null ? 0 : sendSmsKey);
        sms.setSmsCount(SmsContentHelper.countChargeSmsNum(smsContent, SmsContentHelper.DEFAULT_SMS_SIGN_CONTENT));

        boolean sendResult = false;
        try {
            sendResult = SmsSendUtil.sendTxSms(mobile, smsContent,
                    sender.intValue(), UserRole.ORGANIZATION.getRole(), getTxAccountSmsGate(sender.intValue()));
            sms.setSendResult(sendResult ? SmsSendResult.SUCCESS.getValue() : SmsSendResult.FAILED.getValue());
            txSmsDao.save(sms);
            return sendResult;
        } catch (Exception e) {
            log.warn("save sms record catch error:", e);
            return false;
        }
    }

    private TXAccount getTXAccountByOrgId(Integer orgId) {
        OrgSubAccount subAcc = orgSubAccountDao.getByOrgId(orgId);
        if (subAcc==null){
            return null;
        }
        TXAccount superAcc = null;
        if (0 == subAcc.getPid()) {// 先找到天校账号
            superAcc = txAccountDao.getByOrgId(orgId, TXAccountStatus.VALID.getCode());
        } else {
            // 根据父校区orgId来查询txAccount;
            superAcc = txAccountDao.getByOrgId(subAcc.getPid(), TXAccountStatus.VALID.getCode());
        }
        return superAcc;
    }

    private Integer getTxAccountSmsGate(Integer orgId) {
        TXAccount txAccount = getTXAccountByOrgId(orgId.intValue());
        if (txAccount == null) {
            return SmsSendUtil.DEFAULT_SMS_GATE;// 默认短信后缀网关
        }
        return txAccount.getSmsGate();
    }
}
