
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2017 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.common.dto.wechatMsgRequest;

import java.util.Date;

import com.baijia.tianxiao.constants.sms.TxWechatTemplateMsgType;
import com.baijia.tianxiao.sal.common.dto.WechatMsgTypeSuper;
import com.baijia.tianxiao.util.date.DateUtil;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time May 19, 2017
 * @Desc this guy is too lazy, nothing left.
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class AfterCourseCommentNotifyMsg extends WechatMsgTypeSuper {

    private String studentName;
    private String teacherName;
    private String courseName;
    private long courseTime;
    private String commentUrl;

    @Override
    public TxWechatTemplateMsgType getType() {
        return TxWechatTemplateMsgType.AFTER_COURSE_COMMENT_NOTIFY_WECHAT_TEMPLATE;
    }

    /**
     * @return
     */
    public String getCourseTimeStr() {
        return DateUtil.getStrByDateFormate(new Date(this.courseTime), "MM月dd日");
    }

    /**
     * @param name
     * @param teacherName2
     * @param name2
     * @param startTime
     * @param url
     * @return
     */
    public static AfterCourseCommentNotifyMsg newInstance(String name, String teacherName, String courseName,
        long courseTime, String url) {
        AfterCourseCommentNotifyMsg msg = new AfterCourseCommentNotifyMsg();
        msg.setCommentUrl(url);
        msg.setCourseName(courseName);
        msg.setCourseTime(courseTime);
        msg.setStudentName(name);
        msg.setTeacherName(teacherName);
        return msg;
    }

}
