
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2017 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.common.dto.wechatMsgRequest;

import com.baijia.tianxiao.constants.sms.TxWechatTemplateMsgType;
import com.baijia.tianxiao.sal.common.dto.WechatMsgTypeSuper;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time May 19, 2017
 * @Desc this guy is too lazy, nothing left.
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class AfterCourseCommentMsg extends WechatMsgTypeSuper {

    private String studentName;
    private String courseName;
    private String teacherName;
    private String commentUrl;

    @Override
    public TxWechatTemplateMsgType getType() {
        return TxWechatTemplateMsgType.AFTER_COURSE_COMMENT_WECHAT_TEMPLATE;
    }

    /**
     * @param name
     * @param name2
     * @param realName
     * @param url
     * @return
     */
    public static AfterCourseCommentMsg newInstance(String studentName, String courseName, String teacherName,
        String commentUrl) {
        AfterCourseCommentMsg msg = new AfterCourseCommentMsg();
        msg.setStudentName(studentName);
        msg.setCourseName(courseName);
        msg.setTeacherName(teacherName);
        msg.setCommentUrl(commentUrl);
        return msg;
    }

}
