
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2017 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.common.utils;

import com.baijia.tianxiao.util.GenericsUtils;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Mar 21, 2017
 * @Desc this guy is too lazy, nothing left.
 */
public class NotifyMessageUtils {

    public static final int line_length = 20;

    /**
     * @param lessonName
     * @return
     */
    public static String generateLessonName(String lessonName, boolean isForWeixin) {
        if (GenericsUtils.isNullOrEmpty(lessonName)) {
            return "";
        }
        String appendAfterClassName = null;
        if (isForWeixin) {
            appendAfterClassName = "\n课节名称：" + createLineSepator(lessonName, "课节名称：".length() + 3);
        } else {
            appendAfterClassName = String.format("，%s，", lessonName);
        }
        return appendAfterClassName;
    }

    /**
     * 
     * PM 说要20个字一行
     * 
     * @param lessonName
     * @return
     */
    private static String createLineSepator(String lessonName, int spaceCount) {
        String space = createSpace(spaceCount);
        StringBuilder sb = new StringBuilder();
        int length = lessonName.length();
        int subIndex = 0;
        int step = line_length;
        for (; subIndex < length;) {
            if (subIndex + line_length > length) {
                step = length - subIndex;
            }
            String subLine = lessonName.substring(subIndex, step + subIndex);
            sb.append(space).append(subLine).append("\n");
            subIndex += line_length;
        }
        return GenericsUtils.deleteLastCharToString(sb).trim();
    }

    /**
     * @param spaceCount
     * @return
     */

    private static String createSpace(int spaceCount) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < spaceCount; i++) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 22; i++) {
            sb.append("+");
        }
        int spaceCount = "课节名称：".length() + 3;
        System.out.println("上课课节：" + createLineSepator(sb.toString(), spaceCount));
    }

}
