package com.baijia.tianxiao.sal.common.dto.kexiao;

import com.baijia.tianxiao.dal.constant.ChargeUnit;
import lombok.Data;

/**
 * Created by lxp on 2017/4/24.
 */
@Data
/**
 *
 （1）       合同课次/时：合同课次/时，即报名时填写的课次/时。
 （2）       已购：合同课次/课时-退班课次/时-转班课次/时。
 （3）       总课次/时：已购+赠送
 （4）       已上（消）：已消正价课+已消赠送课
 （5）       已排：已排正价课+已排赠送课
 （6）       剩余课次：总课次-已消
 （7）       剩余正价课：已购-已消正价课
 （8）       剩余未排：已购-已排正价课。

  该数据模型是针对一个学生在一个班上的课消统计数据
 */
public class KexiaoStatistics {
    private int chargeUnit;
    private int chargeModel;//1:按次,2:按时间
    private long userId;
    private long classId;
    private int completeStatus;//补充完成状态,0:已补充,1:未补充
    private boolean isRefund = false;//是否退班

    private long contractAmount;//合同金额(分)
    private long contractNumber;//合同数量(课次或课时(分钟))

    private long arrangeNormalAmount;//总金额(分)
    private long arrangeNormalNumber;//正价课数量(课次或课时(分钟))
    private long cancelNormalNumber;//正价课数量(课次或课时(分钟))
    private long arrangeFreeNumber;//已排赠送课数量(课次或课时(分钟))
    private long cancelFreeNumber;//已排赠送课数量(课次或课时(分钟))

    private long refundAmount;//退款总金额(分)
    private long refundFreeNumber;//退款总数量(课次或课时(分钟))
    private long refundNormalNumber;//退款总数量(课次或课时(分钟))

    private long transferAmount;//转班金额(分)
    private long transferFreeNumber;//转班数量(课次或课时(分钟))
    private long transferNormalNumber;//转班数量(课次或课时(分钟))

    private long kexiaoNormalAmount;//总金额(分)
    private long kexiaoNormalNumber;//总数量(课次或课时(分钟))
    private long kexiaoFreeNumber;//已消赠送课数量(课次或课时(分钟))

    public long getBuyAmount() {
        return getContractAmount() - getRefundAmount() - getTransferAmount();
    }

    public long getBuyNumber() {
        return getContractNumber() - getRefundNormalNumber() - getTransferNormalNumber();
    }

    public long getArrangeAmount() {
        return getArrangeNormalAmount();
    }

    public long getArrangeNumber() {
        return getArrangeFreeNumber() + getArrangeNormalNumber() + getCancelNormalNumber() + getCancelFreeNumber();
    }

    public long getLeftUnArrangedAmount() {
        return getBuyAmount() - getArrangeNormalAmount();
    }

    public long getLeftUnArrangedNumber() {
        return getBuyNumber() - getArrangeNormalNumber();
    }

    public long getLeftAmount() {
        if(completeStatus==0){
            return getContractAmount() - getRefundAmount() - getTransferAmount() - getKexiaoAmount();
        }else {
            return -1;
        }
    }

    public long getLeftNumber() {
        return getTotalNumber() - getKexiaoNumber();
    }

    public long getLeftNormalNumber() {
        return getBuyNumber() - getKexiaoNormalNumber();
    }

    public long getTotalAmount() {
        return getContractAmount() - getRefundAmount() - getTransferAmount();
    }

    public long getTotalNumber() {
        if (completeStatus == 0) {
            return getBuyNumber() + getArrangeFreeNumber();
        } else {
            return getArrangeNormalNumber()+getArrangeFreeNumber();
        }
    }

    public long getKexiaoNumber() {
        return getKexiaoNormalNumber() + getKexiaoFreeNumber();
    }

    public long getKexiaoAmount() {
        return getKexiaoNormalAmount();
    }

    public long getTransferNumber() {
        return transferFreeNumber + transferNormalNumber;
    }

    public long getRefundNumber() {
        return refundFreeNumber + refundNormalNumber;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("KexiaoStatistics{");
        sb.append("chargeUnit=").append(chargeUnit);
        sb.append(", chargeModel=").append(chargeModel);
        sb.append(", userId=").append(userId);
        sb.append(", classId=").append(classId);
        sb.append(", completeStatus=").append(completeStatus);
        sb.append(", isRefund=").append(isRefund);
        sb.append(", contractAmount=").append(contractAmount);
        sb.append(", contractNumber=").append(contractNumber);
        sb.append(", arrangeNormalAmount=").append(arrangeNormalAmount);
        sb.append(", arrangeNormalNumber=").append(arrangeNormalNumber);
        sb.append(", cancelNormalNumber=").append(cancelNormalNumber);
        sb.append(", arrangeFreeNumber=").append(arrangeFreeNumber);
        sb.append(", cancelFreeNumber=").append(cancelFreeNumber);
        sb.append(", refundAmount=").append(refundAmount);
        sb.append(", refundFreeNumber=").append(refundFreeNumber);
        sb.append(", refundNormalNumber=").append(refundNormalNumber);
        sb.append(", transferAmount=").append(transferAmount);
        sb.append(", transferFreeNumber=").append(transferFreeNumber);
        sb.append(", transferNormalNumber=").append(transferNormalNumber);
        sb.append(", kexiaoNormalAmount=").append(kexiaoNormalAmount);
        sb.append(", kexiaoNormalNumber=").append(kexiaoNormalNumber);
        sb.append(", kexiaoFreeNumber=").append(kexiaoFreeNumber);
        sb.append('}');
        return sb.toString();
    }
}
