package com.baijia.tianxiao.sal.common.api;

/**
 * Created by liuxp on 16/10/26.
 */
public interface RedisDefaultService {

    String getStr(final String key);
    /**
     * @param key
     * @return
     */
    byte[] get(String key);

    /**
     * @param key
     * @param fieldValue
     */
    void set(String key, byte[] fieldValue);

    boolean setWithExpire(String key, byte[] fieldValue,long seconds);

    /**
     * del
     *
     * @param key
     */
    void del(final String key);

    boolean exist(String key);

    boolean expire(String key, long seconds);

    String deserialize(byte[] value);

    /**
     * @param key
     * @param fieldValue
     * @param seconds
     * @return
     */
    boolean setIfExistsWithExpire(String key, byte[] fieldValue, long seconds);

    String hGet(final String key, final String field);

    void hSet(final String key, final String field, final byte[] value);

}
