/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.common.utils;

import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.util.NumberUtil;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KexiaoUtil {
    private static final Logger log = LoggerFactory.getLogger(KexiaoUtil.class);
    private static final int HOUR = 60;
    private static final int HALF_HOUR = 30;

    public static double getLessonNum(long number, int chargeUnit) {
        ChargeUnit unit = ChargeUnit.getByCode((int)chargeUnit);
        if (unit == null) {
            unit = ChargeUnit.BY_OTHER;
        }
        switch (unit) {
            case BY_HOUR: 
            case BY_HALF_HOUR: 
            case BY_MINUTE: {
                return NumberUtil.convertMinToHourWithScale((Long)number, (int)2);
            }
            case BY_TIMES: {
                return number;
            }
        }
        log.error("[Kexiao] chargeUnit is error.charUnit={}", (Object)chargeUnit);
        return number;
    }

    public static String classHourFormat(long minute) {
        BigDecimal bigDecimal = new BigDecimal(minute);
        BigDecimal base = new BigDecimal(60);
        String result = bigDecimal.divide(base, 2, 4).toString();
        for (int i = result.length() - 1; i > 0; --i) {
            if (result.charAt(i) != '0') {
                if (result.charAt(i) != '.') break;
                result = result.substring(0, i);
                break;
            }
            result = result.substring(0, i);
        }
        return result;
    }

    public static int getClassNumber(OrgSignupCourse signupCourse) {
        ChargeUnit chargeUnit = ChargeUnit.getByCode((int)signupCourse.getChargeUnit());
        switch (chargeUnit) {
            case BY_HOUR: {
                return signupCourse.getLessonCount() * 60;
            }
            case BY_HALF_HOUR: {
                return signupCourse.getLessonCount() * 30;
            }
            case BY_MINUTE: {
                return signupCourse.getLessonCount();
            }
            case BY_TIMES: {
                return signupCourse.getLessonCount();
            }
        }
        log.error("[SignupCourseLesson] chargeUnit is error.chargeUnit={}", (Object)chargeUnit);
        return signupCourse.getLessonCount();
    }

    public static void main(String[] args) {
        System.out.println(KexiaoUtil.classHourFormat(30L));
        System.out.println(KexiaoUtil.classHourFormat(60L));
        System.out.println(KexiaoUtil.classHourFormat(15L));
        System.out.println(KexiaoUtil.classHourFormat(10L));
        System.out.println(KexiaoUtil.classHourFormat(0L));
    }
}

