/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.common.impl;

import com.baijia.tianxiao.redis.AbstractBaseRedisDao;
import com.baijia.tianxiao.sal.common.api.RedisDefaultService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Service;

@Service
public class RedisDefaultServiceImpl
extends AbstractBaseRedisDao
implements RedisDefaultService {
    private static final Logger log = LoggerFactory.getLogger(RedisDefaultServiceImpl.class);

    @Override
    public String hGet(final String key, final String field) {
        return this.execute(new RedisCallback<String>(){

            public String doInRedis(RedisConnection connection) throws DataAccessException {
                connection.select(6);
                RedisSerializer serializer = RedisDefaultServiceImpl.this.redisTemplate.getStringSerializer();
                byte[] byteKey = serializer.serialize((Object)key);
                byte[] byteFiled = serializer.serialize((Object)field);
                byte[] value = connection.hGet(byteKey, byteFiled);
                if (value != null) {
                    return (String)serializer.deserialize(value);
                }
                return null;
            }
        });
    }

    @Override
    public String get(final String key) {
        return this.execute(new RedisCallback<String>(){

            public String doInRedis(RedisConnection connection) throws DataAccessException {
                RedisSerializer serializer = RedisDefaultServiceImpl.this.redisTemplate.getStringSerializer();
                byte[] byteKey = serializer.serialize((Object)key);
                byte[] value = connection.get(byteKey);
                if (value != null) {
                    return (String)serializer.deserialize(value);
                }
                return null;
            }
        });
    }

    @Override
    public void set(final String key, final String fieldValue) {
        this.execute(new RedisCallback<Void>(){

            public Void doInRedis(RedisConnection connection) throws DataAccessException {
                RedisSerializer serializer = RedisDefaultServiceImpl.this.redisTemplate.getStringSerializer();
                byte[] byteKey = serializer.serialize((Object)key);
                byte[] byteValue = serializer.serialize((Object)fieldValue);
                connection.set(byteKey, byteValue);
                return null;
            }
        });
    }

    @Override
    public boolean setIfExistsWithExpire(final String key, String fieldValue, final long seconds) {
        return this.execute(new RedisCallback<Boolean>(){

            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                long expirTimeStep = seconds * 1000L;
                RedisSerializer serializer = RedisDefaultServiceImpl.this.redisTemplate.getStringSerializer();
                byte[] byteKey = serializer.serialize((Object)key);
                byte[] expirAt = serializer.serialize((Object)String.valueOf(System.currentTimeMillis() + expirTimeStep));
                boolean isExists = true;
                if (connection.setNX(byteKey, expirAt).booleanValue()) {
                    log.info("key:{} not exists ", (Object)key);
                    isExists = false;
                    connection.expire(byteKey, seconds);
                } else {
                    byte[] expirTime = connection.get(byteKey);
                    String deserialize = (String)serializer.deserialize(expirTime);
                    long oldTimeStamp = Long.parseLong(deserialize);
                    long currentTimeStamp = System.currentTimeMillis();
                    if (currentTimeStamp > oldTimeStamp) {
                        log.info("key:{} is expire", (Object)key);
                        long newExpirAtLong = currentTimeStamp + expirTimeStep;
                        log.info("oldExpiredAt:{} and newExpiredAt:{} ", (Object)oldTimeStamp, (Object)newExpirAtLong);
                        byte[] newExpirAt = serializer.serialize((Object)String.valueOf(newExpirAtLong));
                        byte[] preTimeStamp = connection.getSet(byteKey, newExpirAt);
                        if (preTimeStamp != null) {
                            String preTimeStampSetRetStr = (String)serializer.deserialize(preTimeStamp);
                            log.info("preTimeStampSetRetStr is:{} ", (Object)preTimeStampSetRetStr);
                            long preSetRetLong = Long.parseLong(preTimeStampSetRetStr);
                            if (preSetRetLong == oldTimeStamp) {
                                isExists = false;
                                log.info("success reset key's expir time:{}", (Object)key);
                            } else {
                                isExists = true;
                                log.info("other client has reset key's expir time:{} , so current client can not get the lock", (Object)key);
                            }
                        } else {
                            isExists = false;
                            log.info("success reset key's expir time:{}", (Object)key);
                        }
                    } else {
                        log.info("key:{} not expired ", (Object)key);
                        isExists = true;
                    }
                }
                return isExists;
            }
        });
    }

    @Override
    public void hSet(final String key, final String field, final String value) {
        this.execute(new RedisCallback<Object>(){

            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                RedisSerializer serializer = RedisDefaultServiceImpl.this.redisTemplate.getStringSerializer();
                byte[] byteKey = serializer.serialize((Object)key);
                byte[] byteFiled = serializer.serialize((Object)field);
                byte[] byteValue = serializer.serialize((Object)value);
                connection.hSet(byteKey, byteFiled, byteValue);
                return null;
            }
        });
    }

    private <T> T execute(RedisCallback<T> callback) {
        Exception ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                return (T)this.redisTemplate.execute(callback);
            }
            catch (Exception e) {
                ex = e;
                try {
                    if (i < 2) {
                        Thread.sleep((i + 1) * 500);
                    }
                    log.warn("[Redis] try connect to redis.count={}", (Object)(i + 1));
                }
                catch (InterruptedException e1) {
                    log.error("[Redis] InterruptedException ", (Throwable)e1);
                }
                continue;
            }
        }
        log.error("[Redis] Query data exception.", ex);
        return null;
    }
}

