/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.common.impl;

import com.baijia.tianxiao.beanCopy.BeanInvokeUtils;
import com.baijia.tianxiao.constant.OrgTeacherStatus;
import com.baijia.tianxiao.dal.activity.mongo.MongoDBOperator;
import com.baijia.tianxiao.dal.org.dao.OrgLessonCommentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgTeacher;
import com.baijia.tianxiao.dal.solr.dto.OrgTeacherDocument;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.sal.common.api.OrgTeacherForSolrService;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.ThreeTuple;
import com.baijia.tianxiao.util.TupleUtil;
import com.baijia.tianxiao.util.TwoTuple;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.BasicBSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgTeacherForSolrServiceImpl
implements OrgTeacherForSolrService {
    private static final Logger log = LoggerFactory.getLogger(OrgTeacherForSolrServiceImpl.class);
    public static final String mongoDbBackupCollection = "orgTeacherDocuments";
    public static final String UNIQUE_KEY = "id";
    @Autowired
    private OrgLessonCommentDao orgLessonCommentDao;
    @Autowired
    private TeacherDao teacherDao;
    @Autowired
    private OrgTeacherLessonDao orgTeacherLessonDao;
    @Autowired
    private OrgStudentLessonDao orgStudentLessonDao;
    @Autowired
    private OrgTeacherDao orgTeacherDao;
    @Autowired
    private MongoDBOperator mongoDbOperator;

    @Override
    public Map<Long, OrgTeacherDocument> createOrgTeacherDocuments(Long orgId, Collection<OrgTeacher> orgTeachers, Date beginDate, Date endDate, boolean isSaveOrUpdate) {
        if (GenericsUtils.isNullOrEmpty(orgTeachers)) {
            log.info(" empty OrgTeacher  :{} ", orgTeachers);
            return GenericsUtils.emptyMap();
        }
        Map orgTeacherMap = CollectorUtil.collectMap(orgTeachers, (Function)new Function<OrgTeacher, Long>(){

            public Long apply(OrgTeacher teacher) {
                return teacher.getUserId();
            }
        });
        Set teacherUserIds = orgTeacherMap.keySet();
        List teachers = null;
        try {
            teachers = this.teacherDao.getByUserIds(teacherUserIds, new String[0]);
        }
        catch (Exception e) {
            log.error("error :{} ", (Throwable)e);
        }
        if (GenericsUtils.isNullOrEmpty((Object)teachers)) {
            log.info(" can not find any teacher with teacherUserIds :{} ", teacherUserIds);
            return GenericsUtils.emptyMap();
        }
        String dataMonth = DateUtil.getCurrentYM((Long)beginDate.getTime());
        HashMap orgTeacherDocumentMap = Maps.newHashMap();
        Map scoreMap = this.orgLessonCommentDao.getAveCommentByTeacherIds(teacherUserIds, new String[0]);
        log.info("for teacherUserIds , the scoreMap is :{} ", (Object)scoreMap);
        Map teacherLessonIds = this.orgTeacherLessonDao.divideTeacherLessonIds((List)Lists.newArrayList(teacherUserIds), beginDate, endDate);
        log.info("teacherLessonIds are :{} ", (Object)teacherLessonIds);
        HashMap classTimeInfos = Maps.newHashMap();
        HashMap lessonIdMap = Maps.newHashMap();
        for (Map.Entry entry : teacherLessonIds.entrySet()) {
            Long teacherId = (Long)entry.getKey();
            List values = (List)entry.getValue();
            if (!GenericsUtils.notNullAndEmpty((Object)values)) continue;
            for (ThreeTuple value : values) {
                Long lessonId = (Long)value.first;
                Integer finishClassTime = (Integer)value.second;
                Integer arrangeClassTime = (Integer)value.three;
                if (!classTimeInfos.containsKey(teacherId)) {
                    TwoTuple classTimeTuple = TupleUtil.tuple((Object)finishClassTime, (Object)arrangeClassTime);
                    classTimeInfos.put(teacherId, classTimeTuple);
                } else {
                    TwoTuple twoTuple = (TwoTuple)classTimeInfos.get(teacherId);
                    Integer finishClassTimeSum = (Integer)twoTuple.first;
                    Integer arrangeClassTimeSum = (Integer)twoTuple.second;
                    twoTuple = TupleUtil.tuple((Object)(finishClassTime + finishClassTimeSum), (Object)(arrangeClassTime + arrangeClassTimeSum));
                    classTimeInfos.put(teacherId, twoTuple);
                }
                List<Long> finishLessonIds = null;
                List<Long> arrangeLessonIds = null;
                if (!lessonIdMap.containsKey(teacherId)) {
                    finishLessonIds = Lists.newArrayList();
                    arrangeLessonIds = Lists.newArrayList();
                    TwoTuple tuple = TupleUtil.tuple((Object)finishLessonIds, (Object)arrangeLessonIds);
                    lessonIdMap.put(teacherId, tuple);
                } else {
                    TwoTuple twoTuple = (TwoTuple)lessonIdMap.get(teacherId);
                    finishLessonIds = (List)twoTuple.first;
                    arrangeLessonIds = (List)twoTuple.second;
                }
                arrangeLessonIds.add(lessonId);
                if (finishClassTime <= 0) continue;
                finishLessonIds.add(lessonId);
            }
        }
        log.info("lessonIdMap are:{} ", (Object)lessonIdMap);
        Map<Long, TwoTuple<Integer, Integer>> teacherStudentCountMap = this.findTeacherStudentCountInfoMap(lessonIdMap);
        log.info("for teacherUserIds , the teacherStudentCountMap is :{} ", teacherStudentCountMap);
        HashMap teacherClassTimeMap = classTimeInfos;
        log.info("for teacherUserIds , the teacherClassTimeMap is :{} ", (Object)teacherClassTimeMap);
        for (Teacher teacher : teachers) {
            TwoTuple<Integer, Integer> studentCountInfo;
            Long userId = teacher.getUserId();
            OrgTeacher orgTeacher = (OrgTeacher)orgTeacherMap.get(userId);
            log.info("[OrgTeacherForSolrServiceImpl] orgTeacher is :{} ", (Object)orgTeacher);
            OrgTeacherDocument otd = OrgTeacherDocument.newInstance((Long)userId, (String)dataMonth);
            otd.setOrgId(orgTeacher.getOrgId());
            otd.setAvatarStorageId(teacher.getAvatar());
            otd.setCreateTime(Long.valueOf(teacher.getCreatedAt().getTime()));
            otd.setDataMonth(dataMonth);
            otd.setMobile(teacher.getMobile());
            otd.setName(teacher.getRealName());
            Long score = (Long)scoreMap.get(userId);
            otd.setScoreNum(score == null ? 0L : score);
            otd.setOrgTeacherId(orgTeacher.getId());
            otd.setUseStatus(orgTeacher.getUseStatus());
            if (orgTeacher.getStatus().intValue() == OrgTeacherStatus.TERMINATED.getCode()) {
                otd.setUseStatus(Integer.valueOf(2));
            }
            if (orgTeacher.isInUse()) {
                otd.setPauseTime(null);
            } else {
                otd.setPauseTime(Long.valueOf(orgTeacher.getUpdateTime() == null ? System.currentTimeMillis() : orgTeacher.getUpdateTime().getTime()));
            }
            TwoTuple classTimeInfo = (TwoTuple)teacherClassTimeMap.get(userId);
            if (classTimeInfo != null) {
                Integer finishedClassTime = (Integer)classTimeInfo.first;
                Integer arrangeClassTime = (Integer)classTimeInfo.second;
                otd.setFinishedClassTime(finishedClassTime);
                otd.setArrangeClassTime(arrangeClassTime);
            }
            if ((studentCountInfo = teacherStudentCountMap.get(userId)) != null) {
                Integer hasSignupStudentCount = (Integer)studentCountInfo.first;
                Integer arrangeStudentCount = (Integer)studentCountInfo.second;
                otd.setArrangeStudentCount(arrangeStudentCount);
                otd.setHasSignupStudentCount(hasSignupStudentCount);
            }
            orgTeacherDocumentMap.put(userId, otd);
        }
        if (isSaveOrUpdate) {
            log.info("[OrgTeacherDocument] isSaveOrUpdate is true ,so will batch add document to solr");
            this.addNewDocument(orgTeacherDocumentMap.values());
        }
        return orgTeacherDocumentMap;
    }

    @Override
    public Map<Long, OrgTeacherDocument> createOrgTeacherDocuments(Long orgId, List<Long> teacherUserIds, Date beginDate, Date endDate, boolean isSaveOrUpdate) {
        List teacherByUserIdsAndOrgId = this.orgTeacherDao.getTeacherByUserIdsAndOrgId(orgId, teacherUserIds, null, null, new String[0]);
        return this.createOrgTeacherDocuments(orgId, teacherByUserIdsAndOrgId, beginDate, endDate, isSaveOrUpdate);
    }

    private Map<Long, TwoTuple<Integer, Integer>> findTeacherStudentCountInfoMap(Map<Long, TwoTuple<List<Long>, List<Long>>> lessonIdMaps) {
        ArrayList finishLessonIds = Lists.newArrayList();
        ArrayList arrangeLessonIds = Lists.newArrayList();
        HashMap inversionIdMap = Maps.newHashMap();
        for (Map.Entry<Long, TwoTuple<List<Long>, List<Long>>> entry : lessonIdMaps.entrySet()) {
            Long teacherId = entry.getKey();
            TwoTuple<List<Long>, List<Long>> value = entry.getValue();
            finishLessonIds.addAll((Collection)value.first);
            arrangeLessonIds.addAll((Collection)value.second);
            for (Long lessonId : (List)value.second) {
                GenericsUtils.addListIfNotExists((Map)inversionIdMap, (Object)lessonId, (Object)teacherId);
            }
        }
        Map studentCountMap = this.orgStudentLessonDao.countStudentNumsWithLessonIds((List)finishLessonIds, (List)arrangeLessonIds);
        HashMap retMap = Maps.newHashMap();
        for (Map.Entry entry : studentCountMap.entrySet()) {
            Long lessonId = (Long)entry.getKey();
            TwoTuple tupleValue = (TwoTuple)entry.getValue();
            List teacherIds = (List)inversionIdMap.get(lessonId);
            if (!GenericsUtils.notNullAndEmpty((Object)teacherIds)) continue;
            for (Long teacherId : teacherIds) {
                Integer totalStudentCount;
                Integer finishStudentCount;
                if (!retMap.containsKey(teacherId)) {
                    finishStudentCount = (Integer)tupleValue.first;
                    totalStudentCount = (Integer)tupleValue.second;
                    TwoTuple countTuple = TupleUtil.tuple((Object)finishStudentCount, (Object)totalStudentCount);
                    retMap.put(teacherId, countTuple);
                    continue;
                }
                finishStudentCount = (Integer)((TwoTuple)retMap.get((Object)teacherId)).first;
                totalStudentCount = (Integer)((TwoTuple)retMap.get((Object)teacherId)).second;
                retMap.put(teacherId, TupleUtil.tuple((Object)(finishStudentCount + (Integer)tupleValue.first), (Object)(totalStudentCount + (Integer)tupleValue.second)));
            }
        }
        return retMap;
    }

    private Map<Long, TwoTuple<Integer, Integer>> findTeacherClassTimeInfoMap(List<Long> teacherUserIds, Date beginDate, Date endDate) {
        return this.orgTeacherLessonDao.getTeacherLessonClassTimeInfoByMonth(teacherUserIds, beginDate, endDate);
    }

    @Override
    public void addNewDocument(Collection<OrgTeacherDocument> otds) {
        if (GenericsUtils.isNullOrEmpty(otds)) {
            return;
        }
        log.info("[OrgTeacherDocument] success to add docs into solr ==== :{}", otds);
        this.backupByMongoDb(otds);
    }

    private void backupByMongoDb(Collection<OrgTeacherDocument> otds) {
        try {
            ArrayList ids = Lists.newArrayList();
            for (OrgTeacherDocument otd : otds) {
                ids.add(otd.getId());
            }
            BasicBSONObject searcher = new BasicBSONObject();
            searcher.put((Object)"$in", (Object)ids);
            List searchObjs = this.mongoDbOperator.searchObjs(mongoDbBackupCollection, (Map)new BasicBSONObject(UNIQUE_KEY, (Object)searcher), Map.class, new Gson[0]);
            ids.clear();
            for (Map mapValue : searchObjs) {
                ids.add(mapValue.get(UNIQUE_KEY).toString());
            }
            ArrayList updateOtds = Lists.newArrayList();
            Iterator<OrgTeacherDocument> iter = otds.iterator();
            while (iter.hasNext()) {
                OrgTeacherDocument next = iter.next();
                if (!ids.contains(next.getId())) continue;
                updateOtds.add(next);
                iter.remove();
            }
            this.mongoDbOperator.insertDocuments(mongoDbBackupCollection, otds, new String[]{UNIQUE_KEY});
            log.info("updateOtds are:{} ", (Object)updateOtds);
            this.backUpdateByMongoDB(updateOtds);
        }
        catch (Exception e) {
            GenericsUtils.logErrorAndInfo((Logger)log, (Exception)e, (String)"can not insert many documents {}", (Object[])new Object[]{otds});
        }
    }

    private Map<String, Object> createValueByField(OrgTeacherDocument otd) {
        Map copyToMap = BeanInvokeUtils.copyToMap((Object)otd, null);
        log.info("[OrgTeacherDocument] BeanInvoke copy from otd:{} to map:{} ", (Object)otd, (Object)copyToMap);
        return copyToMap;
    }

    @Override
    public void updateDocument(Collection<OrgTeacherDocument> otds) {
        if (GenericsUtils.isNullOrEmpty(otds)) {
            return;
        }
        ArrayList docs = Lists.newArrayList();
        for (OrgTeacherDocument next : otds) {
            if (next.getId() != null) continue;
            docs.add(next);
        }
        if (GenericsUtils.notNullAndEmpty((Object)docs)) {
            log.info("find some docuemnt has not id ,so will attempt to create id for those document :{} ", (Object)docs);
            for (OrgTeacherDocument otd_ : docs) {
                if (otd_.getTeacherUserId() == null) continue;
                String dataMonth = otd_.getDataMonth();
                if (GenericsUtils.isNullOrEmpty((Object)dataMonth)) {
                    dataMonth = DateUtil.getCurrentYM();
                }
                String createId = OrgTeacherDocument.createId((Long)otd_.getTeacherUserId(), (String)dataMonth);
                otd_.setId(createId);
            }
        }
        this.addNewDocument(otds);
        this.backUpdateByMongoDB(otds);
    }

    private void backUpdateByMongoDB(Collection<OrgTeacherDocument> otds) {
        HashMap updateQuery = Maps.newHashMap();
        for (OrgTeacherDocument otd : otds) {
            updateQuery.put(UNIQUE_KEY, otd.getId());
            try {
                this.mongoDbOperator.updateDocument((Object)otd, mongoDbBackupCollection, (Map)updateQuery);
            }
            catch (Exception e) {
                log.info("can not update otd :{} cause by :{} ", (Object)otd, (Object)e);
            }
            updateQuery.clear();
        }
        log.info("update all orgTeacherDocument over ! ----- ");
    }

    public static void main(String[] args) {
        Date currentTime = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(currentTime);
        c.add(2, 1);
        Date time1 = c.getTime();
        Date time2 = currentTime;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-01 00:00:00");
        System.out.println(format.format(time1));
        System.out.println(format.format(time2));
    }
}

