/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.common.impl;

import com.baijia.tianxiao.constant.ClassOrderCompleteStatus;
import com.baijia.tianxiao.constant.LessonStatus;
import com.baijia.tianxiao.constant.LessonType;
import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.constant.TransferClassStatus;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.finance.dao.TxTransferClassInfoDao;
import com.baijia.tianxiao.dal.finance.dao.TxTransferClassRecordDao;
import com.baijia.tianxiao.dal.finance.po.TxTransferClassInfo;
import com.baijia.tianxiao.dal.finance.po.TxTransferClassRecord;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentKexiaoRecordDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dto.StudentCourseKexiaoDocument;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseConsumeRule;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.dal.signup.constant.SignupCourseStatus;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseLessonDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupRefundDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourseLesson;
import com.baijia.tianxiao.dal.signup.po.OrgSignupRefund;
import com.baijia.tianxiao.exception.ParameterException;
import com.baijia.tianxiao.sal.common.api.CourseApiService;
import com.baijia.tianxiao.sal.common.api.KexiaoApiService;
import com.baijia.tianxiao.sal.common.dto.KexiaoStatisticsSuper;
import com.baijia.tianxiao.sal.common.dto.kexiao.KexiaoSignupCourseStat;
import com.baijia.tianxiao.sal.common.dto.kexiao.KexiaoStatistics;
import com.baijia.tianxiao.sal.common.dto.kexiao.KexiaoStudentStat;
import com.baijia.tianxiao.sal.common.impl.KexiaoStatisticsBuilder;
import com.baijia.tianxiao.sal.common.utils.KexiaoUtil;
import com.baijia.tianxiao.util.CollectionHelper;
import com.baijia.tianxiao.util.ListUtil;
import com.baijia.tianxiao.util.NumberUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class KexiaoApiServiceImpl
implements KexiaoApiService {
    private static final Logger log = LoggerFactory.getLogger(KexiaoApiServiceImpl.class);
    @Autowired
    private OrgSignupCourseDao signupCourseDao;
    @Autowired
    private OrgSignupCourseLessonDao signupCourseLessonDao;
    @Autowired
    private OrgSignupRefundDao refundDao;
    @Autowired
    private CourseApiService courseApiService;
    @Autowired
    private TxTransferClassRecordDao transferClassRecordDao;
    @Autowired
    private TxTransferClassInfoDao transferClassInfoDao;
    @Autowired
    private OrgCourseDao courseDao;
    @Autowired
    private OrgStudentLessonDao studentLessonDao;
    @Autowired
    private OrgStudentCourseDao studentcourseDao;
    @Autowired
    private OrgStudentKexiaoRecordDao orgStudentKexiaoRecordDao;
    private static final Date SUPPORT_TIME = DateUtil.getStrToDate((String)"yyyy-MM-dd mm:HH:ss", (String)"2017-06-10 00:00:00");

    @Override
    public LessonStatus getKexiaoStatus(OrgLessonSign sign, int rule) {
        int byteCode = 0;
        if (sign.getStatus().intValue() == SignStatus.SIGNED.getCode()) {
            byteCode = 1;
        } else if (sign.getStatus().intValue() == SignStatus.LEAVE.getCode()) {
            byteCode = 2;
        } else if (sign.getStatus().intValue() == SignStatus.ABSENT.getCode()) {
            byteCode = 4;
        } else {
            log.info("[Kexiao] UnSign.sign={}", (Object)sign);
        }
        int result = byteCode & rule;
        if (result > 0) {
            return LessonStatus.FINISHED;
        }
        return LessonStatus.UN_START;
    }

    @Override
    public String getLeftAmountStr(KexiaoStatistics stat) {
        String remainTuition = "0.00";
        if (stat != null) {
            remainTuition = stat.getCompleteStatus() != 0 ? "--" : NumberUtil.convertFenToYuan((long)stat.getLeftAmount());
        }
        return remainTuition;
    }

    @Override
    public void setStudentLessonKexiaoStatus(Collection<OrgStudentLesson> studentLessons) {
        HashSet<Long> classIds = new HashSet<Long>();
        for (OrgStudentLesson lesson : studentLessons) {
            classIds.add(lesson.getCourseId());
        }
        HashSet<OrgStudentLesson> signKexiaoLessons = new HashSet<OrgStudentLesson>();
        HashSet<OrgStudentLesson> timeKexiaoLessons = new HashSet<OrgStudentLesson>();
        Map<Long, OrgCourseConsumeRule> consumeRuleMap = this.courseApiService.getClassRule(classIds);
        for (OrgStudentLesson lesson : studentLessons) {
            OrgCourseConsumeRule rule = consumeRuleMap.get(lesson.getCourseId());
            if (rule == null || rule.getRuleValue() == 0) {
                timeKexiaoLessons.add(lesson);
                continue;
            }
            signKexiaoLessons.add(lesson);
        }
    }

    @Override
    public LessonStatus getKexiaoStatus(Date startTime) {
        return startTime.compareTo(new Date()) > 0 ? LessonStatus.UN_START : LessonStatus.FINISHED;
    }

    @Override
    public Map<Long, KexiaoStudentStat> queryKexiaoStatByStudents(Long orgId, Collection<Long> userIds) {
        HashMap<Long, KexiaoStudentStat> ret = new HashMap<Long, KexiaoStudentStat>();
        if (userIds == null || userIds.size() < 1) {
            return ret;
        }
        List signupCourseList = this.signupCourseDao.searchByUserIdsAndClassId(userIds, null, orgId, (Collection)SignupCourseStatus.PAY_SUCCESS);
        for (Object signupCourse : signupCourseList) {
            KexiaoStudentStat stat = (KexiaoStudentStat)ret.get(signupCourse.getUserId());
            if (stat == null) {
                stat = new KexiaoStudentStat();
                stat.setCompleteStatus(1);
                ret.put(signupCourse.getUserId(), stat);
            }
            this.addBuyData((OrgSignupCourse)signupCourse, stat);
            stat.splitContractNumber((OrgSignupCourse)signupCourse);
            if (signupCourse.getLessonCount() <= 0) continue;
            stat.setCompleteStatus(0);
        }
        List courseLessons = this.signupCourseLessonDao.listByUserIdAndLessonId(userIds, null, Integer.valueOf(LessonStatus.FINISHED.getStatus()));
        for (Object lesson : courseLessons) {
            KexiaoStudentStat stat = (KexiaoStudentStat)ret.get(lesson.getUserId());
            if (stat == null) {
                stat = new KexiaoStudentStat();
                ret.put(lesson.getUserId(), stat);
            }
            this.addKexiaoData((OrgSignupCourseLesson)lesson, stat);
            stat.splitKexiaoNumber((OrgSignupCourseLesson)lesson);
        }
        List refundList = this.refundDao.listOrderByUserIds(orgId, userIds);
        for (OrgSignupRefund refund : refundList) {
            Object stat = (KexiaoStudentStat)ret.get(refund.getUserId());
            if (stat == null) {
                stat = new KexiaoStudentStat();
                ret.put(refund.getUserId(), (KexiaoStudentStat)stat);
            }
            this.addRefundData(refund, (KexiaoStatistics)stat);
            ((KexiaoStudentStat)stat).splitRefundNumber(refund);
        }
        Map<Long, List<TxTransferClassRecord>> recordListMap = this.getTxTransferClassRecordList(userIds);
        Set<Long> keySet = recordListMap.keySet();
        for (Long userId : keySet) {
            List<TxTransferClassRecord> list;
            KexiaoStudentStat stat = (KexiaoStudentStat)ret.get(userId);
            if (stat == null) {
                stat = new KexiaoStudentStat();
                ret.put(userId, stat);
            }
            if ((list = recordListMap.get(userId)) == null || list.size() <= 0) continue;
            for (TxTransferClassRecord record : list) {
                this.addTransferData(record, (KexiaoStatistics)stat);
                stat.splitTransferNumber(record);
            }
        }
        List lessons = this.studentLessonDao.listByUserIdsAndLessonType(orgId.longValue(), userIds, Arrays.asList(-1), new String[]{"id", "userId", "courseId", "kexiaoStatus"});
        for (OrgStudentLesson lesson : lessons) {
            KexiaoStudentStat stat = (KexiaoStudentStat)ret.get(lesson.getUserId());
            if (stat == null) {
                stat = new KexiaoStudentStat();
                ret.put(lesson.getUserId(), stat);
            }
            if (lesson.getKexiaoStatus() == 1) {
                stat.setKexiaoNormalCount(stat.getKexiaoNormalCount() + 1L);
            }
            stat.setArrangeNormalCount(stat.getArrangeNormalCount() + 1L);
        }
        log.info("KexiaoStatistics queryKexiaoStatByStudentClass ,params={},{},{},result={}", new Object[]{orgId, userIds, ret});
        return ret;
    }

    @Override
    public Map<String, KexiaoStatistics> queryKexiaoStatByUserIds(Long orgId, Collection<Long> userIds) {
        HashMap<String, KexiaoStatistics> ret = new HashMap<String, KexiaoStatistics>();
        if (userIds == null || userIds.size() < 1) {
            return ret;
        }
        List signupCourseList = this.signupCourseDao.searchByUserIdsAndClassId(userIds, null, orgId, (Collection)SignupCourseStatus.PAY_SUCCESS);
        for (Object signupCourse : signupCourseList) {
            String key = this.getKey(signupCourse.getUserId(), signupCourse.getClassId());
            KexiaoStatistics stat = (KexiaoStatistics)ret.get(key);
            if (stat == null) {
                stat = new KexiaoStatistics();
                stat.setCompleteStatus(1);
                ret.put(key, stat);
            }
            this.addBuyData((OrgSignupCourse)signupCourse, stat);
            if (signupCourse.getLessonCount() <= 0) continue;
            stat.setCompleteStatus(0);
        }
        List courseLessons = this.signupCourseLessonDao.listByUserIdAndLessonId(userIds, null, Integer.valueOf(LessonStatus.FINISHED.getStatus()));
        for (Object lesson : courseLessons) {
            String key = this.getKey(lesson.getUserId(), lesson.getClassId());
            KexiaoStatistics stat = (KexiaoStatistics)ret.get(key);
            if (stat == null) {
                stat = new KexiaoStudentStat();
                ret.put(key, stat);
            }
            this.addKexiaoData((OrgSignupCourseLesson)lesson, stat);
        }
        List refundList = this.refundDao.listOrderByUserIds(orgId, userIds);
        for (OrgSignupRefund refund : refundList) {
            String key = this.getKey(refund.getUserId(), refund.getClassId());
            KexiaoStatistics stat = (KexiaoStatistics)ret.get(key);
            if (stat == null) {
                stat = new KexiaoStudentStat();
                ret.put(key, stat);
            }
            this.addRefundData(refund, stat);
        }
        Map<Long, List<TxTransferClassRecord>> recordListMap = this.getTxTransferClassRecordList(userIds);
        Set<Long> keySet = recordListMap.keySet();
        for (Long userId : keySet) {
            List<TxTransferClassRecord> list = recordListMap.get(userId);
            if (list == null || list.size() <= 0) continue;
            for (TxTransferClassRecord record : list) {
                String key = this.getKey(record.getTransferOutUserId(), record.getTransferOutClassId());
                KexiaoStatistics stat = (KexiaoStatistics)ret.get(key);
                if (stat == null) {
                    stat = new KexiaoStudentStat();
                    ret.put(key, stat);
                }
                this.addTransferData(record, stat);
            }
        }
        List lessons = this.studentLessonDao.listByUserIdsAndLessonType(orgId.longValue(), userIds, Arrays.asList(-1), new String[]{"id", "userId", "courseId", "kexiaoStatus"});
        for (OrgStudentLesson lesson : lessons) {
            String key = this.getKey(lesson.getUserId(), lesson.getCourseId());
            KexiaoStatistics stat = (KexiaoStatistics)ret.get(key);
            if (stat == null) {
                stat = new KexiaoStudentStat();
                ret.put(key, stat);
            }
            if (lesson.getKexiaoStatus() == 1) {
                stat.setKexiaoFreeNumber(stat.getKexiaoFreeNumber() + 1L);
            }
            stat.setArrangeNormalNumber(stat.getArrangeNormalNumber() + 1L);
        }
        log.info("KexiaoStatistics queryKexiaoStatByStudentClass ,params={},{},{},result={}", new Object[]{orgId, userIds, ret});
        return ret;
    }

    private String getKey(long userId, long classId) {
        return userId + "_" + classId;
    }

    private Map<Long, List<TxTransferClassRecord>> getTxTransferClassRecordList(Collection<Long> userIds) {
        List<Integer> status = Arrays.asList(TransferClassStatus.INIT.getCode(), TransferClassStatus.SUCCESS.getCode());
        List transferClassInfos = this.transferClassInfoDao.listByUserIds(userIds, status);
        return this.getUserIdToRecordListMap(transferClassInfos);
    }

    private Map<Long, List<TxTransferClassRecord>> getTxTransferClassRecordList(Collection<Long> userIds, Long classId) {
        List<Integer> status = Arrays.asList(TransferClassStatus.INIT.getCode(), TransferClassStatus.SUCCESS.getCode());
        List transferClassInfos = this.transferClassInfoDao.listByUserIdsAndClassId(userIds, classId, status);
        return this.getUserIdToRecordListMap(transferClassInfos);
    }

    private Map<Long, List<TxTransferClassRecord>> getUserIdToRecordListMap(List<TxTransferClassInfo> transferClassInfos) {
        HashMap<Long, List<TxTransferClassRecord>> ret = new HashMap<Long, List<TxTransferClassRecord>>();
        Map numberMap = CollectionHelper.toKeyMap(transferClassInfos, (String)"transferNumber");
        List transferNumbers = ListUtil.toKeyList(transferClassInfos, (String)"transferNumber", TxTransferClassInfo.class);
        List recordList = new ArrayList();
        if (transferNumbers != null && transferNumbers.size() > 0) {
            recordList = this.transferClassRecordDao.listByTransferNumbers((Collection)transferNumbers);
        }
        for (TxTransferClassRecord record : recordList) {
            long number = record.getTransferNumber();
            TxTransferClassInfo classInfo = (TxTransferClassInfo)numberMap.get(number);
            ArrayList<TxTransferClassRecord> list = (ArrayList<TxTransferClassRecord>)ret.get(classInfo.getUserId());
            if (list == null) {
                list = new ArrayList<TxTransferClassRecord>();
                ret.put(classInfo.getUserId(), list);
            }
            list.add(record);
        }
        return ret;
    }

    private void addBuyData(OrgSignupCourse signupCourse, KexiaoStatistics stat) {
        if (signupCourse.getLessonCount() > 0) {
            stat.setCompleteOrderAmount(stat.getCompleteOrderAmount() + signupCourse.getTotalPayPrice());
            stat.setCompleteOrderNumber(stat.getCompleteOrderNumber() + (long)KexiaoUtil.getClassNumber(signupCourse));
        }
        stat.setContractAmount(stat.getContractAmount() + signupCourse.getTotalPayPrice());
        stat.setContractNumber(stat.getContractNumber() + (long)KexiaoUtil.getClassNumber(signupCourse));
    }

    private void addKexiaoData(OrgSignupCourseLesson lesson, KexiaoStatistics stat) {
        if (stat.getCompleteStatus() == 0) {
            if (lesson.getLessonType() == LessonType.NORMAL.getCode()) {
                if (lesson.getKexiaoStatus().intValue() == LessonStatus.FINISHED.getStatus()) {
                    stat.setKexiaoNormalAmount(stat.getKexiaoNormalAmount() + lesson.getAmount());
                    stat.setKexiaoNormalNumber(stat.getKexiaoNormalNumber() + (long)this.getLessonNumber(lesson));
                }
                stat.setArrangeNormalAmount(stat.getArrangeNormalAmount() + lesson.getAmount());
                stat.setArrangeNormalNumber(stat.getArrangeNormalNumber() + (long)this.getLessonNumber(lesson));
            } else if (lesson.getLessonType() == LessonType.FREE.getCode()) {
                if (lesson.getKexiaoStatus().intValue() == LessonStatus.FINISHED.getStatus()) {
                    stat.setKexiaoFreeNumber(stat.getKexiaoFreeNumber() + (long)this.getLessonNumber(lesson));
                }
                stat.setArrangeFreeNumber(stat.getArrangeFreeNumber() + (long)this.getLessonNumber(lesson));
            } else if (lesson.getLessonType() == LessonType.CANCEL.getCode()) {
                stat.setCancelNormalNumber(stat.getCancelNormalNumber() + (long)this.getLessonNumber(lesson));
            } else if (lesson.getLessonType() == LessonType.FREE_CANCEL.getCode()) {
                stat.setCancelFreeNumber(stat.getCancelFreeNumber() + (long)this.getLessonNumber(lesson));
            }
        }
    }

    private int getLessonNumber(OrgSignupCourseLesson lesson) {
        if (ChargeUnit.isByTime((int)lesson.getChargeUnit())) {
            return lesson.getLessonDuration();
        }
        return 1;
    }

    private void addRefundData(OrgSignupRefund refund, KexiaoStatistics stat) {
        if (stat.getCompleteStatus() == 0) {
            stat.setRefundAmount(stat.getRefundAmount() + refund.getRefundFee() + refund.getRefundPrice());
            stat.setRefundNormalNumber(stat.getRefundNormalNumber() + (long)refund.getRefundLessonCount().intValue());
        }
    }

    private void addTransferData(TxTransferClassInfo info, KexiaoStatistics stat) {
        if (stat.getCompleteStatus() == 0) {
            stat.setTransferAmount(stat.getTransferAmount() + info.getLessonMoney());
            stat.setTransferNormalNumber(stat.getTransferNormalNumber() + (long)info.getLessonCount().intValue());
        }
    }

    private void addTransferData(TxTransferClassRecord record, KexiaoStatistics stat) {
        if (stat.getCompleteStatus() == 0) {
            stat.setTransferAmount(stat.getTransferAmount() + (long)record.getLessonMoney().intValue());
            stat.setTransferNormalNumber(stat.getTransferNormalNumber() + (long)record.getRealLessonCount().intValue());
            stat.setTransferFreeNumber(stat.getTransferFreeNumber() + (long)record.getFreeLessonCount().intValue());
        }
    }

    @Override
    public Map<Long, KexiaoStatistics> queryKexiaoStatByClassIds(Long orgId, Collection<Long> classIds) {
        Map<Long, Long> classIdToCourseId = this.courseApiService.mapClassIdToCourseId(classIds);
        List signupCourseList = this.signupCourseDao.getByCourseIdsAndStudentIds(orgId, null, classIdToCourseId.values(), null, new String[0]);
        Map<Long, KexiaoSignupCourseStat> statMap = this.queryKexiaoStatBySignUpCourseIds(signupCourseList);
        HashMap<Long, KexiaoStatistics> ret = new HashMap<Long, KexiaoStatistics>();
        Set<Long> keySet = statMap.keySet();
        for (Long id : keySet) {
            KexiaoSignupCourseStat stat = statMap.get(id);
            log.debug("[KexiaoSignupCourseStat] KexiaoSignupCourseStat={}", (Object)stat);
            KexiaoStatistics existStat = (KexiaoStatistics)ret.get(stat.getClassId());
            if (existStat == null) {
                existStat = new KexiaoStatistics();
                BeanUtils.copyProperties((Object)stat, (Object)existStat);
                ret.put(stat.getClassId(), existStat);
                continue;
            }
            existStat.setContractNumber(existStat.getContractNumber() + stat.getContractNumber());
            existStat.setContractAmount(existStat.getContractAmount() + stat.getContractAmount());
            existStat.setCompleteOrderNumber(existStat.getCompleteOrderNumber() + stat.getCompleteOrderNumber());
            existStat.setCompleteOrderAmount(existStat.getCompleteOrderAmount() + stat.getCompleteOrderAmount());
            existStat.setArrangeNormalNumber(existStat.getArrangeNormalNumber() + stat.getArrangeNormalNumber());
            existStat.setArrangeNormalAmount(existStat.getArrangeNormalAmount() + stat.getArrangeNormalAmount());
            existStat.setArrangeFreeNumber(existStat.getArrangeFreeNumber() + stat.getArrangeFreeNumber());
            existStat.setCancelNormalNumber(existStat.getCancelNormalNumber() + stat.getCancelNormalNumber());
            existStat.setCancelFreeNumber(existStat.getCancelFreeNumber() + stat.getCancelFreeNumber());
            existStat.setRefundAmount(existStat.getRefundAmount() + stat.getRefundAmount());
            existStat.setRefundNormalNumber(existStat.getRefundNormalNumber() + stat.getRefundNormalNumber());
            existStat.setRefundFreeNumber(existStat.getRefundFreeNumber() + stat.getRefundFreeNumber());
            existStat.setTransferAmount(existStat.getTransferAmount() + stat.getTransferAmount());
            existStat.setTransferNormalNumber(existStat.getTransferNormalNumber() + stat.getTransferNormalNumber());
            existStat.setTransferFreeNumber(existStat.getTransferFreeNumber() + stat.getTransferFreeNumber());
            existStat.setKexiaoNormalNumber(existStat.getKexiaoNormalNumber() + stat.getKexiaoNormalNumber());
            existStat.setKexiaoNormalAmount(existStat.getKexiaoNormalAmount() + stat.getKexiaoNormalAmount());
            existStat.setKexiaoFreeNumber(existStat.getKexiaoFreeNumber() + stat.getKexiaoFreeNumber());
        }
        return ret;
    }

    @Override
    public KexiaoStatistics queryKexiaoStatByStudentCourse(long orgId, long userId, long courseId) {
        KexiaoStatistics statistics = new KexiaoStatistics();
        OrgStudentCourse studentCourse = this.studentcourseDao.getStudentCourseByRealCourseId(Long.valueOf(orgId), Long.valueOf(courseId), Long.valueOf(userId));
        if (studentCourse != null) {
            statistics = this.queryKexiaoStatByStudentClass(orgId, userId, studentCourse.getCourseId());
        }
        log.info("KexiaoStatistics queryKexiaoStatByStudentClass ,params={},{},{},result={}", new Object[]{orgId, userId, courseId, statistics});
        return statistics;
    }

    @Override
    public KexiaoStatistics queryKexiaoStatByStudentClass(long orgId, long userId, long classId) {
        OrgStudentCourse studentCourse;
        Long courseId = classId;
        OrgCourse course = (OrgCourse)this.courseDao.getById((Serializable)Long.valueOf(classId), new String[]{"id", "parentId", "isCourse", "isClass", "courseType", "chargeUnit"});
        if (course == null) {
            throw new ParameterException("\u73ed\u7ea7ID\u4e0d\u5b58\u5728!(" + classId + ")");
        }
        courseId = CourseTypeEnum.isOneToOne((Integer)course.getCourseType()) ? course.getParentId() : course.getId();
        List signupCourseList = this.signupCourseDao.getByCourseIdAndStudentId(Long.valueOf(orgId), Long.valueOf(userId), courseId, (Collection)SignupCourseStatus.PAY_SUCCESS);
        List courseLessons = this.signupCourseLessonDao.listLessonsByUserIdAndClassId(Long.valueOf(orgId), Long.valueOf(userId), Long.valueOf(classId), null, null);
        ArrayList<OrgSignupRefund> refundList = this.refundDao.listOrderByUserIdAndCourseId(Long.valueOf(orgId), Long.valueOf(userId), courseId);
        List<Integer> status = Arrays.asList(TransferClassStatus.INIT.getCode(), TransferClassStatus.SUCCESS.getCode());
        List transferClassInfos = this.transferClassInfoDao.listByUserIdAndClassId(Long.valueOf(userId), Long.valueOf(classId), status);
        List transferNumbers = ListUtil.toKeyList((Collection)transferClassInfos, (String)"transferNumber", TxTransferClassInfo.class);
        ArrayList<TxTransferClassRecord> recordList = new ArrayList();
        if (transferNumbers != null && transferNumbers.size() > 0) {
            recordList = this.transferClassRecordDao.listByTransferNumbers((Collection)transferNumbers);
        }
        if ((studentCourse = this.studentcourseDao.listByCourseIdAndUserId(Long.valueOf(orgId), Long.valueOf(classId), Long.valueOf(userId))).getStatus() == 1) {
            for (OrgSignupCourse signupCourse : signupCourseList) {
                OrgSignupRefund refund = new OrgSignupRefund();
                refund.setCreateTime(signupCourse.getCreateTime());
                refund.setSignupPurchaseId(signupCourse.getSignupPurchaseId());
                refund.setRefundLessonCount(Long.valueOf(KexiaoUtil.getClassNumber(signupCourse)));
                refund.setRefundFee(signupCourse.getTotalPayPrice());
                for (OrgSignupRefund signupRefund : refundList) {
                    if (!signupRefund.getSignupPurchaseId().equals(signupCourse.getSignupPurchaseId())) continue;
                    refund.setRefundFee(Long.valueOf(refund.getRefundFee() - signupRefund.getRefundFee() - signupRefund.getRefundPrice()));
                    refund.setRefundLessonCount(Long.valueOf(refund.getRefundLessonCount() - signupRefund.getRefundLessonCount()));
                }
                for (OrgSignupCourseLesson courseLesson : courseLessons) {
                    if (!courseLesson.getSignupCourseId().equals(signupCourse.getId())) continue;
                    refund.setRefundFee(Long.valueOf(refund.getRefundFee() - courseLesson.getAmount()));
                    refund.setRefundLessonCount(Long.valueOf(refund.getRefundLessonCount() - (long)courseLesson.getLessonCount()));
                }
                refundList.add(refund);
            }
        }
        refundList = new ArrayList<OrgSignupRefund>(this.mergeRefund((List<OrgSignupRefund>)refundList));
        KexiaoStatistics statistics = this.createKexiaoStatistics(signupCourseList, courseLessons, refundList, recordList);
        statistics.setUserId(userId);
        statistics.setClassId(classId);
        statistics.setChargeUnit(course.getChargeUnit());
        if (statistics.getCompleteStatus() != 0 || signupCourseList.size() < 1) {
            this.handHistoryArrangeLesson(orgId, userId, classId, statistics);
        }
        if (statistics.getCompleteStatus() != ClassOrderCompleteStatus.COMPLETED.getCode().intValue() || statistics.isHasHistoryRefund()) {
            List studentLessons = this.studentLessonDao.getByUserIdAndClassId(Long.valueOf(orgId), userId, classId, null, new String[0]);
            int kexiaoCount = 0;
            for (OrgStudentLesson studentLesson : studentLessons) {
                if (studentLesson.getKexiaoStatus().intValue() != LessonStatus.FINISHED.getStatus()) continue;
                ++kexiaoCount;
            }
            statistics.setKexiaoNormalNumber(kexiaoCount);
            statistics.setArrangeNormalNumber(studentLessons.size());
        }
        log.info("KexiaoStatistics queryKexiaoStatByStudentClass ,params={},{},{},result={}", new Object[]{orgId, userId, classId, statistics});
        return statistics;
    }

    private Collection<OrgSignupRefund> mergeRefund(List<OrgSignupRefund> refundList) {
        HashMap<Long, OrgSignupRefund> refundMap = new HashMap<Long, OrgSignupRefund>();
        for (OrgSignupRefund refund : refundList) {
            OrgSignupRefund exist = (OrgSignupRefund)refundMap.get(refund.getSignupPurchaseId());
            if (exist != null) {
                exist.setRefundFee(Long.valueOf(refund.getRefundFee() + exist.getRefundFee()));
                exist.setRefundLessonCount(Long.valueOf(refund.getRefundLessonCount() + exist.getRefundLessonCount()));
                exist.setRefundPrice(Long.valueOf(refund.getRefundPrice() + exist.getRefundPrice()));
                exist.setKexiaoCount(Long.valueOf(refund.getKexiaoCount() + exist.getKexiaoCount()));
                exist.setKexiaoMoney(Long.valueOf(refund.getKexiaoMoney() + exist.getKexiaoMoney()));
                continue;
            }
            refundMap.put(refund.getSignupPurchaseId(), refund);
        }
        return refundMap.values();
    }

    private void handHistoryArrangeLesson(long orgId, long userId, long classId, KexiaoStatistics statistics) {
        List lessons = this.studentLessonDao.getByUserIdAndClassId(Long.valueOf(orgId), userId, classId, null, Arrays.asList(LessonType.OTHER.getCode()), new String[0]);
        if (lessons != null && lessons.size() > 0) {
            for (OrgStudentLesson lesson : lessons) {
                if (lesson.getKexiaoStatus().intValue() == LessonStatus.FINISHED.getStatus()) {
                    statistics.setKexiaoNormalNumber(statistics.getKexiaoNormalNumber() + 1L);
                }
                statistics.setArrangeNormalNumber(statistics.getArrangeNormalNumber() + 1L);
            }
        }
    }

    private KexiaoStatistics createKexiaoStatistics(List<OrgSignupCourse> signupCourseList, List<OrgSignupCourseLesson> courseLessons, List<OrgSignupRefund> refundList, List<TxTransferClassRecord> recordList) {
        KexiaoStatistics statistics = new KexiaoStatistics();
        int completeStatus = 0;
        if (signupCourseList != null && signupCourseList.size() > 0) {
            for (OrgSignupCourse signupCourse : signupCourseList) {
                this.addBuyData(signupCourse, statistics);
                if (signupCourse.getLessonCount() >= 1) continue;
                if (signupCourse.getStatus().intValue() != SignupCourseStatus.QUIT_CLASS.getCode()) {
                    completeStatus = 1;
                    continue;
                }
                statistics.setHasHistoryRefund(true);
            }
        }
        Map courseMap = CollectionHelper.toKeyMap(signupCourseList, (String)"signupPurchaseId");
        statistics.setCompleteStatus(completeStatus);
        HashMap<Long, ArrayList<OrgSignupCourseLesson>> lessonsMap = new HashMap<Long, ArrayList<OrgSignupCourseLesson>>();
        if (courseLessons != null && courseLessons.size() > 0) {
            for (OrgSignupCourseLesson lesson : courseLessons) {
                this.addKexiaoData(lesson, statistics);
                if (lesson.getSignupCourseId() <= 0L) continue;
                ArrayList<OrgSignupCourseLesson> lessonList = (ArrayList<OrgSignupCourseLesson>)lessonsMap.get(lesson.getSignupCourseId());
                if (lessonList == null) {
                    lessonList = new ArrayList<OrgSignupCourseLesson>();
                    lessonsMap.put(lesson.getSignupCourseId(), lessonList);
                }
                lessonList.add(lesson);
            }
        }
        if (refundList != null && refundList.size() > 0) {
            for (OrgSignupRefund refund : refundList) {
                OrgSignupCourse signupCourse;
                if (refund.getCreateTime().compareTo(SUPPORT_TIME) >= 0 || (signupCourse = (OrgSignupCourse)courseMap.get(refund.getSignupPurchaseId())) == null) continue;
                this.handleHistoryRefundData(refund, signupCourse, (List)lessonsMap.get(signupCourse.getId()));
            }
            for (OrgSignupRefund refund : refundList) {
                this.addRefundData(refund, statistics);
            }
        }
        if (recordList != null && recordList.size() > 0) {
            for (TxTransferClassRecord record : recordList) {
                this.addTransferData(record, statistics);
            }
        }
        return statistics;
    }

    private void handleHistoryRefundData(OrgSignupRefund refund, OrgSignupCourse signupCourse, List<OrgSignupCourseLesson> courseLessons) {
        log.info("[KexiaoStatistics] handle refund before:{}", (Object)refund);
        if (signupCourse == null && signupCourse.getLessonCount() < 1) {
            return;
        }
        long kexiaoNumber = 0L;
        if (courseLessons != null) {
            for (OrgSignupCourseLesson lesson : courseLessons) {
                if (lesson == null || lesson.getKexiaoStatus() == null || lesson.getLessonType() == null || lesson.getKexiaoStatus() != 1 || lesson.getLessonType() != LessonType.NORMAL.getCode()) continue;
                if (ChargeUnit.isByTime((int)signupCourse.getChargeUnit())) {
                    kexiaoNumber += (long)lesson.getLessonDuration().intValue();
                    continue;
                }
                ++kexiaoNumber;
            }
        }
        long buyNumber = 0L;
        refund.setRefundLessonCount(Long.valueOf((long)KexiaoUtil.getClassNumber(signupCourse) - kexiaoNumber));
        log.info("[KexiaoStatistics] handle refund after:{},signupCourse={},kexiaoNumber={}", new Object[]{refund, signupCourse, kexiaoNumber});
    }

    @Override
    public Map<Long, KexiaoStatistics> queryKexiaoStatByClassIdAndUserIds(long orgId, long classId, Collection<Long> userIds) {
        HashMap<Long, KexiaoStatistics> ret = new HashMap<Long, KexiaoStatistics>();
        if (userIds == null || userIds.size() < 1) {
            return ret;
        }
        Long courseId = classId;
        OrgCourse course = (OrgCourse)this.courseDao.getById((Serializable)Long.valueOf(classId), new String[]{"id", "parentId", "isCourse", "isClass", "courseType", "chargeUnit"});
        if (course == null) {
            throw new ParameterException("\u73ed\u7ea7ID\u4e0d\u5b58\u5728!(" + classId + ")");
        }
        courseId = CourseTypeEnum.isOneToOne((Integer)course.getCourseType()) ? course.getParentId() : course.getId();
        List signupCourseList = this.signupCourseDao.searchByUserIdsAndClassId(userIds, Long.valueOf(classId), Long.valueOf(orgId), (Collection)SignupCourseStatus.PAY_SUCCESS);
        HashMap signupCourseMap = new HashMap();
        for (OrgSignupCourse signupCourse : signupCourseList) {
            List list = (List)signupCourseMap.get(signupCourse.getUserId());
            if (list == null) {
                list = new ArrayList();
                signupCourseMap.put(signupCourse.getUserId(), list);
            }
            list.add(signupCourse);
        }
        HashMap courseLessonMap = new HashMap();
        List courseLessons = this.signupCourseLessonDao.listByUserIdsAndClassId(userIds, classId, null);
        for (OrgSignupCourseLesson courseLesson : courseLessons) {
            List list = (List)courseLessonMap.get(courseLesson.getUserId());
            if (list == null) {
                list = new ArrayList();
                courseLessonMap.put(courseLesson.getUserId(), list);
            }
            list.add(courseLesson);
        }
        List refundList = this.refundDao.listOrderByUserIdsAndCourseId(Long.valueOf(orgId), userIds, courseId);
        HashMap<Long, ArrayList<OrgSignupRefund>> refundMap = new HashMap<Long, ArrayList<OrgSignupRefund>>();
        for (OrgSignupRefund refund : refundList) {
            ArrayList<OrgSignupRefund> list = (ArrayList<OrgSignupRefund>)refundMap.get(refund.getUserId());
            if (list == null) {
                list = new ArrayList<OrgSignupRefund>();
                refundMap.put(refund.getUserId(), list);
            }
            list.add(refund);
        }
        Map<Long, List<TxTransferClassRecord>> recordMap = this.getTxTransferClassRecordList(userIds, classId);
        for (Long userId : userIds) {
            KexiaoStatistics statistics = this.createKexiaoStatistics((List)signupCourseMap.get(userId), (List)courseLessonMap.get(userId), (List)refundMap.get(userId), recordMap.get(userId));
            statistics.setUserId(userId);
            statistics.setClassId(classId);
            statistics.setChargeUnit(course.getChargeUnit());
            statistics.setUserId(userId);
            statistics.setClassId(classId);
            statistics.setChargeUnit(course.getChargeUnit());
            ret.put(userId, statistics);
        }
        return ret;
    }

    @Override
    public Map<Long, KexiaoSignupCourseStat> queryKexiaoStatBySignUpCourseIds(Collection<OrgSignupCourse> signupCourseList) {
        if (signupCourseList == null || signupCourseList.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        Map courseMap = CollectionHelper.toKeyMap(signupCourseList, (String)"signupPurchaseId");
        List signupCourseIds = ListUtil.toKeyList(signupCourseList, (String)"id", OrgSignupCourse.class);
        List purchaseIds = ListUtil.toKeyList(signupCourseList, (String)"signupPurchaseId", OrgSignupCourse.class);
        List arrangedList = this.signupCourseLessonDao.listBySignupCourseIds((Collection)signupCourseIds, LessonType.FREE.getCode(), null);
        HashMap<Long, OrgSignupCourseLesson> arrangedFreeMap = new HashMap<Long, OrgSignupCourseLesson>();
        for (OrgSignupCourseLesson lesson : arrangedList) {
            arrangedFreeMap.put(lesson.getSignupCourseId(), lesson);
        }
        List normalList = this.signupCourseLessonDao.listBySignupCourseIds((Collection)signupCourseIds, LessonType.NORMAL.getCode(), null);
        HashMap<Long, OrgSignupCourseLesson> arrangedNormalMap = new HashMap<Long, OrgSignupCourseLesson>();
        for (OrgSignupCourseLesson lesson : normalList) {
            arrangedNormalMap.put(lesson.getSignupCourseId(), lesson);
        }
        List freeKexiaoList = this.signupCourseLessonDao.listBySignupCourseIds((Collection)signupCourseIds, LessonType.FREE.getCode(), Integer.valueOf(LessonStatus.FINISHED.getStatus()));
        HashMap<Long, OrgSignupCourseLesson> freeKexiaoMap = new HashMap<Long, OrgSignupCourseLesson>();
        for (OrgSignupCourseLesson lesson : freeKexiaoList) {
            freeKexiaoMap.put(lesson.getSignupCourseId(), lesson);
        }
        List kexiaoList = this.signupCourseLessonDao.listBySignupCourseIds((Collection)signupCourseIds, LessonType.NORMAL.getCode(), Integer.valueOf(LessonStatus.FINISHED.getStatus()));
        HashMap<Long, ArrayList<OrgSignupCourseLesson>> lessonsMap = new HashMap<Long, ArrayList<OrgSignupCourseLesson>>();
        HashMap<Long, OrgSignupCourseLesson> normalKexiaoMap = new HashMap<Long, OrgSignupCourseLesson>();
        for (OrgSignupCourseLesson lesson : kexiaoList) {
            normalKexiaoMap.put(lesson.getSignupCourseId(), lesson);
            if (lesson.getSignupCourseId() <= 0L) continue;
            ArrayList<OrgSignupCourseLesson> lessonList = (ArrayList<OrgSignupCourseLesson>)lessonsMap.get(lesson.getSignupCourseId());
            if (lessonList == null) {
                lessonList = new ArrayList<OrgSignupCourseLesson>();
                lessonsMap.put(lesson.getSignupCourseId(), lessonList);
            }
            lessonList.add(lesson);
        }
        List<Integer> status = Arrays.asList(TransferClassStatus.SUCCESS.getCode(), TransferClassStatus.INIT.getCode());
        Map purchaseTransferMap = this.transferClassRecordDao.groupByPurchaseIds((Collection)purchaseIds, status);
        List refunds = this.refundDao.getByPurcahseIds(new HashSet(purchaseIds));
        HashMap<String, OrgSignupRefund> refundMap = new HashMap<String, OrgSignupRefund>();
        for (OrgSignupRefund refund : refunds) {
            String key;
            OrgSignupRefund tmp;
            OrgSignupCourse signupCourse;
            if (refund.getCreateTime().compareTo(SUPPORT_TIME) < 0 && (signupCourse = (OrgSignupCourse)courseMap.get(refund.getSignupPurchaseId())) != null) {
                this.handleHistoryRefundData(refund, signupCourse, (List)lessonsMap.get(signupCourse.getId()));
            }
            if ((tmp = (OrgSignupRefund)refundMap.get(key = refund.getSignupPurchaseId() + "_" + refund.getClassId())) == null) {
                refundMap.put(key, refund);
                continue;
            }
            tmp.setRefundFee(Long.valueOf(tmp.getRefundFee() + tmp.getRefundPrice() + refund.getRefundFee() + refund.getRefundPrice()));
            tmp.setRefundLessonCount(Long.valueOf(tmp.getRefundLessonCount() + refund.getRefundLessonCount()));
        }
        log.info("[SignupCourseLesson] refundMap={}", refundMap);
        HashMap<Long, KexiaoSignupCourseStat> ret = new HashMap<Long, KexiaoSignupCourseStat>();
        for (OrgSignupCourse signupCourse : signupCourseList) {
            String key = signupCourse.getSignupPurchaseId() + "_" + signupCourse.getClassId();
            KexiaoSignupCourseStat stat = new KexiaoSignupCourseStat();
            KexiaoStatisticsBuilder builder = new KexiaoStatisticsBuilder(stat);
            builder.addSignupCourse(signupCourse).addArrangedNormalLesson((OrgSignupCourseLesson)arrangedNormalMap.get(signupCourse.getId())).addArrangedFreeLesson((OrgSignupCourseLesson)arrangedFreeMap.get(signupCourse.getId())).addKexiaoFreeLesson((OrgSignupCourseLesson)freeKexiaoMap.get(signupCourse.getId())).addKexiaoNormalLesson((OrgSignupCourseLesson)normalKexiaoMap.get(signupCourse.getId())).addTransferRecord((TxTransferClassRecord)purchaseTransferMap.get(key)).addRefundRecord((OrgSignupRefund)refundMap.get(key));
            builder.build();
            stat.setStatus(signupCourse.getStatus());
            stat.setPurchaseId(signupCourse.getSignupPurchaseId());
            ret.put(signupCourse.getId(), stat);
        }
        return ret;
    }

    @Override
    public OrgSignupCourseLesson querySignupCourseLessonInfo(Long signupCouseId, Long lessonId) {
        Map lessonMap = this.signupCourseLessonDao.listBySignupCourseIdAndLessonId(Arrays.asList(signupCouseId), Arrays.asList(lessonId));
        return (OrgSignupCourseLesson)lessonMap.get(signupCouseId + "_" + lessonId);
    }

    @Override
    public Map<Long, List<OrgSignupCourseLesson>> queryLessonSignupCourseList(Collection<Long> lessonIds, Long userId) {
        List lessons = this.signupCourseLessonDao.listByUserIdAndLessonId(Arrays.asList(userId), lessonIds, null);
        HashMap<Long, List<OrgSignupCourseLesson>> ret = new HashMap<Long, List<OrgSignupCourseLesson>>();
        for (OrgSignupCourseLesson lesson : lessons) {
            ArrayList<OrgSignupCourseLesson> list = (ArrayList<OrgSignupCourseLesson>)ret.get(lesson.getId());
            if (list == null) {
                list = new ArrayList<OrgSignupCourseLesson>();
            }
            list.add(lesson);
        }
        return ret;
    }

    public StudentCourseKexiaoDocument finishCountMoney1(Long orgId, Long courseId, Long userId, Long signupCourseId, List<Integer> status) {
        List signupCourseList = this.signupCourseDao.getByCourseIdAndStudentId(orgId, userId, courseId, status);
        Map signupCourseMap = CollectionHelper.toKeyMap((Collection)signupCourseList, (String)"id");
        Map<Object, Object> courseStatMap = new HashMap();
        if (signupCourseId != null && signupCourseId > 0L) {
            if (signupCourseMap.keySet().contains(signupCourseId)) {
                courseStatMap = this.queryKexiaoStatBySignUpCourseIds(Arrays.asList((OrgSignupCourse)signupCourseMap.get(signupCourseId)));
            }
        } else {
            courseStatMap = this.queryKexiaoStatBySignUpCourseIds(signupCourseList);
        }
        StudentCourseKexiaoDocument doc = new StudentCourseKexiaoDocument();
        if (courseStatMap != null && courseStatMap.size() > 0) {
            for (KexiaoStatistics kexiaoStatistics : courseStatMap.values()) {
                log.debug("StudentCourseKexiaoDocument =={},{},{}", new Object[]{kexiaoStatistics, kexiaoStatistics.getLeftAmount(), kexiaoStatistics.getLeftNumber()});
                if (ChargeUnit.isByTime((int)kexiaoStatistics.getChargeUnit())) {
                    doc.setFinishTime(Long.valueOf(doc.getFinishTime() + kexiaoStatistics.getKexiaoNumber() + kexiaoStatistics.getTransferNumber() + kexiaoStatistics.getRefundNumber()));
                    doc.setNormalTime(Long.valueOf(doc.getNormalTime() + kexiaoStatistics.getKexiaoNormalNumber() + kexiaoStatistics.getTransferNormalNumber() + kexiaoStatistics.getRefundNormalNumber()));
                } else {
                    doc.setFinishCount(Long.valueOf(doc.getFinishCount() + kexiaoStatistics.getKexiaoNumber() + kexiaoStatistics.getTransferNumber() + kexiaoStatistics.getRefundNumber()));
                    doc.setNormalCount(Long.valueOf(doc.getNormalCount() + kexiaoStatistics.getKexiaoNormalNumber() + kexiaoStatistics.getTransferNormalNumber() + kexiaoStatistics.getRefundNormalNumber()));
                }
                doc.setFinishMoney(Long.valueOf(kexiaoStatistics.getKexiaoAmount() + kexiaoStatistics.getTransferAmount() + kexiaoStatistics.getRefundAmount()));
            }
        }
        return doc;
    }

    @Override
    public StudentCourseKexiaoDocument finishCountMoney(Long orgId, Long courseId, Long userId, Long signupCourseId, List<Integer> status) {
        this.finishCountMoney1(orgId, courseId, userId, signupCourseId, null);
        log.info("StudentCourseKexiaoDocument finishCountMoney = {},{},{},{}", new Object[]{orgId, courseId, userId, signupCourseId, status});
        StudentCourseKexiaoDocument kexiaoDocument = this.orgStudentKexiaoRecordDao.finishCountMoney(orgId, courseId, userId, signupCourseId, status);
        List signupCourseList = this.signupCourseDao.getByCourseIdAndStudentId(orgId, userId, courseId, status);
        log.debug("StudentCourseKexiaoDocument signupCourseList = {},{}", (Object)signupCourseList, (Object)kexiaoDocument);
        ArrayList outPurchaseIds = Lists.newArrayList();
        Long classId = 0L;
        for (OrgSignupCourse signupCourse : signupCourseList) {
            classId = signupCourse.getClassId();
            if (signupCourseId != null) {
                if (signupCourse.getId().longValue() != signupCourseId.longValue()) continue;
                outPurchaseIds.add(signupCourse.getSignupPurchaseId());
                break;
            }
            outPurchaseIds.add(signupCourse.getSignupPurchaseId());
        }
        if (CollectionUtils.isEmpty((Collection)outPurchaseIds)) {
            return kexiaoDocument;
        }
        TxTransferClassRecord txTransferClassRecord = this.transferClassRecordDao.sumByPurchases((List)outPurchaseIds, classId);
        log.debug("StudentCourseKexiaoDocument txTransferClassRecord=={}", (Object)txTransferClassRecord);
        if (txTransferClassRecord != null && txTransferClassRecord.getChargeUnit() != null) {
            if (txTransferClassRecord.getChargeUnit() != null && txTransferClassRecord.getChargeUnit().intValue() == ChargeUnit.BY_TIMES.getCode()) {
                kexiaoDocument.setFinishCount(Long.valueOf(kexiaoDocument.getFinishCount() + txTransferClassRecord.getTransferLessonCount().longValue()));
            } else {
                kexiaoDocument.setFinishTime(Long.valueOf(kexiaoDocument.getFinishTime() + txTransferClassRecord.getTransferLessonCount().longValue()));
            }
            kexiaoDocument.setFinishMoney(Long.valueOf(kexiaoDocument.getFinishMoney() + (long)txTransferClassRecord.getLessonMoney().intValue()));
        }
        return kexiaoDocument;
    }

    @Override
    public void fillKexiaoData(KexiaoStatisticsSuper dto, KexiaoStatistics statistics) {
        String remainTuition = this.getLeftAmountStr(statistics);
        dto.setRemainTuition(remainTuition);
        if (statistics.getCompleteStatus() != ClassOrderCompleteStatus.COMPLETED.getCode().intValue() && !statistics.isHasHistoryRefund()) {
            dto.setTotalClassTimesForKexiaoValue(0);
            dto.setLeftClassTimesForKexiaoValue(0);
            dto.setFinishClassTimesForKexiaoValue(0);
            dto.setTotalClassTimesForKexiao("--");
            dto.setLeftClassTimesForKexiao("--");
            dto.setBuyClassTimesForKexiao("--");
        } else {
            dto.setTotalClassTimesForKexiaoValue((int)statistics.getTotalNumber());
            dto.setLeftClassTimesForKexiaoValue((int)statistics.getLeftNumber());
            dto.setFinishClassTimesForKexiaoValue((int)statistics.getKexiaoNumber());
            if (ChargeUnit.isByTime((int)statistics.getChargeUnit())) {
                dto.setTotalClassTimesForKexiao(KexiaoUtil.classHourFormat(statistics.getTotalNumber()));
                dto.setLeftClassTimesForKexiao(KexiaoUtil.classHourFormat(statistics.getLeftNumber()));
                dto.setFinishClassTimesForKexiao(KexiaoUtil.classHourFormat(statistics.getKexiaoNumber()));
                dto.setBuyClassTimesForKexiao(KexiaoUtil.classHourFormat(statistics.getBuyNumber()));
                log.info("[KexiaoData] dto={}", (Object)dto);
            } else {
                long leftNum = statistics.getTotalNumber() - statistics.getKexiaoNumber();
                dto.setTotalClassTimesForKexiao(String.valueOf(statistics.getTotalNumber()));
                dto.setLeftClassTimesForKexiao(String.valueOf(leftNum));
                dto.setFinishClassTimesForKexiao(String.valueOf(statistics.getKexiaoNumber()));
                dto.setBuyClassTimesForKexiao(String.valueOf(statistics.getBuyNumber()));
                log.info("[KexiaoData] dto={}", (Object)dto);
            }
        }
    }
}

