/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.common.dto.kexiao;

import com.baijia.tianxiao.constant.LessonStatus;
import com.baijia.tianxiao.constant.LessonType;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.finance.po.TxTransferClassRecord;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourseLesson;
import com.baijia.tianxiao.dal.signup.po.OrgSignupRefund;
import com.baijia.tianxiao.sal.common.dto.kexiao.KexiaoStatistics;
import com.baijia.tianxiao.sal.common.utils.KexiaoUtil;

public class KexiaoStudentStat
extends KexiaoStatistics {
    private long contractCount;
    private long contractTime;
    private long completeOrderCount;
    private long completeOrderTime;
    private long arrangeNormalCount;
    private long arrangeNormalTime;
    private long arrangeFreeCount;
    private long arrangeFreeTime;
    private long refundFreeCount;
    private long refundFreeTime;
    private long refundNormalCount;
    private long refundNormalTime;
    private long transferFreeCount;
    private long transferFreeTime;
    private long transferNormalCount;
    private long transferNormalTime;
    private long kexiaoNormalCount;
    private long kexiaoNormalTime;
    private long kexiaoFreeCount;
    private long kexiaoFreeTime;

    public void splitContractNumber(OrgSignupCourse signupCourse) {
        if (ChargeUnit.isByTime((int)this.getChargeUnit())) {
            this.contractTime += (long)KexiaoUtil.getClassNumber(signupCourse);
        } else {
            this.contractCount += (long)signupCourse.getLessonCount().intValue();
        }
        if (signupCourse.getLessonCount() > 0) {
            if (ChargeUnit.isByTime((int)this.getChargeUnit())) {
                this.completeOrderTime += (long)KexiaoUtil.getClassNumber(signupCourse);
            } else {
                this.completeOrderCount += (long)signupCourse.getLessonCount().intValue();
            }
        }
    }

    public void splitRefundNumber(OrgSignupRefund refund) {
        if (ChargeUnit.isByTime((int)this.getChargeUnit())) {
            this.refundNormalTime += refund.getRefundLessonCount().longValue();
        } else {
            this.refundNormalCount += refund.getRefundLessonCount().longValue();
        }
    }

    public void splitTransferNumber(TxTransferClassRecord record) {
        if (ChargeUnit.isByTime((int)this.getChargeUnit())) {
            this.transferNormalTime += (long)record.getRealLessonCount().intValue();
            this.transferFreeTime += (long)record.getFreeLessonCount().intValue();
        } else {
            this.transferNormalCount += (long)record.getRealLessonCount().intValue();
            this.transferFreeCount += (long)record.getFreeLessonCount().intValue();
        }
    }

    public void splitKexiaoNumber(OrgSignupCourseLesson lesson) {
        if (ChargeUnit.isByTime((int)this.getChargeUnit())) {
            if (lesson.getLessonType() == LessonType.NORMAL.getCode()) {
                if (lesson.getKexiaoStatus().intValue() == LessonStatus.FINISHED.getStatus()) {
                    this.kexiaoNormalTime += (long)lesson.getLessonDuration().intValue();
                }
                this.arrangeNormalTime += (long)lesson.getLessonDuration().intValue();
            } else if (lesson.getLessonType() == LessonType.FREE.getCode()) {
                if (lesson.getKexiaoStatus().intValue() == LessonStatus.FINISHED.getStatus()) {
                    this.kexiaoFreeTime += (long)lesson.getLessonDuration().intValue();
                }
                this.arrangeFreeTime += (long)lesson.getLessonDuration().intValue();
            }
        } else if (lesson.getLessonType() == LessonType.NORMAL.getCode()) {
            if (lesson.getKexiaoStatus().intValue() == LessonStatus.FINISHED.getStatus()) {
                ++this.kexiaoNormalCount;
            }
            ++this.arrangeNormalCount;
        } else if (lesson.getLessonType() == LessonType.FREE.getCode()) {
            if (lesson.getKexiaoStatus().intValue() == LessonStatus.FINISHED.getStatus()) {
                ++this.kexiaoFreeCount;
            }
            ++this.arrangeFreeCount;
        }
    }

    public long getContractCount() {
        return this.contractCount;
    }

    public long getContractTime() {
        return this.contractTime;
    }

    public long getCompleteOrderCount() {
        return this.completeOrderCount;
    }

    public long getCompleteOrderTime() {
        return this.completeOrderTime;
    }

    public long getArrangeNormalCount() {
        return this.arrangeNormalCount;
    }

    public long getArrangeNormalTime() {
        return this.arrangeNormalTime;
    }

    public long getArrangeFreeCount() {
        return this.arrangeFreeCount;
    }

    public long getArrangeFreeTime() {
        return this.arrangeFreeTime;
    }

    public long getRefundFreeCount() {
        return this.refundFreeCount;
    }

    public long getRefundFreeTime() {
        return this.refundFreeTime;
    }

    public long getRefundNormalCount() {
        return this.refundNormalCount;
    }

    public long getRefundNormalTime() {
        return this.refundNormalTime;
    }

    public long getTransferFreeCount() {
        return this.transferFreeCount;
    }

    public long getTransferFreeTime() {
        return this.transferFreeTime;
    }

    public long getTransferNormalCount() {
        return this.transferNormalCount;
    }

    public long getTransferNormalTime() {
        return this.transferNormalTime;
    }

    public long getKexiaoNormalCount() {
        return this.kexiaoNormalCount;
    }

    public long getKexiaoNormalTime() {
        return this.kexiaoNormalTime;
    }

    public long getKexiaoFreeCount() {
        return this.kexiaoFreeCount;
    }

    public long getKexiaoFreeTime() {
        return this.kexiaoFreeTime;
    }

    public void setContractCount(long contractCount) {
        this.contractCount = contractCount;
    }

    public void setContractTime(long contractTime) {
        this.contractTime = contractTime;
    }

    public void setCompleteOrderCount(long completeOrderCount) {
        this.completeOrderCount = completeOrderCount;
    }

    public void setCompleteOrderTime(long completeOrderTime) {
        this.completeOrderTime = completeOrderTime;
    }

    public void setArrangeNormalCount(long arrangeNormalCount) {
        this.arrangeNormalCount = arrangeNormalCount;
    }

    public void setArrangeNormalTime(long arrangeNormalTime) {
        this.arrangeNormalTime = arrangeNormalTime;
    }

    public void setArrangeFreeCount(long arrangeFreeCount) {
        this.arrangeFreeCount = arrangeFreeCount;
    }

    public void setArrangeFreeTime(long arrangeFreeTime) {
        this.arrangeFreeTime = arrangeFreeTime;
    }

    public void setRefundFreeCount(long refundFreeCount) {
        this.refundFreeCount = refundFreeCount;
    }

    public void setRefundFreeTime(long refundFreeTime) {
        this.refundFreeTime = refundFreeTime;
    }

    public void setRefundNormalCount(long refundNormalCount) {
        this.refundNormalCount = refundNormalCount;
    }

    public void setRefundNormalTime(long refundNormalTime) {
        this.refundNormalTime = refundNormalTime;
    }

    public void setTransferFreeCount(long transferFreeCount) {
        this.transferFreeCount = transferFreeCount;
    }

    public void setTransferFreeTime(long transferFreeTime) {
        this.transferFreeTime = transferFreeTime;
    }

    public void setTransferNormalCount(long transferNormalCount) {
        this.transferNormalCount = transferNormalCount;
    }

    public void setTransferNormalTime(long transferNormalTime) {
        this.transferNormalTime = transferNormalTime;
    }

    public void setKexiaoNormalCount(long kexiaoNormalCount) {
        this.kexiaoNormalCount = kexiaoNormalCount;
    }

    public void setKexiaoNormalTime(long kexiaoNormalTime) {
        this.kexiaoNormalTime = kexiaoNormalTime;
    }

    public void setKexiaoFreeCount(long kexiaoFreeCount) {
        this.kexiaoFreeCount = kexiaoFreeCount;
    }

    public void setKexiaoFreeTime(long kexiaoFreeTime) {
        this.kexiaoFreeTime = kexiaoFreeTime;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KexiaoStudentStat)) {
            return false;
        }
        KexiaoStudentStat other = (KexiaoStudentStat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getContractCount() != other.getContractCount()) {
            return false;
        }
        if (this.getContractTime() != other.getContractTime()) {
            return false;
        }
        if (this.getCompleteOrderCount() != other.getCompleteOrderCount()) {
            return false;
        }
        if (this.getCompleteOrderTime() != other.getCompleteOrderTime()) {
            return false;
        }
        if (this.getArrangeNormalCount() != other.getArrangeNormalCount()) {
            return false;
        }
        if (this.getArrangeNormalTime() != other.getArrangeNormalTime()) {
            return false;
        }
        if (this.getArrangeFreeCount() != other.getArrangeFreeCount()) {
            return false;
        }
        if (this.getArrangeFreeTime() != other.getArrangeFreeTime()) {
            return false;
        }
        if (this.getRefundFreeCount() != other.getRefundFreeCount()) {
            return false;
        }
        if (this.getRefundFreeTime() != other.getRefundFreeTime()) {
            return false;
        }
        if (this.getRefundNormalCount() != other.getRefundNormalCount()) {
            return false;
        }
        if (this.getRefundNormalTime() != other.getRefundNormalTime()) {
            return false;
        }
        if (this.getTransferFreeCount() != other.getTransferFreeCount()) {
            return false;
        }
        if (this.getTransferFreeTime() != other.getTransferFreeTime()) {
            return false;
        }
        if (this.getTransferNormalCount() != other.getTransferNormalCount()) {
            return false;
        }
        if (this.getTransferNormalTime() != other.getTransferNormalTime()) {
            return false;
        }
        if (this.getKexiaoNormalCount() != other.getKexiaoNormalCount()) {
            return false;
        }
        if (this.getKexiaoNormalTime() != other.getKexiaoNormalTime()) {
            return false;
        }
        if (this.getKexiaoFreeCount() != other.getKexiaoFreeCount()) {
            return false;
        }
        return this.getKexiaoFreeTime() == other.getKexiaoFreeTime();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KexiaoStudentStat;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $contractCount = this.getContractCount();
        result = result * 59 + (int)($contractCount >>> 32 ^ $contractCount);
        long $contractTime = this.getContractTime();
        result = result * 59 + (int)($contractTime >>> 32 ^ $contractTime);
        long $completeOrderCount = this.getCompleteOrderCount();
        result = result * 59 + (int)($completeOrderCount >>> 32 ^ $completeOrderCount);
        long $completeOrderTime = this.getCompleteOrderTime();
        result = result * 59 + (int)($completeOrderTime >>> 32 ^ $completeOrderTime);
        long $arrangeNormalCount = this.getArrangeNormalCount();
        result = result * 59 + (int)($arrangeNormalCount >>> 32 ^ $arrangeNormalCount);
        long $arrangeNormalTime = this.getArrangeNormalTime();
        result = result * 59 + (int)($arrangeNormalTime >>> 32 ^ $arrangeNormalTime);
        long $arrangeFreeCount = this.getArrangeFreeCount();
        result = result * 59 + (int)($arrangeFreeCount >>> 32 ^ $arrangeFreeCount);
        long $arrangeFreeTime = this.getArrangeFreeTime();
        result = result * 59 + (int)($arrangeFreeTime >>> 32 ^ $arrangeFreeTime);
        long $refundFreeCount = this.getRefundFreeCount();
        result = result * 59 + (int)($refundFreeCount >>> 32 ^ $refundFreeCount);
        long $refundFreeTime = this.getRefundFreeTime();
        result = result * 59 + (int)($refundFreeTime >>> 32 ^ $refundFreeTime);
        long $refundNormalCount = this.getRefundNormalCount();
        result = result * 59 + (int)($refundNormalCount >>> 32 ^ $refundNormalCount);
        long $refundNormalTime = this.getRefundNormalTime();
        result = result * 59 + (int)($refundNormalTime >>> 32 ^ $refundNormalTime);
        long $transferFreeCount = this.getTransferFreeCount();
        result = result * 59 + (int)($transferFreeCount >>> 32 ^ $transferFreeCount);
        long $transferFreeTime = this.getTransferFreeTime();
        result = result * 59 + (int)($transferFreeTime >>> 32 ^ $transferFreeTime);
        long $transferNormalCount = this.getTransferNormalCount();
        result = result * 59 + (int)($transferNormalCount >>> 32 ^ $transferNormalCount);
        long $transferNormalTime = this.getTransferNormalTime();
        result = result * 59 + (int)($transferNormalTime >>> 32 ^ $transferNormalTime);
        long $kexiaoNormalCount = this.getKexiaoNormalCount();
        result = result * 59 + (int)($kexiaoNormalCount >>> 32 ^ $kexiaoNormalCount);
        long $kexiaoNormalTime = this.getKexiaoNormalTime();
        result = result * 59 + (int)($kexiaoNormalTime >>> 32 ^ $kexiaoNormalTime);
        long $kexiaoFreeCount = this.getKexiaoFreeCount();
        result = result * 59 + (int)($kexiaoFreeCount >>> 32 ^ $kexiaoFreeCount);
        long $kexiaoFreeTime = this.getKexiaoFreeTime();
        result = result * 59 + (int)($kexiaoFreeTime >>> 32 ^ $kexiaoFreeTime);
        return result;
    }

    @Override
    public String toString() {
        return "KexiaoStudentStat(contractCount=" + this.getContractCount() + ", contractTime=" + this.getContractTime() + ", completeOrderCount=" + this.getCompleteOrderCount() + ", completeOrderTime=" + this.getCompleteOrderTime() + ", arrangeNormalCount=" + this.getArrangeNormalCount() + ", arrangeNormalTime=" + this.getArrangeNormalTime() + ", arrangeFreeCount=" + this.getArrangeFreeCount() + ", arrangeFreeTime=" + this.getArrangeFreeTime() + ", refundFreeCount=" + this.getRefundFreeCount() + ", refundFreeTime=" + this.getRefundFreeTime() + ", refundNormalCount=" + this.getRefundNormalCount() + ", refundNormalTime=" + this.getRefundNormalTime() + ", transferFreeCount=" + this.getTransferFreeCount() + ", transferFreeTime=" + this.getTransferFreeTime() + ", transferNormalCount=" + this.getTransferNormalCount() + ", transferNormalTime=" + this.getTransferNormalTime() + ", kexiaoNormalCount=" + this.getKexiaoNormalCount() + ", kexiaoNormalTime=" + this.getKexiaoNormalTime() + ", kexiaoFreeCount=" + this.getKexiaoFreeCount() + ", kexiaoFreeTime=" + this.getKexiaoFreeTime() + ")";
    }
}

