/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.common.impl;

import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.sal.common.api.AccountApiService;
import com.baijia.tianxiao.util.ListUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AccountApiServiceImpl
implements AccountApiService {
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Resource
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgSubAccountDao subAccountDao;
    @Autowired
    private TXCascadeCredentialDao credentialDao;

    @Override
    public String getAccountName(Long orgId, Long cascadeId) {
        String shortName = "\u672a\u77e5";
        if (cascadeId > 0L) {
            TXCascadeAccount txCascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)cascadeId, new String[0]);
            TXCascadeCredential credential = (TXCascadeCredential)this.txCascadeCredentialDao.getById((Serializable)txCascadeAccount.getCredentialId(), new String[0]);
            shortName = credential.getName();
        } else {
            OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[0]);
            shortName = orgInfo.getContacts();
        }
        return shortName;
    }

    @Override
    public Map<Long, String> getAccountNameMap(Long orgId, Collection<Integer> cascadeIds) {
        Map map = this.credentialDao.getTxCascadCredentialListByCascdeIds(cascadeIds);
        if (cascadeIds.contains(0)) {
            OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[0]);
            map.put(0L, orgInfo.getContacts());
        }
        return map;
    }

    @Override
    public List<Integer> getAllTxOrgIds() {
        List accounts = this.subAccountDao.getAll(new String[]{"orgId"});
        List list = ListUtil.toKeyList((Collection)accounts, (String)"orgId", OrgSubAccount.class);
        return list;
    }
}

