
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.common.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.sal.common.api.OrganizationInfoAPIService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Nov 29, 2016
 * @Desc this guy is too lazy, nothing left.
 */
@Service
public class OrganizationInfoAPIServiceImpl implements OrganizationInfoAPIService {

    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgInfoDao orgInfoDao;

    public final LoadingCache<Long, OrgAccount> orgInfoCache = CacheBuilder.newBuilder().maximumSize(1000)
        .expireAfterAccess(1, TimeUnit.DAYS).build(new CacheLoader<Long, OrgAccount>() {
            @Override
            public OrgAccount load(Long orgId) throws Exception {
                OrgAccount byId = orgAccountDao.getById(orgId);
                if (byId != null) {
                    return byId;
                }
                return null;
            }
        });

    public final LoadingCache<Long, OrgAccount> orgInfoCacheWithNumber = CacheBuilder.newBuilder().maximumSize(1000)
        .expireAfterAccess(1, TimeUnit.DAYS).build(new CacheLoader<Long, OrgAccount>() {
            @Override
            public OrgAccount load(Long orgNumber) throws Exception {
                ConcurrentMap<Long, OrgAccount> asMap = orgInfoCache.asMap();
                for (OrgAccount oa : asMap.values()) {
                    if (oa.getNumber().equals(orgNumber)) {
                        return oa;
                    }
                }
                OrgAccount byNumber = orgAccountDao.getAccountByNumber(orgNumber.intValue());
                if (byNumber != null) {
                    return byNumber;
                }
                return null;
            }
        });

    @Override
    public OrgAccount findOrgAccountWithOrgId(Long orgId) {
        if (orgId == null) {
            return null;
        }
        try {
            return this.orgInfoCache.get(orgId);
        } catch (ExecutionException e) {
            return this.orgAccountDao.getById(orgId);
        }
    }

    @Override
    public OrgAccount findOrgAccountWithOrgNumber(Long orgNumber) {
        if (orgNumber == null) {
            return null;
        }
        try {
            return this.orgInfoCacheWithNumber.get(orgNumber);
        } catch (ExecutionException e) {
            return this.orgAccountDao.getAccountByNumber(orgNumber.intValue());
        }
    }

    @Override
    public Map<Integer, OrgInfo> getOrgInfoMap(List<Integer> orgIds) {
        if (GenericsUtils.isNullOrEmpty(orgIds)) {
            return GenericsUtils.emptyMap();
        }
        Map<Integer, OrgInfo> data = Maps.newHashMap();
        List<OrgInfo> orgInfos = orgInfoDao.getOrgInfos(orgIds);
        if (CollectionUtils.isNotEmpty(orgInfos)) {
            for (OrgInfo orgInfo : orgInfos) {
                data.put(orgInfo.getOrgId(), orgInfo);
            }
        }
        return data;
    }

}
