package com.baijia.tianxiao.sal.common.impl;

import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.image.AvatarUtil;
import com.baijia.tianxiao.sal.common.api.OrgStudentApiService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.storage.StorageUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * Created by liuxp on 16/12/12.
 */
@Service
public class OrgStudentApiServiceImpl implements OrgStudentApiService {

    @Autowired
    private FansDao fansDao;
    @Autowired
    private OrgStorageDao orgStorageDao;

    @Override                
    public Map<Long, String> batchGetStudentAvatarUrl(Collection<OrgStudent> students) {
        if (students == null || students.size() < 1) {
            return Collections.emptyMap();
        }

        Map<Long, String> map = new HashMap<>();

        Map<Long, OrgStorage> orgStorageMap = new HashMap<>(); // 机构学员上传头像存储与userId映射关系
        Map<String, Fans> fansMap = new HashMap<>();

        Set<Long> orgAvatarIds = new HashSet<>();
        List<String> openIds = new ArrayList<>();
        for (OrgStudent orgStudent : students) {
            Long avatarId = orgStudent.getAvatar();
            String openId = orgStudent.getWeixin();
            
            if (openId!=null && !openId.equals("") && !openId.equals("0")) {
                openIds.add(openId);
            }
            if (GenericsUtils.notNullAndEmpty(avatarId)) {
                orgAvatarIds.add(avatarId);
            }
        }

        if (GenericsUtils.notNullAndEmpty(orgAvatarIds)) {
            orgStorageMap = this.orgStorageDao.getOrgStorageMapByIds(orgAvatarIds);
        }

        // 批量查询用户微信详情
        if (GenericsUtils.notNullAndEmpty(openIds)) {
            fansMap = this.fansDao.mapKeyOpenIdValueFans(openIds);
        }

        for (OrgStudent orgStudent : students) {
            String avatar = buildAvatarUrl(orgStudent, orgStorageMap, fansMap);
            map.put(orgStudent.getId(), avatar);
        }

        return map;
    }

    private String buildAvatarUrl(OrgStudent orgStudent, Map<Long, OrgStorage> orgStorageMap, Map<String, Fans> fansMap) {
        String avatarUrl = null;

        // 用户上传头像
        Long avatarId = orgStudent.getAvatar();
        OrgStorage orgStorage = orgStorageMap.get(avatarId);
        if (GenericsUtils.notNullAndEmpty(orgStorage)) {
            avatarUrl = StorageUtil.constructUrl(orgStorage.getFid(), orgStorage.getSn(), orgStorage.getMimeType());
        }
        // 微信头像
        String openId = orgStudent.getWeixin();
        if (GenericsUtils.isNullOrEmpty(avatarUrl)) {
            if (GenericsUtils.notNullAndEmpty(openId)) {
                Fans fan = fansMap.get(openId);
                if (GenericsUtils.notNullAndEmpty(fan)) {
                    avatarUrl = fan.getHeadImgUrl();
                }
            }
        }
        // 如果头像为空，给予默认头像
        if (GenericsUtils.isNullOrEmpty(avatarUrl)) {
            avatarUrl = AvatarUtil.getUserAvatar(orgStudent.getId());
        }
        return avatarUrl;
    }
}
