package com.baijia.tianxiao.sal.common.impl;

import com.baijia.tianxiao.constant.LessonStatus;
import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.sal.common.api.KexiaoApiService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * Created by lxp on 2017/2/22.
 */
@Service
@Slf4j
public class KexiaoApiServiceImpl implements KexiaoApiService{

    public LessonStatus getKexiaoStatus(OrgLessonSign sign, int rule) {
        int byteCode = 0;
        // 1，签到；2，请假；3，旷课
        if (sign.getStatus() == SignStatus.SIGNED.getCode()) {
            byteCode = 1;
        } else if (sign.getStatus() == SignStatus.LEAVE.getCode()) {
            byteCode = 2;
        } else if (sign.getStatus() == SignStatus.ABSENT.getCode()) {
            byteCode = 4;
        } else {
            log.info("[Kexiao] UnSign.sign={}", sign);
        }
        int result = byteCode & rule;
        if (result > 0) {
            return LessonStatus.FINISHED;
        } else {
            return LessonStatus.UN_START;
        }
    }

    @Override
    public LessonStatus getKexiaoStatus(Date startTime) {
        return startTime.compareTo(new Date())>0?LessonStatus.UN_START:LessonStatus.FINISHED;
    }
}

