/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.common.impl;

import com.baijia.tianxiao.constant.LessonType;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentKexiaoRecordDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudentKexiaoRecord;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseLessonDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourseLesson;
import com.baijia.tianxiao.sal.common.api.StudentCourseApi;
import com.baijia.tianxiao.sal.common.dto.StudentCourseBase;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StudentCourseApiImpl
implements StudentCourseApi {
    private static final Logger log = LoggerFactory.getLogger(StudentCourseApiImpl.class);
    @Autowired
    private OrgCourseDao courseDao;
    @Autowired
    private OrgSignupCourseDao signupCourseDao;
    @Autowired
    private OrgStudentLessonDao lessonDao;
    @Autowired
    private OrgStudentKexiaoRecordDao kexiaoRecordDao;
    @Autowired
    private OrgSignupCourseLessonDao signupCourseLessonDao;
    @Autowired
    private OrgStudentCourseDao studentCourseDao;

    @Override
    public Map<Long, StudentCourseBase> getBuyData(List<Long> userIds, Long courseId, Long orgId) {
        if (userIds == null || userIds.size() < 1) {
            return Collections.EMPTY_MAP;
        }
        List courses = this.studentCourseDao.getByCourseIdsStudentId(orgId, Arrays.asList(courseId), userIds, null, Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        HashMap<Long, StudentCourseBase> retMap = new HashMap<Long, StudentCourseBase>();
        for (OrgStudentCourse course : courses) {
            StudentCourseBase base = new StudentCourseBase();
            ChargeUnit unit = ChargeUnit.getByCode((int)course.getChargeUnit());
            base.setChargeUnit(unit);
            if (ChargeUnit.isByTime((int)course.getChargeUnit())) {
                base.setBuyTime(course.getLessonCount());
            } else {
                base.setBuyCount(course.getLessonCount());
            }
            retMap.put(course.getUserId(), base);
        }
        return retMap;
    }

    private int getDuration(int lessonCount, ChargeUnit unit) {
        switch (unit) {
            case BY_HOUR: {
                return lessonCount * 60;
            }
            case BY_HALF_HOUR: {
                return lessonCount * 30;
            }
        }
        return 0;
    }

    @Override
    public Map<Long, StudentCourseBase> getLessonData(List<Long> userIds, Long classId, Long orgId) {
        if (userIds == null || userIds.size() < 1) {
            return Collections.EMPTY_MAP;
        }
        OrgCourse course = this.courseDao.getByCourseId(classId, new String[]{"id", "chargeUnit"});
        List lessons = this.lessonDao.getByCourseIdsUserIds(orgId, Arrays.asList(classId), userIds, new String[]{"userId", "id", "lessonDuration", "lessonType"});
        HashMap<Long, StudentCourseBase> retMap = new HashMap<Long, StudentCourseBase>();
        for (OrgStudentLesson lesson : lessons) {
            StudentCourseBase base = (StudentCourseBase)retMap.get(lesson.getUserId());
            if (base == null) {
                base = new StudentCourseBase();
                retMap.put(lesson.getUserId(), base);
            }
            base.setLessonCount(base.getLessonCount() + 1);
            base.setLessonTime(base.getLessonTime() + lesson.getLessonDuration());
            base.setChargeUnit(ChargeUnit.getByCode((int)course.getChargeUnit()));
        }
        return retMap;
    }

    @Override
    public Map<Long, StudentCourseBase> getNormalData(List<Long> userIds, Long classId, Long orgId) {
        Map normalLesson = this.signupCourseLessonDao.selectLessonInfoByClassId(orgId, classId, userIds, LessonType.NORMAL.getCode());
        HashMap<Long, StudentCourseBase> retMap = new HashMap<Long, StudentCourseBase>();
        for (OrgSignupCourseLesson lesson : normalLesson.values()) {
            StudentCourseBase base = (StudentCourseBase)retMap.get(lesson.getUserId());
            if (base == null) {
                base = new StudentCourseBase();
                retMap.put(lesson.getUserId(), base);
            }
            base.setLessonNormalCount(base.getLessonNormalCount() + 1);
            base.setLessonNormalTime(base.getLessonNormalTime() + lesson.getLessonDuration());
            base.setChargeUnit(ChargeUnit.getByCode((int)lesson.getChargeUnit()));
        }
        return retMap;
    }

    @Override
    public Map<Long, StudentCourseBase> getFinishData(List<Long> userIds, Long classId, Long orgId) {
        if (userIds == null || userIds.size() < 1) {
            return Collections.EMPTY_MAP;
        }
        List records = this.kexiaoRecordDao.getByCourseIdsAndUserIds(orgId, Arrays.asList(classId), userIds, new String[]{"userId", "id", "lessonDuration", "chargeUnit", "lessonType"});
        HashMap<Long, StudentCourseBase> retMap = new HashMap<Long, StudentCourseBase>();
        for (OrgStudentKexiaoRecord record : records) {
            StudentCourseBase base = (StudentCourseBase)retMap.get(record.getUserId());
            if (base == null) {
                base = new StudentCourseBase();
                retMap.put(record.getUserId(), base);
            }
            base.setFinishCount(base.getFinishTime() + 1);
            base.setFinishTime(base.getFinishCount() + record.getLessonDuration());
            base.setChargeUnit(ChargeUnit.getByCode((int)record.getChargeUnit()));
        }
        return retMap;
    }

    @Override
    public Map<Long, StudentCourseBase> getAllData(List<Long> userIds, Long classId, Long orgId) {
        StudentCourseBase base;
        if (userIds == null || userIds.size() < 1) {
            return Collections.EMPTY_MAP;
        }
        List lessons = this.lessonDao.getByCourseIdsUserIds(orgId, Arrays.asList(classId), userIds, new String[]{"userId", "id", "lessonDuration", "kexiaoStatus"});
        Map normalLesson = this.signupCourseLessonDao.selectLessonInfoByClassId(orgId, classId, userIds, LessonType.NORMAL.getCode());
        OrgCourse orgCourse = (OrgCourse)this.courseDao.getById((Serializable)classId, new String[]{"isClass", "isCourse", "parentId", "chargeUnit"});
        Map<Long, StudentCourseBase> retMap = this.getBuyData(userIds, classId, orgId);
        for (OrgStudentLesson lesson : lessons) {
            base = retMap.get(lesson.getUserId());
            if (base == null) {
                base = new StudentCourseBase();
                retMap.put(lesson.getUserId(), base);
            }
            base.setLessonCount(base.getLessonCount() + 1);
            base.setLessonTime(base.getLessonTime() + lesson.getLessonDuration());
            if (lesson.getKexiaoStatus() == 1) {
                base.setFinishCount(base.getFinishCount() + 1);
                base.setFinishTime(base.getFinishTime() + lesson.getLessonDuration());
            }
            base.setChargeUnit(ChargeUnit.getByCode((int)orgCourse.getChargeUnit()));
        }
        for (OrgStudentLesson lesson : normalLesson.values()) {
            base = retMap.get(lesson.getUserId());
            if (base == null) {
                base = new StudentCourseBase();
                retMap.put(lesson.getUserId(), base);
            }
            base.setLessonNormalCount(base.getLessonNormalCount() + lesson.getLessonCount());
            base.setLessonNormalTime(base.getLessonNormalTime() + lesson.getLessonDuration());
            base.setChargeUnit(ChargeUnit.getByCode((int)lesson.getChargeUnit()));
        }
        return retMap;
    }
}

