/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.common.impl;

import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.dao.OrgCourseConsumeRuleDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseConsumeRule;
import com.baijia.tianxiao.sal.common.api.CourseApiService;
import com.baijia.tianxiao.util.CollectionHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CourseApiServiceImpl
implements CourseApiService {
    private static final Logger log = LoggerFactory.getLogger(CourseApiServiceImpl.class);
    @Autowired
    private OrgCourseDao courseDao;
    @Autowired
    private OrgCourseConsumeRuleDao ruleDao;

    @Override
    public Map<Long, Long> mapClassIdToCourseId(Collection<Long> classIds) {
        HashMap<Long, Long> retMap = new HashMap<Long, Long>();
        List courses = this.courseDao.getByIds(classIds, new String[]{"id", "parentId", "isCourse", "isClass", "courseType"});
        for (OrgCourse course : courses) {
            if (course.getIsClass() == CourseTypeEnum.IS_CLASS_TRUE.getCode() && course.getIsCourse() == CourseTypeEnum.IS_COURSE_FALSE.getCode()) {
                retMap.put(course.getId(), course.getParentId());
                continue;
            }
            retMap.put(course.getId(), course.getId());
        }
        return retMap;
    }

    @Override
    public Map<Long, Long> mapCourseIdToClassId(Collection<Long> classIds) {
        HashMap<Long, Long> retMap = new HashMap<Long, Long>();
        List courses = this.courseDao.getByIds(classIds, new String[]{"id", "parentId", "isCourse", "isClass", "courseType"});
        for (OrgCourse course : courses) {
            long courseId = course.getIsClass() == CourseTypeEnum.IS_CLASS_TRUE.getCode() && course.getIsCourse() == CourseTypeEnum.IS_COURSE_FALSE.getCode() ? course.getParentId().longValue() : course.getId().longValue();
            if (retMap.get(courseId) != null && retMap.get(courseId) != course.getId()) {
                throw new RuntimeException("\u540c\u4e00\u8bfe\u7a0b\u4e0b\u6709\u591a\u4e2a\u73ed\u7ea7");
            }
            retMap.put(courseId, course.getId());
        }
        return retMap;
    }

    @Override
    public Map<Long, OrgCourseConsumeRule> getClassRule(Collection<Long> classIds) {
        Map<Long, Long> classIdToCourseIdMap;
        HashMap<Long, OrgCourseConsumeRule> ret = new HashMap<Long, OrgCourseConsumeRule>();
        if (classIds != null && !classIds.isEmpty() && (classIdToCourseIdMap = this.mapClassIdToCourseId(classIds)) != null && !classIdToCourseIdMap.isEmpty()) {
            List rules = this.ruleDao.queryConsumRuleListByCourseIds(null, classIdToCourseIdMap.values(), new String[0]);
            Map ruleMap = CollectionHelper.toKeyMap((Collection)rules, (String)"courseId");
            for (Long classId : classIds) {
                ret.put(classId, (OrgCourseConsumeRule)ruleMap.get(classIdToCourseIdMap.get(classId)));
            }
        }
        return ret;
    }
}

