/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.common.impl;

import com.baijia.tianxiao.sal.common.impl.BeanLocator;
import com.baijia.tianxiao.util.GenericsUtils;
import java.util.concurrent.ConcurrentHashMap;

public class BeanCache {
    private static ConcurrentHashMap<Class<?>, Object> beanCache = new ConcurrentHashMap();

    public static <T> T getBean(Class<? extends T> clazz) {
        Object bean = beanCache.get(clazz);
        if (bean == null && BeanLocator.isInit()) {
            bean = BeanLocator.getBeanByRquire(clazz);
            BeanCache.registerBean(clazz);
        }
        return (T)bean;
    }

    public static void registerBean(Object bean) {
        beanCache.putIfAbsent(bean.getClass(), bean);
        BeanCache.registerBeanWithInterface(bean.getClass(), bean);
    }

    private static void registerBeanWithInterface(Class<? extends Object> clazz, Object bean) {
        if (clazz.getName().equals("java.lang.Object")) {
            return;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        Class<? extends Object> parentClass = clazz.getSuperclass();
        if (parentClass != null) {
            beanCache.putIfAbsent(parentClass, bean);
            BeanCache.registerBeanWithInterface(parentClass, bean);
        }
        if (GenericsUtils.notNullAndEmpty(interfaces)) {
            for (Class<?> clz : interfaces) {
                beanCache.putIfAbsent(clz, bean);
                BeanCache.registerBeanWithInterface(clz, bean);
            }
        }
    }
}

