/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.common.impl;

import com.baijia.tianxiao.constant.LessonStatus;
import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.sal.common.api.KexiaoApiService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class KexiaoApiServiceImpl
implements KexiaoApiService {
    private static final Logger log = LoggerFactory.getLogger(KexiaoApiServiceImpl.class);

    @Override
    public LessonStatus getKexiaoStatus(OrgLessonSign sign, int rule) {
        int byteCode = 0;
        if (sign.getStatus().intValue() == SignStatus.SIGNED.getCode()) {
            byteCode = 1;
        } else if (sign.getStatus().intValue() == SignStatus.LEAVE.getCode()) {
            byteCode = 2;
        } else if (sign.getStatus().intValue() == SignStatus.ABSENT.getCode()) {
            byteCode = 4;
        } else {
            log.info("[Kexiao] UnSign.sign={}", (Object)sign);
        }
        int result = byteCode & rule;
        if (result > 0) {
            return LessonStatus.FINISHED;
        }
        return LessonStatus.UN_START;
    }

    @Override
    public LessonStatus getKexiaoStatus(Date startTime) {
        return startTime.compareTo(new Date()) > 0 ? LessonStatus.UN_START : LessonStatus.FINISHED;
    }
}

