
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.comment.dto;

import com.baijia.tianxiao.sal.comment.constant.OrgScoreDesc;

import lombok.Data;

/**
 * @title OrgCommentAuditDto
 * @desc 机构评价统计
 * @author shanyu
 * @date 2016年1月22日
 * @version 1.0
 */
@Data
public class OrgCommentAuditDto {
    // 机构得分
    private Double orgScore;

    // 机构口碑
    private String orgDesc;

    // 机构排名
    private Integer rank;

    // 排名统计时间
    private String date;

    // 区域名称
    private String areaName;

    // 学员评价数
    private Integer studentCommentCount;

    // 老师评语数
    private Integer teacherCommentCount;

    // 学员评价率
    private Double studentCommentRate;

    // 学员差评率
    private Double studentLowRate;

    // 老师评价率
    private Double teacherCommentRate;

    public void setOrgScore(Double orgScore) {
        this.orgScore = orgScore;
        this.orgDesc = OrgScoreDesc.getorgDescByScore(orgScore);
    }
}
