
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.comment.service;

import com.baijia.tianxiao.sal.comment.dto.AddCommentReponse;
import com.baijia.tianxiao.sal.comment.dto.CommentInfoDto;
import com.baijia.tianxiao.sal.comment.dto.request.CommentAddRequestDto;
import com.baijia.tianxiao.sal.comment.dto.request.CommentListRequest;
import com.baijia.tianxiao.sal.comment.dto.response.CommentListResponse;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import lombok.NonNull;

/**
 * @author shanyu
 * @version 1.0
 * @title LessonCommentService
 * @desc TODO
 * @date 2016年1月3日
 */

public interface LessonCommentService {

    /**
     * 获取课节学员评价列表
     *
     * @param lessonId 课节id
     * @param orgId    机构ID
     * @param userRole 0,老师；2，学生；
     * @return
     */
    public List<CommentInfoDto> getLessonComments(Long lessonId, Long orgId, Integer userRole);

    /**
     * 学生评价 以及 老师对学生的评价
     *
     * @param orgId
     * @param studentId 或者 老师id
     * @param userRole
     * @param pageDto
     * @return
     */
    List<CommentInfoDto> getLessonCommentsWithLessonInfo(Long orgId, Long studentId, Integer userRole, PageDto pageDto);

    /**
     * 获取评价详情
     *
     * @return
     */
    public CommentInfoDto getCommentDetail(Long commentId, Long orgId);

    /**
     * 获取学员评价／评语
     *
     * @param userRole 角色
     * @param userId   学员userId
     * @param orgId    机构id
     * @return
     */
    public List<CommentInfoDto> getStudentComments(Integer userRole, Long userId, Long orgId,
                                                   Collection<Long> lessonIds, PageDto pageDto);

    /**
     * 添加评价
     *
     * @param dto
     * @param orgId 机构id
     * @return
     */
    public AddCommentReponse addComment(CommentAddRequestDto dto, Long orgId, String studentCommentDetailUrl);
    
    void updateComment(Long orgId, Long commentId, Long fromId, Integer userRole, Integer starScore, String content,
        String storageIds, String customFastComment, String shareUrl);

    /**
     * 某个学生是否对课程评价
     *
     * @param userId
     * @return
     */
    Map<Long, Boolean> getStudentLessonCommentMap(Long userId, Collection<Long> lessonIds);

    CommentInfoDto getCommentDetail(Long commentId, Long orgId, Integer userRole);

    CommentInfoDto getCommentDetail(Long lessonId, Long userId, Long orgId, Integer userRole);

    /**
     * 查询学员评价信息
     *
     * @param courseIds
     * @param teacherIds
     * @param commentReqType
     * @param isSystem
     * @param pageDto
     * @return
     */
    List<CommentInfoDto> queryComments(Long orgId, Collection<Long> courseIds, Collection<Long> teacherIds,
                                       Integer commentReqType, Boolean isSystem, Integer userRole, PageDto pageDto);

    /**
     * 添加默认评价
     */
    void addLessonDefaultComment();

    List<CommentInfoDto> getComments(@NonNull Long orgId, @NonNull Long lessonId, List<Long> fromIds, List<Long> toIds,
                                     @NonNull Integer userRole);

    CommentInfoDto getComment(@NonNull Long orgId, @NonNull Long commentId);

}
