
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.comment.dto;

import com.baijia.tianxiao.sal.comment.constant.Biz;
import com.baijia.tianxiao.sal.comment.constant.CommentReqType;

import java.util.Date;

import lombok.Data;

/**
 * @title CommentInfoDto
 * @desc TODO
 * @author bjhl
 * @date 2016年1月3日
 * @version 1.0
 */
@Data
public class CommentInfoDto {

    /**
     * 评价id
     */
    private Long commentId;
    /*
     * 课节id
     */
    private Long lessonId;

    /**
     * 课节号
     */
    private Integer index;

    /**
     * 课课程名
     */
    private String courseName;

    /**
     * 课程id
     */
    private Long courseId;

    /**
     * 角色
     */
    private Integer userRole;

    private Long fromId;

    private String fromName;

    private String fromAvatar;

    private Long toId;

    private String toName;

    private String toAvatar;
    /*
     * 内容
     */
    private String content;

    /**
     * 图片
     */
    private String urls;

    /**
     * 图片Id
     */
    private String storageIds;

    /**
     * 分数
     */
    private Double score;

    /**
     * 评论时间
     */
    private Date createTime;

    // 课节开始时间
    private Date startTime;

    // 课节结束时间
    private Date endTime;
    /**
     * 得分描述
     */
    private String scoreDes;

    private String customFastComment; // 自定义快速评价json

    public void setScore(Double score) {
        this.score = score;
        if (score > Biz.HIGH_SCORE) {
            scoreDes = CommentReqType.HIGN_SCORE.getMessage();
        } else if (score < Biz.LOW_SCORE) {
            scoreDes = CommentReqType.LOW_SCORE.getMessage();
        }
    }

}
