
package com.baijia.tianxiao.sal.club.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.dal.club.dao.OrgVipDao;
import com.baijia.tianxiao.dal.club.po.OrgVip;
import com.baijia.tianxiao.sal.club.OrgVipService;

@Service
public class OrgVipServiceImpl implements OrgVipService {
    
    @Autowired
    private OrgVipDao orgVipDao;
    
    @Override
    public OrgVip getSingleNormalOrgVip(Integer orgId) {
        return orgVipDao.getNormalOrgVip(orgId);
    }

    @Override
    public void updateOrgVip(OrgVip orgVip) {
        orgVipDao.saveOrUpdate(orgVip);
    }

    @Override
    public OrgVip getLastOrgVip() {
        return orgVipDao.getLastOrgVip();
    }

    @Override
    public void saveAll(List<OrgVip> orgVips) {
        orgVipDao.saveAll(orgVips);
    }

    @Override
    public List<OrgVip> getOrgVipByOrgNumber(Integer orgNumber) {
        return orgVipDao.getByOrgNumber(orgNumber);
    }
    
    @Override
    public List<OrgVip> getTotalOrgVipByOrgNumber(Integer orgNumber) {
        return orgVipDao.getTotalByOrgNumber(orgNumber);
    }

}

    